<?php
/*
	Esprit Registration System
	by Stephanie Mitchell
	TEST Registration Form
	8 May, 2015.
	Updated to include SO and Add. Family registrations on the same form.
*/

define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
if (TESTING) {	// TESTING constant is set in config.php
	$today_text = (isset($_REQUEST['date']) ? $_REQUEST['date'] : 'now');
	$test_msg = 'TEST';
} else {
	die('This form can only be used in TEST mode');
 	$today_text = 'now';
 	$test_msg = '';
}

$password = (isset($_REQUEST['password']) ? $_REQUEST['password'] : false);
$form_type = "Resource_Presenter";	//	MUST match one of the rate groups in config.php
						//	(Single, SO etc.)
require_once "classes.php";	//	Pull in everything
?>
<html>
<?php require_once "head.php";?>
<body>
<?php
if ($check['preregistration_closed']) {
	print closed($form_type, $date_text['registration_closed']);
	exit;
}
if ($check['registration_not_yet_open']) {
	print notyetopen($form_type, $date_text['registration_open']);
	exit;
}
print masthead('Attendees');
?>
<div class="section">
	<div class="headerbar">Instructions</div>
	<ol>
		<li>This TEST form is for registering attendees and doing testing. You can <a href="../index.php">return to Registration Start</a> and select another form.</li>
		<?php
		if ($today < $date['payment_deadline']) {
			print "<li>Our mailing address is:<br />
				<br /> $esprit_address<br />
				<br />
				</li>";
		}?>
		<li> We urge you to refer to these Help buttons<?php print helpbutton('helpbuttonhelp.php');?> for lots of useful information and guidance.</li>
	</ol>
	<p class="tiny">All information is kept strictly confidential.</p>
</div>
<form action="../process.php" method="post" enctype="multipart/form-data" name="form1" id="formID">

<?php
print form_switches(array('Resource_Presenter'));
print esprit_names(array('Resource_Presenter'));
require_once "bill_contact.php";

/*
	Create the rate tables for each selected type.
*/
$rates = new ratetable;
print $rates->preamble($form_type);
print '<table width="100%">
	<tr>';

//	Following call uses test version of ratetable tabletest!

print '<td>' . $rates->tabletest('reg', $form_type, 'You') . '</td>';
print '</tr></table>';

/*
	Create the scholarship application section.
*/

print '<table width="100%">';
	print scholapp($check['scholarships_open'], $form_type);
print '</table>';
print $rates->postamble();

/*
	Add-ons
*/
print other_purchases($form_type);
	
/*
	Gather the badge photo(s).
*/
$badge = new badgephoto;
print $badge->preamble($form_type);	//	Preamble
print '<table width="100%">
	<tr>';
print '<td>' . $badge->table('reg', $form_type, 'You') . '</td>';
print '</tr></table>';
print $badge->postamble();	//	Postamble
/*
	The fine print section
*/

require_once "fine_print.php";

?>
<div><!-- Hidden fields required by this form, plus form submit button -->	
	<input type="hidden" name="noupload[source_form_type]" testdata="no" id="source_form_type" value="Attendee" />
	<input type="hidden" name="password" id="password" value="<?php print $password;?>" />

	<input type="submit" id="postbut" name="Submit Pre-Registration" value="Submit Pre-Registration" />
</div>
</form>
</body>
</html>
