<?php
/*
	Esprit Scholarship  System
	by Stephanie Mitchell
	Application Form
	21 September, 2013
	Updated to remove reliance on Forms to Go, which is no longer supported.
*/

define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
if (TESTING) {	// TESTING constant is set in config.php
	$today_text = (isset($_REQUEST['date']) ? $_REQUEST['date'] : 'now');
	$test_msg = 'TEST';
} else {
 	$today_text = 'now';
 	$test_msg = '';
}

$override = (isset($_REQUEST['override']) ? $_REQUEST['override'] : false);
$overridden = ($override == $scholarship_override) || (strpos($_SERVER['HTTP_REFERER'], 'override='.$scholarship_override) >0);

$form_type = 'Scholarship';
// var_dump($_REQUEST);

?>
<html>
<?php
	require_once "head.php";
?>
<body>
<?php
if (!$_POST) {
	print 'This page cannot be used directly.';
	exit;
}

require_once "closed.php";

if (!$overridden and $check['scholarships_closed']) {
	print closed($form_type, $date_text['scholarships_closed']);
	exit;
}
if (!$overridden and $check['scholarships_not_yet_open']) {
	print notyetopen($form_type, $date_text['scholarships_open']);
	exit;
}
?>
<img src="../images/logo.gif" alt="" width="500" height="108" border="0" />
<h2><span class="i">Esprit</span> <?php print $esprit_year;?> Scholarship Application Form</h2>
<p>Thank you for considering an <span class="i">Esprit</span> Scholarship.
	Please use this page to complete and submit your application. Please complete all required fields; we cannot process your application if information is missing or incomplete. Please complete as many other items as you can.</p>
<p>Click these Help buttons <?php print helpbutton("helpbuttonhelp.php");?> for lots of additional information.</p>
<p>Please note: applying for a scholarship does NOT automatically register you for <span class="i">Esprit</span>. You must first complete an <span class="i">Esprit</span> pre-registration form; you will not be able to complete this form until you do. Make sure you indicate on that form that you've applied for a scholarship.</p>
<p>Please note: if you apply after the scholarship deadline your chances of being awarded a scholarship are very limited. <span class="bold">Applications made after Esprit has started will not be granted.</span></p>
<p>Please note that you'll have to provide the name and contact information for a reference. Please  take a moment to <?php print helpbutton("scholarshiprefhelp.php", "review this information.");?></p>
<p><span class="reqd reqdhilite">Fields highlighted like this</span> are required.</p>

<?php
/*	Connect to database and retrieve info from parameters. */

require_once ".regconnect.php"; // hostname, ID and password
$db['db'] = 'esprit';
$db['log'] = 'reglog';	// log file

require_once "mysql_utilities.php";
mysql_login();

/*
	Extract email and confirmation number from submitted form
*/
$post['email'] = $_REQUEST['reg']['Scholarship']['relto_email'];
$post['confirmation_no'] = $_REQUEST['noupload']['relto_conf'];
$sql = "SELECT *
FROM reg
WHERE confirmation_no={$post['confirmation_no']}
	AND email = \"{$post['email']}\"";
$result = @mysqli_query($GLOBALS['dbConnect'], $sql) or die('process.php: ERROR: '. mysqli_error() . 'Query=' .$sql);

$row = mysqli_fetch_assoc($result);	//	get the record. If there's more than one
									//	the result is undefined, but should not
									//	happen in real life.
mysql_logout();	//	Disconnect from database

$daytotal = $row['daysun1']+$row['daymon']+$row['daytue']+$row['daywed']
	+$row['daythu']+$row['dayfri']+$row['daysat']+$row['daysun2'];

global $esprit_year, $esprit_address, $esprit_address_text, $hist_book;


/*	Display data - cannot be edited. Also enter it into hidden fields for
	uploading when form is submitted. */
?>
<form action="../process.php" method="post" name="appform" id="formID">

	<input type="hidden" name="testing" value="<?php print $test_msg;?>" />
	<div class="section">
		<div class="headerbar">Applicant Information from Registration</div>
		<table width="100%" cellpadding="2">
			<tr>
				<td width="25%">Preferred Name:</td>
				<td>
				<?php
				print "<input type=\"hidden\" name=\"scholapp[Scholarship][preferredfirst]\" id=\"Scholarship__preferredfirst\" value=\"{$row['firstnamepref']}\"/>{$row['firstnamepref']}&nbsp;&nbsp";
				print "<input type=\"hidden\" name=\"scholapp[Scholarship][preferredlast]\" id=\"Scholarship__preferredlast\" value=\"{$row['lastnamepref']}\"/>{$row['lastnamepref']}";
				?>
				</td>
			</tr>
			<tr>
				<td width="25%">Legal Name:</td>
				<td>
				<?php
				print "<input type=\"hidden\" name=\"scholapp[Scholarship][legalfirst]\" id=\"Scholarship__legalfirst\" value=\"{$row['firstname']}\"/>{$row['firstname']}&nbsp;&nbsp";
				print "<input type=\"hidden\" name=\"scholapp[Scholarship][legallast]\" id=\"Scholarship__legallast\" value=\"{$row['lastname']}\"/>{$row['lastname']}";
				?>
				</td>
			</tr>
			<tr>
				<td width="25%">Email:</td>
				<td>
				<?php
				print "<input type=\"hidden\" name=\"scholapp[Scholarship][email]\" id=\"Scholarship__email\" value=\"{$row['email']}\"/>{$row['email']}&nbsp;&nbsp";?>
				</td>
			</tr>
			<tr>
				<td width="25%">Confirmation Number:</td>
				<td>
				<?php
				print "<input type=\"hidden\" name=\"noupload[preset_confirmation_no]\" id=\"Scholarship__confirmation_no\" value=\"{$row['confirmation_no']}\"/>{$row['confirmation_no']}&nbsp;&nbsp";?>
				</td>
			</tr>
			<tr>
				<td width="25%">Address*:</td>
				<td>
				<?php
				print "<input type=\"hidden\" name=\"scholapp[Scholarship][address1]\" id=\"Scholarship__address1\" value=\"{$row['address']}\"/>{$row['address']}&nbsp;&nbsp";
				print "<input type=\"hidden\" name=\"scholapp[Scholarship][address2]\" id=\"Scholarship__address2\" value=\"\"/>";?>
				</td>
			</tr>
			<tr>
				<td></td>
				<td>
				<?php
				print "<input type=\"hidden\" name=\"scholapp[Scholarship][city]\" id=\"Scholarship__city\" value=\"{$row['city']}\"/>{$row['city']}&nbsp;&nbsp";
				print "<input type=\"hidden\" name=\"scholapp[Scholarship][stateprov]\" id=\"Scholarship__stateprov\" value=\"{$row['state']}\"/>{$row['state']}";?>
				</td>
			</tr>
			<tr>
				<td></td>
				<td>
				<?php
				print "<input type=\"hidden\" name=\"scholapp[Scholarship][zippostal]\" id=\"Scholarship__zippostal\" value=\"{$row['zip']}\"/>{$row['zip']}";?>
				</td>
			</tr>
			<tr>
				<td></td>
				<td>
				<?php
				print "<input type=\"hidden\" name=\"scholapp[Scholarship][country]\" id=\"Scholarship__country\" value=\"{$row['country']}\"/>{$row['country']}";?>
				</td>
			</tr>
			<tr>
				<td width="25%">Phone number:</td>
				<td>
					<?php
					print "<input type=\"hidden\" name=\"scholapp[Scholarship][phone]\" id=\"Scholarship__phone\" value=\"{$row['phone']}\"/>{$row['phone']}&nbsp;&nbsp";?>
				</td>
			</tr>
			<tr>
				<td width="25%">Best time to call:</td>
				<td>
				<?php
				print "<input type=\"hidden\" name=\"scholapp[Scholarship][phonebesttime]\" id=\"Scholarship__phonebesttime\" value=\"{$row['besttimetocall']}\"/>{$row['besttimetocall']}&nbsp;&nbsp";?>
				</td>
			</tr>
			<tr>
				<td width="25%">Name to ask for:</td>
				<td>
					<?php
					print "<input type=\"hidden\" name=\"scholapp[Scholarship][phoneaskfor]\" id=\"Scholarship__phoneaskfor\" value=\"{$row['nametoaskfor']}\"/>{$row['nametoaskfor']}&nbsp;&nbsp";?>
				</td>
			</tr>
		</table>


		<?php print "<input type=\"hidden\" name=\"noupload[ratepkg]\" value=\"{$row['ratepkg']}\"/>";?>
		<?php print "<input type=\"hidden\" name=\"noupload[source_form_type]\" value=\"{$row['form_type']}\"/>";?>


	</div>
	<div class="section">
		<div class="headerbar">Eligibility Information</div>
		<table>
			<tr>
				<td width="25%"><div class="reqd reqdhilite">Travel factor<?php print helpbutton('travelfactorhelp.php');?><br /></div>
					<span class="tiny">Distance is considered when awarding scholarships.</span> </td>
				<td class="reqdhilite">
					<select name="scholapp[Scholarship][travelradius]" size="1" id="Scholarship__travelradius" class="validate[required]">
						<option value= "">Please choose</option>
						<option value="1">Portland, Seattle, Spokane</option>
						<option value="2">BC Lower Mainland, Van. Island, Olympic peninsula</option>
						<option value="3">Continental US and Canada</option>
						<option value="4">Mexico</option>
						<option value="5">Europe</option>
						<option value="6">New Zealand</option>
						<option value="7">Other</option>
					</select>
				</td>
			</tr>
			<tr>
				<td width="25%"><div class="reqd reqdhilite">How many <i>Esprit</i>s have you attended?<?php print helpbutton('howmanyespritsscholhelp.php');?></div></td>
				<td class="reqdhilite">This is my
					<select name="scholapp[Scholarship][timesattended]" size="1" id="Scholarship__timesattended" class="validate[required]">
						<option value= "">Please choose</option>
						<option value="1">first</option>
						<option value="2">second</option>
						<option value="3">third</option>
						<option value="4">fourth</option>
						<option value="5">fifth</option>
						<option value="6">more than fifth</option>
					</select>
					Esprit</td>
			</tr>
			<tr>
				<td width="25%"><div class="reqd reqdhilite">Application category<?php print helpbutton('scholarshipcategoryhelp.php');?></div>
					<span class="tiny">Please select all that apply to you.</span> </td>
				<td class="reqdhilite">

				<input class="validate[minCheckbox[1]]" type="checkbox" name="noupload[Scholcat]" id="category01" onClick="this.form.Scholarship__category01.value=this.checked?this.value:'';" value="First timer"/>First timer
					<input name="scholapp[Scholarship][category01]" type="hidden" id="Scholarship__category01" value=""><br />
	
				<input class="validate[minCheckbox[1]]" type="checkbox" name="noupload[Scholcat]" id="category02" onClick="this.form.Scholarship__category02.value=this.checked?this.value:'';" value="International"/>International
					<input name="scholapp[Scholarship][category02]" type="hidden" id="Scholarship__category02" value=""><br />

				<input class="validate[minCheckbox[1]]" type="checkbox" name="noupload[Scholcat]" id="category03" onClick="this.form.Scholarship__category03.value=this.checked?this.value:'';" value="Couple"/>Couple
					<input name="scholapp[Scholarship][category03]" type="hidden" id="Scholarship__category03" value=""><br />
	
				<input class="validate[minCheckbox[1]]" type="checkbox" name="noupload[Scholcat]" id="category04" onClick="this.form.Scholarship__category04.value=this.checked?this.value:'';"  value="Financial Need"/>Financial Need
					<input name="scholapp[Scholarship][category04]" type="hidden" id="Scholarship__category04" value="">
				</td>
			</tr>
			<tr>
				<td width="25%"><div class="reqd reqdhilite">Reason for Scholarship<?php print helpbutton('scholarshipreasonhelp.php');?></div>
				<span class="tiny">Please describe in your own words, and include a statement explaining your specific financial need.</span></td>
				<td><div class="reqd"><textarea id="Scholarship__reasonforapplying" rows="13" cols="60" name="scholapp[Scholarship][reasonforapplying]" class="validate[required]" /></textarea></td>
			</tr>
			<tr>
				<td width="25%"><div class="reqd reqdhilite">Please indicate your income level<?php print helpbutton('scholarshipincomehelp.php');?></div>
					<span class="tiny">This item is important in determining your scholarship amount</span>
				</td>
				<td class="reqdhilite">
					<select name="scholapp[Scholarship][incomelevel]" size="1" id="Scholarship__incomelevel" class="validate[required]">
						<option value= "">Select...</option>
						<option value="1">Welfare</option>
						<option value="2">Poverty</option>
						<option value="3">Low Income</option>
						<option value="4">Middle Income</option>
						<option value="5">Upper Income</option>
					</select>
				</td>
			</tr>
		</table>
	</div>
	<div class="section">
	<div class="headerbar">Reference</div>
	<table width="100%">
		<tr>
			<td width="25%"><div class="reqd reqdhilite">Reference's name<?php print helpbutton('scholarshiprefhelp.php');?></div>
				<span class="tiny">Please provide the name and contact information of someone local to you who can vouch for you.</span>
			</td>
			<td><div class="reqdhilite">
				<input class="validate[required]" type="text" name="scholapp[Scholarship][reference]" size="24" id="Scholarship__reference" /></div>
			</td>
		</tr>
		<tr>
			<td width="25%"><div class="reqd reqdhilite">Reference's email<?php print helpbutton('scholarshiprefemailhelp.php');?></div></td>
			<td><div class="reqdhilite">
				<input class="validate[required,custom[email]]" type="text" name="scholapp[Scholarship][referenceemail]" id="Scholarship__referenceemail" size="24" /></div>
			</td>
		</tr>
		<tr>
			<td width="25%"><div class="reqd reqdhilite">Reference's club or affiliation or phone number<?php print helpbutton('scholarshiprefaffilhelp.php');?></div>
				 <span class="tiny">The club, society or organisation your reference belongs to, or &quot;None&quot;</span></td>
			<td><div class="reqdhilite"><input class="validate[required]" type="text" name="scholapp[Scholarship][referenceorg]" size="66" maxlength="100" id="Scholarship__referenceorg" /></div>
			</td>
		</tr>
		<tr>
			<td width="25%">Additional Remarks<?php print helpbutton('scholarshipremarkshelp.php');?><br />
				<span class="tiny">Please use this space for any other information you feel we should have.</span></td>
			<td>
				<textarea name="scholapp[Scholarship][notes]" id="Scholarship__notes" rows="13" cols="60"></textarea>
			</td>
		</tr>
	</table>
	</div>
	<div class="section">
		<div class="headerbar">The Fine Print</div>
		<table width="100%">
			<tr>
				<td colspan="2"><p class="bold reqd">Please read this carefully.</p>
				<p class="bold">By submitting this application, I declare that all information herein is complete and correct.</p>
				<p class="bold">If applying for a couples scholarship, we declare that we are in a legally recognized marital relationship or we have shared the same physical residence for the last 12 months.</p>
				</td>
			</tr>
		</table>
	</div>
	<input type="hidden" name="noupload[source_form_type]" testdata="no" id="source_form_type" value="Scholarship" />
	<input type="hidden" name="noupload[password]" id="Scholarship__password" value="<?php print $password;?>" />
	<input type="hidden" name="noupload[override]" id="Scholarship__override" value="<?php print $override;?>" />
	<input type="hidden" name="scholapp[Scholarship][daysattending]" id="Scholarship__daysattending" value="<?php print $daytotal;?>" />
	<input type="hidden" name="noupload[form_type]" id="Scholarship__form_type" value="<?php print $form_type;?>" />
	<input type="hidden" name="scholapp[Scholarship][status]" id="Scholarship__status" value="New" />
	<input type="hidden" name="noupload[testmode]" id="Scholarship__testmode" value="<?php print TESTING ? 1 : 0;?>" />
\	<input type="submit" id="postbut" name="Submit Pre-Registration" value="Submit Application" />
</form>
</body>
</html>
