<?php
/*
	Esprit Registration System
	by Stephanie Mitchell
	Presenter Registration Form
	8 May, 2015.
	Updated to include Assistant registrations on the same form.
*/

define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
if (TESTING) {	// TESTING constant is set in config.php
	$today_text = (isset($_REQUEST['date']) ? $_REQUEST['date'] : 'now');
	$test_msg = 'TEST';
} else {
 	$today_text = 'now';
 	$test_msg = '';
}

$password = (isset($_REQUEST['password']) ? $_REQUEST['password'] : false);
$form_type = "Resource_Presenter";	//	MUST match one of the rate groups in config.php
						//	(Single, SO etc.)
require_once "classes.php";	//	Pull in everything
?>
<html>
<?php
	require_once "head.php";
?>
<script type="text/javascript">
/*	Hide the business info block initially. */
jQuery(document).ready(function(){
	nevershow('.bus', 'Business')})
</script>
<body>
<?php
if ($check['preregistration_closed']) {
	print closed($form_type, $date_text['registration_closed']);
	exit;
}
if (!$check['presenter_preregistration_open']) {
	print notyetopen($form_type, $date_text['presenter_registration_open']);
	exit;
}
print masthead('Presenters');

?>
<div class="section">
	<div class="headerbar">Instructions</div>
	<ol>
		<li><span class="bold">Use this form only if you are an Esprit Presenter.</span> To select a different form, please <a href="../index.php">return to Registration Start</a></li>
		<li>You can use this form to register yourself and your presentation. You can also optionally register a business (such as consultation or sales) and one assistant.</li>
		<li>To register additional businesses or presentations, you can return to the Registration Start page afterwards.</li>
		<li> <span class="reqd reqdhilite">Fields highlighted like this</span> are required.</li>
		<li>Once your registration is received and confirmed, our Vendor Coordinator will contact you to confirm any other details. Your official Registration Letter will arrive via email shortly.</span></li>
		<?php print "<li>Print, sign and mail the Registration Letter to confirm your registration. Your letter must be received no later than {$date_text['payment_deadline']}. Print a second copy for your records.</li>";
		if ($today < $date['payment_deadline']) {
			print "<li>Our mailing address is:<br />
				<br /> $esprit_address<br />
				<br />
				</li>";
		}?>
		<li> We urge you to refer to these Help buttons<?php print helpbutton('helpbuttonhelp.php');?> for lots of useful information and guidance.</li>
	</ol>
	<p class="tiny">All information is kept strictly confidential.</p>
</div>
<form action="../process.php" method="post" enctype="multipart/form-data" name="form1" id="formID">

<?php
print form_switches(array($form_type, 'Assistant'));
print esprit_names(array($form_type, 'Assistant'));
require_once "bill_contact.php";

/*
	Create the rate tables for each selected type.
*/
$rates = new ratetable;
print $rates->preamble($form_type);
print '<table width="100%">
	<tr>';
/*	Trailing false parameter below means presenter is not automaticaslly eligible for
	brunch and we shouldn't offer it. (They can select it as their free meal, though.) */
print '<td>' . $rates->table('reg', $form_type, 'You', false) . '</td>';
/*	Trailing false parameter below means assistant is not eligible for brunch and we
	shouldn't offer it. */
print '<td class="as">' . $rates->table('reg', 'Assistant', 'Your Assistant', false) . '</td>';
print '</tr></table>';
print $rates->postamble();

/*
	Add-ons
*/
print other_purchases($form_type);


/*	See what other roles are required. Parameters are presenter, vendor. */
require_once "other_roles.php";
print other_roles($form_type, true, false);
/*
	Presentation info sections
*/
require_once "presentationdoc.php";

/*
	Business info sections
*/
require_once "businessdoc.php";

/*
	Gather the badge photo(s).
*/
$badge = new badgephoto;
print $badge->preamble($form_type);	//	Preamble
print '<table width="100%">
	<tr>';
print '<td>' . $badge->table('reg', $form_type, 'You') . '</td>';
print '<td class="as">' . $badge->table('reg', 'Assistant', 'Your Assistant') . '</td>';
print '</tr></table>';
print $badge->postamble();	//	Postamble

/*
	Gather the vax certificates.
*/
$vaxcert = new vaxcertificate;
print $vaxcert->preamble($form_type);	//	Preamble
print '<table width="100%">
	<tr>';
print '<td>' . $vaxcert->table('reg', $form_type, 'You') . '</td>';
print '<td class="as">' . $vaxcert->table('reg', 'Assistant', 'Your Assistant') . '</td>';
print '</tr></table>';
print $vaxcert->postamble();	//	Postamble

/*
	The fine print section
*/

require_once "fine_print.php";

?>
<div><!-- Hidden fields required by this form, plus form submit button -->	
	<input type="hidden" name="noupload[source_form_type]" testdata="no" id="source_form_type" value="Resource_Presenter" />
	<input type="hidden" name="password" id="password" value="<?php print $password;?>" />

	<input type="submit" id="postbut" name="Submit Pre-Registration" value="Submit Pre-Registration" />
</div>
</form>
</body>
</html>
