<?php
/*
	Functions for sending emails from the registration system.

	UPDATED to use PHPMailer v6.0 on 23 July 2017. The previous version is
	in process_emails5.php.
	
	Modified 5 August 2020 to enhance process_email to merge fixed (template-like) data
	with variable (recipient-specific) data. This enables it to do mail-merge, bulk-mail
	and (gasp!) spam-like functions.

	UPDATED to use PHPMailer v6.2 on 5 January 2021.
*/

function cap_print($var, $init = false, $print = false) {

/*	Capture debugging output for emailing to developer */

	static $capout;
	if ($init) {
		$capout = '';
	} else {
		if (is_array($var)) {
			$pvar = '<pre>' . print_r($var, true) . '</pre><br /<br />';
		} else {
			$pvar = $var;
		}
		$capout .= $pvar;
		if ($print) print $capout;
		else return $capout;
	}
}

function send_debug_email($printonly = false) {	

/*	Send debugging info after all emails are sent */

	if ($printonly) {	//	Print locally?
		cap_print(null, false, true);
		exit;
	}

	$debug = new PHPMailer\PHPMailer\PHPMailer;

$mp = $GLOBALS['mailer_params'];	//	Shorten the code a bit :-)
$mpid = $GLOBALS['mailer_ids'];		//	separated so as not to appear in debugging emails

//	print '<br /><pre>'; print_r($mp);print '</pre><br />';
//	die(__LINE__);

/*	Note that $GLOBALS['mailer_params'] has different values depending on whether we're
	on the developer or production server. See .config.php for details.
	
	Following code inserts those values into the $debug object.
*/
	$debug->Host = $mp['Host'];				//	Specify mail server
	$debug->SMTPAuth = $mp['SMTPAuth'];		//	Enable SMTP authentication
	$debug->Username = $mpid['Username'];	// SMTP username
	$debug->Password = $mpid['Password'];	// SMTP password
	$debug->From = $mp['From'];
	$debug->AddAddress($mp['AddAddress'][0], $mp['AddAddress'][1]);	// Add a recipient
	$debug->SMTPSecure = $mp['SMTPSecure'];	//	Use ssl connection
	$debug->Port = $mp['Port'];			//	on this port

	$debug->SMTPDebug = MAIL_DEBUG_LEVEL;	//	Uncomment these two lines
	$debug->Debugoutput = 'html';			//	for debugging output

	$debug->IsHTML(true);					//	Set email format to HTML
	
/*	Insert required extra values */
	$debug->IsSMTP();						//	Set mailer to use SMTP
	
	$debug->FromName = 'Mail Debugger';		//	Not copied from config.php!
	$debug->Subject = 'Mail Debug Output';
	$debug->Body = cap_print(null, false, false);
	if(!$debug->Send()) {
		print 'Debug Message could not be sent.';
		print 'Debug Mailer Error: ' . $debug->ErrorInfo;
	}
}

function process_email($fixed, $row) {

/*
	Compose and send email based on the contents of the $row parameter. This version
	can be called repeatedly, with successive database rows being provided in the $row
	array. Stuff in the $fixed array is constant for all invocations (such as template,
	sender, CC, BCC etc.)
	
	$fixed['sendmail_from']		sender email address
	$row['sendmail_to']			recipient email address
	$fixed['sendmail_replyto']	replyto email address
	$row['sendmail_subject']	subject line (evaluate each time)
	$fixed['sendmail_cc']		cc email address
	$fixed['sendmail_bcc']		bcc email address
	$row['sendmail_html']		HTML format (not used)
	$fixed['sendmail_body']		message body in HTML format (evaluate each time)
	$fixed['letter_name']		name of letter in letters table (not used)
	$fixed['sendmail_group']		not used?
	$row['sendmail_name']		not used?
	$row['letter_group']		group to which this letter belongs (not used here except
								in debug trace email)
	$row['letter_id']			ID number of letter in regletters table (not used here
								except in debug trace email)
*/

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	require_once('setup.php');
	
//	New requires for PHPMailer 6.9.1
	require_once "PHPMailer/src/PHPMailer.php";
	require_once "PHPMailer/src/SMTP.php";
	require_once "PHPMailer/src/Exception.php";

	require_once "process_functions.php";
	if (!defined('SMARTY_DIR')) {
		define('SMARTY_DIR', "{$_SERVER['DOCUMENT_ROOT']}/lib/smarty/");
	}
	require_once SMARTY_DIR.'Smarty.class.php';
	require_once "mysql_utilities.php";
	mysql_login('Normal');

/*	First log where we were called from */

	$bt = debug_backtrace(0);
	cap_print("<br/><b>Backtrace:</b><br />");
	foreach($bt AS $this_bt) {
		cap_print("{$this_bt['file']} called from {$this_bt['function']}/{$this_bt['line']}<br />");
	}
	cap_print('Server variables: $_SERVER:');
	cap_print($_SERVER);


	/*	Gather the data. */

	$e = new Smarty() or die('Could not create Smarty instance');
	$e->addPluginsDir("{$_SERVER['DOCUMENT_ROOT']}/plugins/");
	$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/templates/");

	$e->assign('mydata', $row);	//	Get all variable data
	$e->assign('globals', $GLOBALS);

/*
	The following are fixed-value fields from the template.
*/
	$r['letter_from'] = $fixed['sendmail_from'];
	$r['letter_replyto'] = $fixed['sendmail_replyto'];
	$r['letter_cc'] = $fixed['sendmail_cc'];
	$r['letter_bcc'] = $fixed['sendmail_bcc'];
/*
	The following are re-evaluated each time based on row contents
*/
	$r['letter_to'] = $e->fetch('string:' . $row['sendmail_to']);
	$r['letter_subject'] = $e->fetch('string:' . $fixed['sendmail_subject']);
	$r['letter_body'] = $e->fetch('string:' . $fixed['sendmail_body']);
	
	$orig_r = $r;	//	Keep for debugging

	/*	Begin the email */

	$mail = new PHPMailer\PHPMailer\PHPMailer;
	
	$mp = $GLOBALS['mailer_params'];	//	Shorten the code a bit :-)
	$mpid = $GLOBALS['mailer_ids'];		//	separated so as not to appear in debug emails

	cap_print('<b>Mailer parameters from .config.php</b><br />');
	cap_print($mp);

/*	Note that $GLOBALS['mailer_params'] has different values depending on whether we're
	on the developer or production server. See .config.php for details.
	
	Following code inserts those values into the $mail object.
*/

	$mail->Host = $mp['Host'];			//	Specify mail server
	$mail->SMTPAuth = $mp['SMTPAuth'];	//	Enable SMTP authentication
	$mail->Username = $mpid['Username'];	// SMTP username
	$mail->Password = $mpid['Password'];	// SMTP password
	$mail->From = $mp['From'];
	$mail->FromName = $mp['FromName'];
	$mail->AddAddress($mp['AddAddress'][0], $mp['AddAddress'][1]);	// Add a recipient
	$mail->SMTPSecure = $mp['SMTPSecure'];	//	Use ssl connection
	$mail->Port = $mp['Port'];			//	on this port

/*	Insert required extra values */

	$mail->IsSMTP();						//	Set mailer to use SMTP
	$mail->FromName = 'Esprit Online Registration';

	/*	Hardcoded test addresses */
	
	$testing_text = (TESTING ? 'TEST' : '');
	if (TESTING === true) {
		$mail->SMTPDebug = MAIL_DEBUG_LEVEL;	//	Include debugging output 
		$mail->Debugoutput = 'html';			//	while testing
		cap_print('<br /><span style="bgcolor:yellow; font-weight:bold">Addresses overridden for testing!</span><br />');
		$r['letter_to'] = "Stephanie Mitchell|stephanie@cornbury.org";
		$r['letter_cc'] = 'stephanie@cornbury.org';
		$r['letter_bcc'] = 'stephanie@cornbury.org';
	}
	/*	Parse out addresses and names */
	/*	This is kind of weird. Email addresses are in the form
		Visible Name <email@domain.com>
		but for some reason the <email@domain.com> part gets treated as an HTML tag. In
		some places the tag contents aren't displayed at all, in others a closing bogus
		</email@domain.com> tag is added.
		To circumvent this, in the database, the email formatted thus:
		
		Visible Name|email@domain.com,Another Recip|another@domain.com
		
		The data is split up as required.
		
		NOTE: In 2018 all email addresses of the form recipient@espritgala.org were
		decommissioned, except those related to actually sending and troubleshooting
		email. The $mail_aliases table in .config.php maps recipient@espritgala.org
		addresses into real personal emails. The DeAlias function handles the actual
		mapping.
	*/
	
	if ($r['letter_to'] != '') {			//	Add all To addresses
		$t = explode(",", $r['letter_to']);
		foreach ($t as $this_line) {
			$this_addr = explode('|', $this_line);
			if (count($this_addr) == 1) {	//	Nameless recipient
				$darray = explode(',',DeAlias($this_addr[0]));	// comma-separated
				foreach($darray as $da) {
					$mail->addAddress($da);
					cap_print("<br />To: address dealiased from {$this_addr[0]}: address={$da}");
				}
			} else {						//	Named recipient
				$darray = explode(',',DeAlias($this_addr[1]));	// comma-separated
				foreach($darray as $da) {
					$mail->addAddress($da, $this_addr[0]);
					cap_print("<br />To: address dealiased from {$this_addr[0]}: address={$da}");
				}
			}
// 			print "Added {$this_addr[0]}, {$this_addr[1]}<br />";
			cap_print("<br />To: address added: name={$this_addr[0]}, address={$this_addr[1]}; DeAlias result: $da; Original: {$orig_r['letter_to']}");
		}
	}

	if ($r['letter_replyto'] == '') {			//	Add ReplyTo address
		$mail->addReplyTo('no-reply@espritgala.org', 'DO NOT REPLY');
	} else {			//	Add replyTo address
		$t = explode(",", $r['letter_replyto']);
		foreach ($t as $this_line) {
			$this_addr = explode('|', $this_line);
			if (count($this_addr) == 1) {	// Nameless ReplyTo
				$da = DeAlias($this_addr[0]);
				$mail->addReplyTo($da);
			} else {						//	Named ReplyTo
				$da = DeAlias($this_addr[1]);
				$mail->addReplyTo($da, $this_addr[0]);
			}
			cap_print("<br />ReplyTo: address added: name={$this_addr[0]}, address={$this_addr[1]}; DeAlias result: $da; Original: {$orig_r['letter_replyto']}");
		}
	}

	$mail->addReplyTo('no-reply@espritgala.org', 'DO NOT REPLY');

	if ($r['letter_cc'] != '') {			//	Add all CC addresses
		$t = explode(",", $r['letter_cc']);
		foreach ($t as $this_line) {
			$this_addr = explode('|', $this_line);
			if (count($this_addr) == 1) {	// Nameless CC
				$darray = explode(',',DeAlias($this_addr[0]));	// comma-separated
				foreach($darray as $da) {
					$mail->addCC($da);
				}
			} else {						//	Named CC
				$darray = explode(',',DeAlias($this_addr[1]));	// comma-separated
				foreach($darray as $da) {
					$mail->addCC($da, $this_addr[0]);
				}
			}
			cap_print("<br />CC: address added: name={$this_addr[0]}, address={$this_addr[1]}; DeAlias result: $da");
		}
	}

	if ($r['letter_bcc'] != '') {			//	Add all BCC addresses
		$t = explode(",", $r['letter_bcc']);
		foreach ($t as $this_line) {
			$this_addr = explode('|', $this_line);
			if (count($this_addr) == 1) {
				$darray = explode(',',DeAlias($this_addr[0]));	// comma-separated
				foreach($darray as $da) {
					$mail->addBCC($da);	// Nameless BCC
				}
			} else {
				$darray = explode(',',DeAlias($this_addr[1]));	// comma-separated
				foreach($darray as $da) {
					$mail->addBCC($da, $this_addr[0]);	// named BCC
				}
			}
			cap_print("<br />Bcc: address added: name={$this_addr[0]}, address={$this_addr[1]}; DeAlias result: $da");
		}
	}

	$mail->WordWrap = 80;				// Set word wrap to 80 characters
	$mail->Subject = $r['letter_subject'];
	$mail->MsgHTML($r['letter_body']);	// Generate HTML and plaintext versions
	cap_print("<br />Email is being sent to:<br />
	From={$r['letter_from']}<br />
	To={$r['letter_to']}<br />
	ReplyTo=do-not-reply@cornbury.org (DO NOT REPLY)<br />
	Cc={$r['letter_cc']}<br />
	Bcc={$r['letter_bcc']}<br />
	Subject={$r['letter_subject']}<br />
	Body={$r['letter_body']}<br />
	<br />
	Traceline=<br /><br />LetterID: {$row['letter_group']}/{$row['letter_name']}/{$row['letter_id']}<br />");		

	/* Send the completed email! */
	
	Make_Email_Log_Entry($r, $_REQUEST['dirname'],  'Attempting email send');
	
	if(!$mail->Send()) {
		print 'Message could not be sent. Mailer Error: ' . $mail->ErrorInfo;
		Make_Email_Log_Entry($r, $_REQUEST['dirname'],  'Message could not be sent. Mailer Error: ' . $mail->ErrorInfo);
	} else {
		Make_Email_Log_Entry($r, $_REQUEST['dirname'], 'Message successfully sent');
	}
}
?>