<?php
/*
	Addon SQL Utilities. These work with the addon functionality for adding
	items from a database for purchase at registration time.
*/
/*
	get_addon_types
	Returns array of unique addon types that are allowed for a given form type.
	Empty $form_type means return everything;
	otherwise $form_type must appear in comma-separated addon_show field.
	If addon_show is "*", always return value;
	otherwise $form_type must appear in addon_show.
	otherwise 
*/
function get_addon_types($form_type = '') {

	$form_type = normalise_form_type($form_type);
	$sql = "SELECT DISTINCT addon_type FROM regaddons ";
	if ($form_type != '') {
		$sql .= "WHERE addon_show = '*' OR CONCAT(SUBSTRING_INDEX(addon_show, '#', 1), ',') LIKE \"%$form_type%\"";
	}
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FUNCTION__.': MySQL error: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
	$r = array();
	while ($row = mysqli_fetch_assoc($result)) {
		$r[] = $row['addon_type'];
	}
// 	print $sql . '<br />';
// 	print_r($r);
	return $r;
}

/*
	get_addon_items
	Returns array of addon items appropriate for the $form_type passed. See
	get_addon_types for how that's determined. This is broken into subarrays for each
	addon_type.
*/
function get_addon_items($form_type = '') {

	$form_type = normalise_form_type($form_type);
/*
	Check for online Esprit instead of in-person, restrict offerings
*/
	
	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	
	require_once "online_switch.php";
	$online_esprit = (ONLINE_ESPRIT == true ? 'AND addon_online_esprit = "Yes"': 'AND addon_online_esprit != "Yes"');

	$sql = "SELECT * FROM regaddons ";
	if ($form_type != '') {
		$sql .= "WHERE addon_show = '*' OR CONCAT(SUBSTRING_INDEX(addon_show, '#', 1), ',') LIKE \"%$form_type%\"
		$online_esprit";
	}
	$sql .= ' ORDER BY addon_type, addon_name, addon_show';
//	print $sql . '<br />';
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FUNCTION__.': MySQL error: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
	$r = array();
	$thistype = '';
	while ($row = mysqli_fetch_assoc($result)) {
		if ($thistype != $row['addon_type']) {
			$thistype = $row['addon_type'];
		}
		(array)$r[$thistype][] = $row;
	}
//  	print $sql . '<br />';
//  	print '<pre>; print_r($r); print '</pre>';
	return $r;
}

/*
	get_addon_list_on_hand
	Returns array of addon items appropriate for the $form_type passed. See get_addon_types for how that's determined. This is just a straight array
	with no breakdown into subarrays by addon_type.
*/
function get_addon_list_on_hand($form_type = '') {

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";

	mysql_login('Read-only');
	
	require_once("online_switch.php");

	$form_type = normalise_form_type($form_type);
/*
	Check for online Esprit instead of in-person, restrict offerings
*/
	$online_esprit = (ONLINE_ESPRIT == true ? 'AND addon_online_esprit = "Yes"': 'AND addon_online_esprit != "Yes"');

	$sql = "SELECT * FROM regaddons a";
	if ($form_type != '') {
		$sql .= " WHERE (a.addon_show='*' OR CONCAT(SUBSTRING_INDEX(a.addon_show, '#', 1), ',') LIKE \"%$form_type%\")
		AND (a.addon_stocklimit=0
		OR a.addon_stocklimit>(SELECT sum(r.quantity) FROM regpayment r WHERE r.addon_key=a.addon_id
		AND r.confirmation LIKE \"{$GLOBALS['esprit_yy']}%\")
		OR (SELECT sum(r.quantity) FROM regpayment r WHERE r.addon_key=a.addon_id
		AND r.confirmation LIKE \"{$GLOBALS['esprit_yy']}%\") IS NULL)
		$online_esprit";
	}
	$sql .= ' ORDER BY addon_type, addon_name, addon_show';
 	print $sql . '<br />';
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FUNCTION__.': MySQL error: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
	$r = array();
	$thistype = '';
	while ($row = mysqli_fetch_assoc($result)) {
		$r[] = $row;
	}
//   	print $sql . '<br /><pre>';
//   	print_r($r); print '</pre>';
	return $r;
}


/*
	get_addon_list_on_hand_with_subs
	Returns array of addon items appropriate for the $form_type passed. See
	get_addon_types for how that's determined. This version also returns child
	addons, which are basically children of a parent add-on.
*/
function get_addon_list_on_hand_with_subs($form_type = '') {

	global $check;	//	Need this for rate tiers

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";

	mysql_login('Read-only');

	$form_type = normalise_form_type($form_type);
// die('At ' . __FILE__ . ':' . __LINE__ . " with form type $form_type");
/*
	Check for online Esprit instead of in-person, restrict offerings
*/
	require_once("online_switch.php");

	$online_esprit = (ONLINE_ESPRIT == true ? 'AND p.addon_online_esprit = "Yes"': 'AND p.addon_online_esprit != "Yes"');


$sql = "SELECT p.addon_name p_addon_name, c.addon_name c_addon_name,
	p.addon_id p_addon_id, c.addon_id c_addon_id,
	p.addon_type p_addon_type, c.addon_type c_addon_type,
	p.addon_show p_addon_show, c.addon_show c_addon_show,
	p.addon_parent p_addon_parent, c.addon_parent c_addon_parent,
	p.addon_read_more p_addon_read_more, c.addon_read_more c_addon_read_more,
	p.addon_desc p_addon_desc, c.addon_desc c_addon_desc,
	p.addon_desc_link p_addon_desc_link, c.addon_desc_link c_addon_desc_link,
	p.addon_ft_exclude p_addon_ft_exclude, c.addon_ft_exclude c_addon_ft_exclude, 
	p.addon_read_more p_addon_read_more, c.addon_read_more c_addon_read_more,
	p.addon_price p_addon_price, c.addon_price c_addon_price,
	p.tax p_tax, c.tax c_tax,
	p.addon_direct_amount p_addon_direct_amount,
	c.addon_direct_amount c_addon_direct_amount, 
	p.addon_stocklimit p_addon_stocklimit, c.addon_stocklimit c_addon_stocklimit,
	p.addon_max_signup p_addon_max_signup, c.addon_max_signup c_addon_max_signup,
	p.addon_postprocess p_addon_postprocess, c.addon_postprocess c_addon_postprocess,
	p.addon_weekday p_addon_weekday, c.addon_weekday c_addon_weekday,
	p.addon_tier1 p_a_t1, c.addon_tier1 c_a_t1,
	p.addon_tier2 p_a_t2, c.addon_tier2 c_a_t2,
	p.addon_tier3 p_a_t3, c.addon_tier3 c_a_t3,
	p.addon_tier4 p_a_t4, c.addon_tier4 c_a_t4,
	p.addon_tier5 p_a_t5, c.addon_tier5 c_a_t5,
	p.addon_tier6 p_a_t6, c.addon_tier6 c_a_t6
	FROM regaddons p
	LEFT JOIN regaddons c ON c.addon_parent=p.addon_id
		AND (p.addon_show = '*' OR CONCAT(SUBSTRING_INDEX(p.addon_show, '#', 1), ',') LIKE \"%$form_type%\")
		AND (c.addon_show = '*' OR CONCAT(SUBSTRING_INDEX(c.addon_show, '#', 1), ',') LIKE \"%$form_type%\")
	
	WHERE 
		p.addon_parent IS NULL
	AND (p.addon_stocklimit=0 OR (p.addon_stocklimit>(SELECT (if (sum(r.quantity) is null, 0, sum(r.quantity))) FROM regpayment r WHERE r.addon_key=p.addon_id
				AND r.confirmation LIKE \"{$GLOBALS['esprit_yy']}%\"))
	OR (c.addon_stocklimit=0 OR (c.addon_stocklimit>(SELECT (if (sum(s.quantity) is null, 0, sum(s.quantity))) FROM regpayment s WHERE s.addon_key=c.addon_id
				AND s.confirmation LIKE \"{$GLOBALS['esprit_yy']}%\"))))
	AND (p.addon_show = '*' OR CONCAT(SUBSTRING_INDEX(p.addon_show, '#', 1), ',') LIKE \"%$form_type%\")
	$online_esprit";
				
	if ($form_type != '') {
		$sql .= " ";
	}
	$sql .= ' ORDER BY p.addon_type, p.addon_name, p.addon_show';
//   	print $sql;
//   	die("In " . __FUNCTION__ . ":" . __LINE__);
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FUNCTION__.': MySQL error: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
	$r = array();
	$thistype = '';
	
	//	Get today's rate tier
		for ($tier_no = 1 ; $tier_no <= 6 ; $tier_no++) {
		if ($check['rate_tier'][$tier_no] == 1) {
			$this_tier = $tier_no;
			break;
		};
	}

	while ($row = mysqli_fetch_assoc($result)) {
		//	Filter out items which shouldn't appear based on tier
		$p_tier = $row["p_a_t$this_tier"];	//	Extract tier flags for current record
		$c_tier = $row["c_a_t$this_tier"];
		//	Filter out items which shouldn't appear based on first-timer exclusion
		$p_ft = $row["p_addon_ft_exclude"];	//	Extract FT exclusion flag
		$c_ft = $row["c_addon_ft_exclude"];
		if (($p_tier != 'No') and ($c_tier != 'No')	//	'Yes' or empty is ok
			and ($p_ft != 'Yes') and ($c_ft != 'Yes')) {	// Must be Yes to exclude
			$r[] = $row;
		}
// 		print "\$p_addon_name: {$row['p_addon_name']}; \$c_addon_name: {$row['c_addon_name']};<br />";
	}
//   	print $sql . '<br /><pre>';
//   	print_r($r); print '</pre>';
//   	exit;
	return $r;
}



/*
	get_addon_list_nodesc
	Returns array of addon items appropriate for the $form_type passed, but omits the sometimes lengthy description field. See get_addon_types for how
	that's determined. This is just a straight array with no breakdown into
	subarrays by addon_type.
*/
function get_addon_list_nodesc($form_type = '') {

	$form_type = normalise_form_type($form_type);

/*
	Check for online Esprit instead of in-person, restrict offerings
*/

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";

	require_once("online_switch.php");
	$online_esprit = (ONLINE_ESPRIT == true ? 'AND addon_online_esprit = "Yes"': 'AND addon_online_esprit != "Yes"');

	$sql = "SELECT addon_id, addon_type, addon_name, addon_show, addon_price, tax, addon_desc_link FROM regaddons ";
	if ($form_type != '') {
		$sql .= "WHERE addon_show = '*' OR CONCAT(SUBSTRING_INDEX(addon_show, '#', 1), ',') LIKE \"%$form_type%\"
		$online_esprit";
	}
	$sql .= ' ORDER BY addon_type, addon_name, addon_show';
//	print $sql . '<br />';
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FUNCTION__.': MySQL error: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
	$r = array();
	$thistype = '';
	while ($row = mysqli_fetch_assoc($result)) {
		$r[] = $row;
	}
//  	print $sql . '<br /><pre>';
//  	print_r($r); print '</pre>';
	return $r;
}

/*
	get_addon_list_hierarchical
	Returns array of addon items appropriate for the $form_type passed, but omits the sometimes lengthy description field. See get_addon_types for how
	that's determined. This is just a straight array with no breakdown into
	subarrays by addon_type.
*/
function get_addon_list_hierarchical($form_type = '') {

	$form_type = normalise_form_type($form_type);
/*
	Check for online Esprit instead of in-person, restrict offerings
*/

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";

	require_once("online_switch.php");
	$online_esprit = (ONLINE_ESPRIT == true ? 'AND p.addon_online_esprit = "Yes"': '');
	$online_esprit = '';

	$sql = "SELECT p.addon_name p_addon_name, c.addon_name c_addon_name,
	p.addon_id p_addon_id, c.addon_id c_addon_id,
	p.addon_type p_addon_type, c.addon_type c_addon_type,
	p.addon_desc_link p_addon_desc_link, c.addon_desc_link c_addon_desc_link,
	p.addon_price p_addon_price, c.addon_price c_addon_price,
	p.tax p_tax, c.tax c_tax,
	p.addon_show p_addon_show, c.addon_show c_addon_show,
	p.addon_weekday p_addon_weekday, c.addon_weekday c_addon_weekday,
	p.addon_parent p_addon_parent, c.addon_parent c_addon_parent
	FROM regaddons p
	LEFT JOIN regaddons c ON c.addon_parent=p.addon_id
	WHERE p.addon_parent IS NULL 
		AND (p.addon_show='*' OR CONCAT(SUBSTRING_INDEX(p.addon_show, '#', 1), ',') LIKE \"%$form_type%\")";
	if ($form_type != '') {
		$sql .= "WHERE addon_show = '*' OR CONCAT(SUBSTRING_INDEX(addon_show, '#', 1), ',') LIKE \"%$form_type%\"";
	}
	$sql .= "$online_esprit";

	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FUNCTION__.': MySQL error: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
	$r = array();
	$thistype = '';
	while ($row = mysqli_fetch_assoc($result)) {
		$r[] = $row;
	}
//  	print $sql . '<br /><pre>';
//  	print_r($r); print '</pre>';
// 	exit;
	return $r;
}

/*
	get_inventory_table
	Returns array of addon items showing stocklimit field (stock on hand, spaces allotted
	etc.) and stock sold/booked for reporting purposes.
*/
function get_inventory_table() {

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	
	require_once "mysql_utilities.php";

	mysql_login('Read-only');
/*
	Check for online Esprit instead of in-person, restrict offerings
*/
	require_once("online_switch.php");
	$online_esprit = (ONLINE_ESPRIT == true ? 'AND addon_online_esprit = "Yes"': 'AND addon_online_esprit != "Yes"');

	$sql = "SELECT a.addon_type type, r.pnotes name, a.addon_stocklimit stocklimit,
		 a.addon_id addon_id, a.addon_show appears_on, sum(r.quantity) sold
	 FROM regaddons a INNER JOIN regpayment r ON r.addon_key=a.addon_id
	 WHERE LEFT(r.confirmation, 2) = {$GLOBALS['esprit_yy']}
	 $online_esprit
	 GROUP BY a.addon_id
	 ORDER BY type, name";
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FUNCTION__.': MySQL error: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
	$r = [];
	while ($row = mysqli_fetch_assoc($result)) {
		$r[] = $row;
	}
	return $r;
}

/*
	normalise_form_type
	Appends a comma to the form_type being checked so form types that appear as substrings
	of other form_types don't get selected by mistake. For example, "SO" doesn't get selected by an add-on that is intended for "Resource_Vendor".
*/
function normalise_form_type($form_type) {
	if ($form_type == '' or $form_type == '*') {
		return $form_type;
	} else {
		return "$form_type,";
	}
}

/*
	Update tax on items with nonzero pricing
	Applies the WASTATE_TAX constant (defined in .config.php) to the price of the item.
	Zero-cost items are forced to 0 (in case they had a price before.)
*/
function update_tax($rate) {
	print "Attemtping to apply tax rate of $rate.";
	mysql_login();
	$sql = "UPDATE regaddons set tax=$rate*amount";
		$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FUNCTION__.': MySQL error: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);

	
}
?>