<?php
	/*	Gather vaccination certificates */
class vaxcertificate {

function preamble($form_type) {

	/*	Preamble code */
	
	$result = '<div class="section">
		<div class="headerbar"> Vaccination Certificate</div>';
		if(!VAXCERT_REQUIRED) {	//	Suppress Vax certificate code if not required
			$result .= '<p>Vaccination certificates not required now. However if state or federal regulations change, please be prepared to show proof of vaccination at checkin time.</p>';
		} else {
			$result .= '<p>You can provide a screenshot of your vaccination certificate. This must have been issued by your state or province or health authority.</p>';
		$result .= '<p class="bold">Certificate images must meet specific requirements.
			Please click here to review the ' . helpbutton('vaxcerthelp.php', 'Certificate requirements')
		. '.</p>';
		}	
	return $result;
}

function postamble() {
	
	/*	Postamble code */
	
	return '</div>';	//	Always close the div whether or not vax certs are required
}

function table($db, $form_type, $title) {

	if(!VAXCERT_REQUIRED) {	//	Only generate this if vax certs are required
		return '';
	}


	/*	Form content code */
	
	global $esprit_year;
	
	if (ONLINE_ESPRIT == true) {
		return '';
	} elseif (!VAXCERT_REQUIRED) {
		$result .= "<input class=\"invisible\" type=\"text\" value=\"Verified\">";
		return $result;
	} else {	
		$result = "<table width=\"100%\" class=\"section person\">";
		$result .= "<tr><td colspan=\"3\" class=\"headerbar\">$title</td></tr>";
	
		$result .= "<tr><td>";
		$result .= "<input type=\"radio\" name=\"{$db}[{$form_type}][reg_covid_flag]\" testdata=\"no\" class=\"validate[required] radio\" value=\"Use uploaded cert\" >";
		$result .="Please use this uploaded certificate image:
			<input type=\"file\" name=\"{$form_type}[suppliedcert]\" id=\"{$form_type}__suppliedcert\" /><br />";
		$result .= "<input type=\"radio\" name=\"{$db}[{$form_type}][reg_covid_flag]\" testdata=\"no\" class=\"validate[required] radio\" value=\"Review on arrival\" >I will present proof of vaccination on arrival<br />";
		$result .= "<input type=\"radio\" name=\"{$db}[{$form_type}][reg_covid_flag]\" testdata=\"no\" class=\"validate[required] radio\" value=\"Email/text submission\" >I will email or text my certificate from my device " . helpbutton('vaxcerttexthow.php', 'Learn how') . " <br />";
		$result .= "</td></tr></table>";
		return $result;
	}
}
}
?>