<?php
/*
	Generate input fields corresponding to each element of an array passed as a
	parameter. Each element is a field type to be displayed.
*/
function esprit_names(array $classes) {
	
	/*	Generate preamble */
	
	global $test_msg, $esprit_year;
	print "<!-- BEGIN section esprit_names -->";
	print "<div class=\"section\">";
	print "<input class=\"invisible\" name=\"testing\" value=\"$test_msg\" />";
	print "<div class=\"headerbar\"> Attendee Information</div>";
	
	/*	Generate each requested kind of input line, with comments, placeholders
		and validation code. 
		
		The parameters to the name_fields call are:
		
		$db				the database table into which these records go
		$class			the CSS class for the section (to control its
						visibility), or null if it's always visible
		$specific		true if section will always appear in form, false if it
						is controlled by CSS (i.e. by a checkbox at the beginning of the
						form)
		$section		the title of the section ("You", "Your SO" etc.)
		$prefix			the form_type to be embedded in the field name
		$alt			label for the field
		$heading		subtitle for the field 
		$ok_for_bsls	true if we should put up BSLS code, false otherwise
		$ok_for_so_pgm	true if we should ask about attending SO Program
		$relto_target	true if the email address is the target for other related records.
						If true, then the email confirmation field is created as
						reg[common][relto_email] field is created, which will later be
						copied into all records created by this form.
						If false, the email confirmation field is created as a
						noupload[{$prefix}][emailconf] field which is used for
						validation but doesn't get uploaded to the database.
		
*/

/* Convenient mnemonics */
define('BSLS_OK', true);
define('BSLS_NOT_OK', false);
define('SOPGM_OK', true);
define('SOPGM_NOT_OK', false);

	foreach ($classes as $class_key => $this_class) {
 		switch ($this_class) {
	
		case 'Single':
		
		/*	The bulk of attendees */

			print name_fields('reg',
				'Single',
				true,
				'You',
				'Single',
				'Your PREFERRED name',
				'What you want to be called at Esprit',
				BSLS_OK,
				SOPGM_NOT_OK,
				true);
			break;
		
		case 'Resource_Presenter':
		
		/*	Presenters. */

			print name_fields('reg',
				'',
				true,
				'You',
				'Resource_Presenter',
				'Your PREFERRED name',
				'What you want to be called at Esprit',
				BSLS_NOT_OK,
				SOPGM_NOT_OK,
				true);
			break;
		
		case 'Resource_Vendor':
		
		/*	Vendors. */

			print name_fields('reg',
				'',
				true,
				'You',
				'Resource_Vendor',
				'Your PREFERRED name',
				'What you want to be called at Esprit',
				BSLS_NOT_OK,
				SOPGM_NOT_OK,
				true);
			break;
		
		case 'SO':
		
		/*	SOs registering together with the main attendee. Visible only if the
			"Register my SO" checkbox is checked (by virtue of the class="so" spec on the
			tr at the beginning).
		*/
		
			print name_fields('reg',
				'so',
				false,
				'Your SO',
				'SO',
				'SO\'s PREFERRED name',
				'What your SO should be called at Esprit',
				BSLS_OK,
				SOPGM_OK,
				false);
			break;
	
		case 'SO-specific':
		
		/*	SOs registering separately after their main person has registered.
			This section will always appear if specified in the parameter array; it will
			usually be the only section specified.
		 */
		
			print name_fields('reg',
				'so-specific',
				true,
				'You (the SO, that is...)',
				'SO',
				'PREFERRED name',
				'What you want to be called at Esprit',
				BSLS_OK,
				SOPGM_OK,
				false);
			break;
				
		case 'Add_Family':
		
		/*	Additional Family members registering together with the main attendee. Visible
			only if the "Register Additional Family Member" checkbox is checked (by virtue
			of the class="af" spec on the tr at the beginning).
		*/
		
			print name_fields('reg',
				'af',
				false,
				'Addtional Family',
				'Add_Family',
				'Add. Family\'s PREFERRED Name',
				'What this person should be called at Esprit',
				BSLS_NOT_OK,
				SOPGM_NOT_OK,
				false);
			break;
					
		case 'Add_Family-specific':
		
		/*	Additional Family members registering separately after their main person has
			registered. This section will always appear if specified in the parameter
			array; it will usually be the only section specified.
		 */
		
			print name_fields('reg',
				'af-specific',
				true,
				'You (the family member)',
				'Add_Family',
				'PREFERRED Name',
				'What you want to be called at Esprit',
				BSLS_NOT_OK,
				SOPGM_NOT_OK,
				false);
			break;
					
		case 'Assistant':
		
		/*	Assistant registering together with the main attendee. Visible only if the
			"Register Additional Family Member" checkbox is checked (by virtue of the
			class="af" spec on the tr at the beginning).
		*/
		
			print name_fields('reg',
				'as',
				false,
				'Your Assistant',
				'Assistant',
				'Assistant\'s PREFERRED Name',
				'What your Assistant should be called at Esprit',
				BSLS_NOT_OK,
				SOPGM_NOT_OK,
				false);
			break;
					
		case 'Assistant-specific':
		
		/*	Assistant registering separately after their main person has registered. This
			section will always appear if specified in the parameter array; it will
			usually be the only section specified.
		 */
		
			print name_fields('reg',
				'Assistant-specific',
				true,
				'You (the Assistant, that is...)',
				'Assistant',
				'PREFERRED Name',
				'What you (the Assistant) should be called at Esprit',
				BSLS_NOT_OK,
				SOPGM_NOT_OK,
				false);
			break;
						
		case 'Guest-specific':
		
		/*	Guest registration. This section is always the only one specified on a form;
			guests are never registered in conjunction with anyone.
		 */
		
			print name_fields('reg',
				'Guest-specific',
				true,
				'Your Guest',
				'Guest',
				'Guest\'s PREFERRED Name',
				'What your Guest should be called at Esprit',
				BSLS_NOT_OK,
				SOPGM_NOT_OK,
				false);
			break;
						
		case 'Observer-specific':
		
		/*	Observer registration. This section is always the only one specified on a
			form; Observers are never registered in conjunction with anyone.
		 */
		
			print name_fields('reg',
				'Observer-specific',
				true,
				'Your Observer',
				'Observer',
				'Observer\'s PREFERRED Name',
				'What your Observer should be called at Esprit',
				BSLS_NOT_OK,
				SOPGM_NOT_OK,
				false);
			break;

		case 'Volunteer-specific':
		
		/*	Volunteer registration. This section is always the only one specified on a
			form; Volunteers are never registered in conjunction with anyone.
		 */
		
			print name_fields('reg',
				'Volunteer-specific',
				true,
				'You (the Volunteer)',
				'Volunteer',
				'Volunteer\'s PREFERRED Name',
				'What your Volunteer should be called at Esprit',
				BSLS_NOT_OK,
				SOPGM_NOT_OK,
				false);
			break;

		case 'Committee_Full':
		
		/*	Committee members on full discount */

			print name_fields('reg',
				'',
				true,
				'You',
				'Committee_Full',
				'Your PREFERRED name',
				'What you want to be called at Esprit',
				BSLS_OK,
				SOPGM_NOT_OK,
				true);
			break;
		
		case 'Committee_Partial':
		
		/*	Committee members on partial discount */

			print name_fields('reg',
				'',
				true,
				'You',
				'Committee_Partial',
				'Your PREFERRED name',
				'What you want to be called at Esprit',
				BSLS_OK,
				SOPGM_NOT_OK,
				true);
			break;
		
		case 'Donor':
		
		/*	Donors (non-anonymous) */

			print name_fields('reg',
				'Donor',
				true,
				'You',
				'Donor',
				'Your PREFERRED name',
				'What we should call you',
				BSLS_NOT_OK,
				SOPGM_NOT_OK,
				true);
			break;
		
		default:
			print "<span class=\"errormsg\"> Invalid CLASS type \"$this_class\" passed to esprit_names()</span><br />";
		}
	}
	
	print "</div>";	// class="section" that encloses it
	print "<!-- END section esprit_names -->";
}

function name_fields($db, $class, $specific, $section, $prefix, $alt, $heading, $ok_for_bsls, $ok_for_so_pgm, $relto_target) {

	global $esprit_year;

	/*	Create a conditional section for all the data. */

	$result = "<table width=\"100%\" class=\"section person $class\" cellpadding=\"2\">";
	$result .= "<tr><td class=\"headerbar\">$section</td></tr>";
	
	/*	Input fields for preferred name */
	
	$result .= "<tr><td width=\"25%\"><div class=\"reqd reqdhilite\">$alt*:" . helpbutton('prefnamehelp.php') . "</div>
			<div class=\"tiny\">$heading</div></td>";
	$result .= "<td>
	<div class=\"reqdhilite\"><input class=\"validate[required],ajax[{$prefix}]\" type=\"text\" placeholder=\"First name\" name=\"{$db}[{$prefix}][firstnamepref]\" id=\"{$prefix}__firstnamepref\" size=\"30\" />
	&nbsp;&nbsp;
	<input class=\"validate[required],ajax[{$prefix}]\" type=\"text\" placeholder=\"Last name\" name=\"{$db}[{$prefix}][lastnamepref]\" id=\"{$prefix}__lastnamepref\" size=\"30\" /></div></td></tr>";

	/*	Input field for preferred pronouns */
	
	$result .= "<tr>
		<td><div class=\"reqd reqdhilite\">What pronouns do you prefer?*</div></td>
		<td><div class=\"reqdhilite\" id=\"pronounselections\"><select name=\"{$db}[{$prefix}][pronouns]\" id=\"{$prefix}__pronouns\" class=\"validate[required]\" >";
				
	$result .= generate_pronouns();
	$result .= "</select>";

	/*	Input fields for email. Note the rather convoluted handling of the
		confirmation field; it depends on the value of $relto_target: true if
		the email address is the target for other related records. If true, then
		the email confirmation field is created as {$db}[common][relto_email]
		field is created, which will later be copied into all records created by
		this form.
		If false, the email confirmation field is created as
		noupload[{$prefix}][emailconf] field which is used for validation but
		doesn't get uploaded to the database.
		
		ajax[DuplicateReg], needs to be coded more robustly so it's called by
		each {$prefix} validator to check for duplicate registrations.
 */
	
	$result .= "<tr><td><div class=\"reqd reqdhilite\">Email:</div></td><td><div class=\"reqdhilite\"><input class=\"validate[required,custom[email],ajax[{$prefix}]\" type=\"text\"  name=\"{$db}[{$prefix}][email]\" id=\"{$prefix}__email\" size=\"30\" placeholder=\"Email\" testdata=\"email\"/>&nbsp; ";
	/*	Is this the master for a relto_email? */
	if ($relto_target) {	//	Yes, generate as {$db}[common][relto_email]
		$result .= "<input class=\"validate[required,equals[{$prefix}__email]]\" type=\"text\" placeholder=\"RETYPE email\" name=\"{$db}[common][relto_email]\" id=\"{$prefix}__relto_email\" size=\"30\"  testdata=\"email\"/></div></td></tr>";
	} else {				//	No, generate as noupload[{$prefix}][emailconf]
		$result .= "<input class=\"validate[required,equals[{$prefix}__email]]\" type=\"text\" placeholder=\"RETYPE email\" name=\"noupload[{$prefix}][emailconf]\" id=\"{$prefix}__relto_email\" size=\"30\"  testdata=\"email\"/></div></td></tr>";
	}
	
	/*	Input fields for real firstname and lastname fields . */
	
	$result .= "<tr>
	<td width=\"25%\"><div class=\"reqd reqdhilite\">Mailing Name*:</span>" . helpbutton('namehelp.php') . "</div></td>
	<td><div class=\"reqdhilite\"><input class=\"validate[required]\" type=\"text\" placeholder=\"REAL First name\" name=\"{$db}[{$prefix}][firstname]\" id=\"{$prefix}__firstname\" size=\"30\" />&nbsp;&nbsp;&nbsp;<input class=\"validate[required]\" type=\"text\" placeholder=\"REAL Last name\" name=\"{$db}[{$prefix}][lastname]\" id=\"{$prefix}__lastname\" size=\"30\" /></td>
	</tr>";
	
	/*	Input field for first Esprit */
	
	$result .= "<tr>
		<td><div class=\"reqd reqdhilite\">What year was your first Esprit?*</div></td>
		<td><div class=\"reqdhilite\" id=\"bslsselections\"><select name=\"{$db}[{$prefix}][firstesprit]\" id=\"{$prefix}__firstesprit\" class=\"validate[required]\" onChange=\"hideshow($esprit_year,this.value,document.getElementById('{$prefix}_littlesis'),document.getElementById('{$prefix}_bigsis')); 
		document.getElementById('soattending').checked!=false ? hideshow($esprit_year,this.value,document.getElementById('{$prefix}_mentee'),document.getElementById('{$prefix}_mentor')) : $('#{$prefix}_mentee, #{$prefix}_mentor').hide(); return true;\" >";
				
	$result .= generate_years();
	$result .= "</select>";
	
	/*	Generate BSLS input fields? */
	
	if ($ok_for_bsls) {
		include 'bsls.php';
		$result .= '<div class="so">';
		include 'mentors.php';
		$result .= '</div>';
	}
	$result .= '</div></td>
				</tr>';
	/*	Generate Attending SO Program query field? */
	
	if ($ok_for_so_pgm) {
		require 'sopgmattend.php';
	}
	
	$result .= "</table>";

	/*	Input fields for confirmation number and registration status.
		These fields are assigned as the records are added to the database,
		which is why they're marked unassigned here. Since these are hidden
		fields, they don't get a table row, which is why they must be defined
		after the table. */
	
	$result .= "<input class=\"invisible\" type=\"text\" testdata=\"no\" name=\"{$db}[{$prefix}][confirmation_no]\" id=\"{$prefix}__confirmation_no\" value=\"UNASSIGNED\" />";
	
	$result .= "<input class=\"invisible\" name=\"{$db}[{$prefix}][reg_status]\" testdata=\"no\" id=\"{$prefix}__reg_status\" value=\"Pre-registered\" />";
	
	$result .= "<input class=\"invisible\" name=\"{$db}[{$prefix}][form_type]\" testdata=\"no\" id=\"{$prefix}__form_type\" value=\"{$prefix}\" />";
	
	return $result;
}
?>
