<?php
function attendwith($form_type, $email_param = '', $conf_param = '') {
	$db = 'reg';		//	Constant table name for attendees
	$messages = [
		/*
			'sectiontitle' =>			title of section as it appears in the form
			'primmsg' =>				field label for name of person. Null value
										suppresses firstname nand lastname fields in
										form
			'primattendeemsg' =>		explanatory message for the name
			'primemailmsg' =>			field label for that person's email
			'primemailplaceholder' =>	placeholder text for email
			'ajaxvalidate' =>			the AJAX validation clause
			Convention is to name the AJAX validation spec the same as the array
			entry and also use the same name for the actual validator PHP file. 
			Placeholders for the person's name field are constants
		*/
		'Assistant' => [
			'sectiontitle' => 'Who you\'re assisting',
			'primmsg' => 'Assisting:*',
			'primattendeemsg' => 'The  name of the Presenter or Vendor you\'re at Esprit with',
			'primemailmsg' => 'Presenter or Vendor\'s email:',
			'primemailplaceholder' => 'Presenter/Vendor\'s email',
			'ajaxvalidate' => 'ajax[add_Assistant]'],

		'Add_Family' => [
			'sectiontitle' => 'Who you\'re attending with',
			'primmsg' => 'Attending with:*',
			'primattendeemsg' => 'The  name of the attendee you\'re at Esprit with',
			'primemailmsg' => 'That Attendee\'s email:',
			'primemailplaceholder' => 'Attendee\'s email',
			'ajaxvalidate' => 'ajax[add_Add_Family]'],

		'SO' => [
			'sectiontitle' => 'Who you\'re attending with',
			'primmsg' => 'Attending with:*',
			'primattendeemsg' => 'The  name of the attendee you\'re at Esprit with',
			'primemailmsg' => 'That Attendee\'s email:',
			'primemailplaceholder' => 'Attendee\'s email',
			'ajaxvalidate' => 'ajax[add_SO]'],

		'Guest' => [
			'sectiontitle' => 'Your Host (Committee Member)',
			'primmsg' => 'Attending with:*',
			'primattendeemsg' => 'The  name of your hosting Committee Member',
			'primemailmsg' => 'Committee Member\'s email:',
			'primemailplaceholder' => 'Committee Member\'s email',
			'ajaxvalidate' => 'ajax[add_Guest]'],

		'Observer' => [
			'sectiontitle' => 'Your Sponsor (Committee Member)',
			'primmsg' => 'Attending with:*',
			'primattendeemsg' => 'The  name of your sponsoring Committee Member',
			'primemailmsg' => 'Committee Member\'s email:',
			'primemailplaceholder' => 'Committee Member\'s email',
			'ajaxvalidate' => 'ajax[add_Observer]'],

		'Volunteer' => [
			'sectiontitle' => 'Your Host (Committee Member)',
			'primmsg' => 'Who signed you up:*',
			'primattendeemsg' => 'The  name of the Committee Member who signed you up',
			'primemailmsg' => 'Committee Member\'s email:',
			'primemailplaceholder' => 'Committee Member\'s email',
			'ajaxvalidate' => 'ajax[add_Volunteer]'],

		'Scholarship' => [
			'sectiontitle' => 'Verify Your Registration',
			'primmsg' => '',
			'primattendeemsg' => '',
			'primemailmsg' => 'Your Email:',
			'primemailplaceholder' => 'The email address you registered with',
			'ajaxvalidate' => 'ajax[Scholarship]'],

		'Committee' => [
			'sectiontitle' => 'Verify Your Committee Email',
			'primmsg' => '',
			'primattendeemsg' => '',
			'primemailmsg' => 'Your Email:',
			'primemailplaceholder' => 'The email address you registered with',
			'ajaxvalidate' => 'ajax[Committee]'],
		];
	$result = "<div class=\"section notso\">
	<div class=\"headerbar\">{$messages[$form_type]['sectiontitle']}</div>";
	$result .= '<table width="100%">';
	if ($messages[$form_type]['primmsg'] > '') {
		$result .= "<tr>
				<td width=\"25%\"><div class=\"reqd reqdhilite\">{$messages[$form_type]['primmsg']}";
		$result .= '<?php print helpbutton(\'attendwithhelp.php\');?></div>';
		$result .= "<span class=\"tiny\">{$messages[$form_type]['primattendeemsg']}</span></td>";
		$result .= "<td width=\"30%\"><div class=\"reqdhilite\">
				<input class=\"validate[required]\" type=\"text\" name=\"{$db}[{$form_type}][relto_firstnamepref]\" size=\"30\" placeholder=\"First name\" id=\"{$form_type}__relto_firstnamepref\" />";
		$result .= "&nbsp;&nbsp;&nbsp;<input class=\"validate[required]\" type=\"text\" name=\"{$db}[{$form_type}][relto_lastnamepref]\"  placeholder=\"Last name\" size=\"30\" id=\"{$form_type}__relto_lastnamepref\" />";
		$result .= "</div></td>
			</tr>";
	}
	/*	Email address to link to */
	$result .= "<tr>
			<td><div class=\"reqd reqdhilite\">
			{$messages[$form_type]['primemailmsg']}</div>
				<span class=\"tiny\">MUST be already registered</span></td>";
	$result .= "<td width=\"30%\"><div class=\"reqdhilite\"><input class=\"validate[required,custom[email]]\" type=\"text\" name=\"{$db}[{$form_type}][relto_email]\" value=\"$email_param\" placeholder=\"{$messages[$form_type]['primemailplaceholder']}\" size=\"30\" id=\"With__relto_email\" /></div>";
	$result .= "</td>
		</tr>";
	/*	Matching confirmation number - not uploaded to database */
	$result .= "<tr>
			<td><div class=\"reqd reqdhilite\">Confirmation number:</div>
				<span class=\"tiny\">MUST correspond to email</span></td>";
	$result .= "<td width=\"30%\"><div class=\"reqdhilite\"><input class=\"validate[required,{$messages[$form_type]['ajaxvalidate']}]\" type=\"text\" name=\"noupload[relto_conf]\" value=\"$conf_param\" placeholder=\"confirmation number\" size=\"30\" id=\"With__relto_conf\" /></div>";
	$result .= "</td>
		</tr>";
	$result .= "</table>
</div>";
	return $result;
}
?>
