<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 10 January, 2013
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');
global $opts, $all_years;

/* MySQL table names */

$db['tb'] = 'ybphotoproducts p';
$db['tbnoalias'] = 'ybphotoproducts';
$opts['join_clause'] = '';

/* Field definitions start here */

$fields['timestamp'] = [
		'heading' => "Created",
		'table' => 'p',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'fieldgroup' => 'Master, Basic',
		'helpfile' => 'help/timestamphelp.php',
		'filter' => ""];
$fields['updatetime'] = [
		'heading' => "Updated",
		'table' => 'p',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'fieldgroup' => 'Master, Basic',
		'helpfile' => 'help/timestamphelp.php',
		'filter' => ""];
$fields['category'] = [
		'heading' => "Product Category",
		'table' => 'p',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['name'] = [
		'heading' => "Product Name",
		'table' => 'p',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['description'] = [
		'heading' => "Product Description",
		'table' => 'p',
		'display' => true,
		'arrayedit' => true,
		'widget' => 'ckeditor',
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['unit_price'] = [
		'heading' => "Unit Price",
		'table' => 'p',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['quantity'] = [
		'heading' => "Default Quantity",
		'table' => 'p',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'copyValue' => 1,
		'filter' => ""];
$fields['prod_id'] = [
'heading' => 'Entry number',
		'primarykey' => true,
		'table' => 'p',
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];

/* End of Field definitions end here. */

/* Field group definitions */

$tpl['fieldgroups'] = [
	'Master' => ['label'=>'Master',
		'url' =>''],
	'Basic' => ['label' => 'Detail',
		'url' => 'taburl.php?template=detail.tpl',
		'authgroup' => ['Admin'],
		'width' => 2000,
		'height' => 900],
	'AddNew' => ['label' => 'Copy',
		'url' => 'add.php',
		'authgroup' => ['Admin'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
	],
	'Delete' => ['label' => 'Delete',
		'url' => 'delete.php',
		'authgroup' => ['Admin'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
	]

];

?>