<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');
global $opts, $all_years;

/* MySQL table names */

$db['tb'] = 'ybphotoorders o, reg r,ybphotoproducts p';
$db['tbnoalias'] = 'ybphotoorders';
$opts['join_clause'] = 'r.confirmation_no=o.confirmation_no AND o.item_no=p.prod_id';

/* Field definitions start here */

$fields['timestamp'] = [
		'heading' => "Created",
		'table' => 'o',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'fieldgroup' => '*',
		'helpfile' => 'help/timestamphelp.php',
		'filter' => ""];
$fields['updatetime'] = [
		'heading' => "Updated",
		'table' => 'o',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'fieldgroup' => '*',
		'helpfile' => 'help/timestamphelp.php',
		'filter' => ""];
$fields['firstnamepref'] = [
		'heading' => "Preferred First Name",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['lastnamepref'] = [
		'heading' => "Preferred Last Name",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['confirmation_no'] = [
		'heading' => "Registration No.",
		'table' => 'o',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['item_no'] = [
		'heading' => "Item No.",
		'table' => 'o',
		'display' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['name'] = [
		'heading' => "Item Name",
		'table' => 'p',
		'display' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['quantity'] = [
		'heading' => "Quantity",
		'table' => 'o',
		'display' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['price'] = [
		'heading' => "Total Price",
		'table' => 'o',
		'display' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['status'] = [
		'heading' => "Order Status",
		'table' => 'o',
		'display' => true,
		'arrayedit' => true,
		'widget' => 'menu',
		'allowedvalues' => ['Ordered', 'Paid', 'In Progress', 'Ready', 'Picked Up', 'Shipped', 'Cancelled'],
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['description'] = [
		'heading' => "Description",
		'table' => 'o',
		'display' => true,
		'fieldgroup' => 'Master, *',
		'arrayedit' => true,
		'widget' => 'ckeditor',
		'filter' => ""];
$fields['notes'] = [
		'heading' => "Notes",
		'table' => 'o',
		'display' => true,
		'fieldgroup' => 'Master, *',
		'arrayedit' => true,
		'widget' => 'ckeditor',
		'filter' => ""];
$fields['id'] = [
'heading' => 'Entry number',
		'primarykey' => true,
		'table' => 'o',
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];

/* End of Field definitions end here. */

/* Field group definitions */

$tpl['fieldgroups'] = [
	'Master' => ['label'=>'Master',
		'url' =>''],
	'Basic' => ['label' => 'Detail',
		'url' => 'taburl.php?template=detail.tpl',
		'authgroup' => ['Admin'],
		'width' => 2000,
		'height' => 900]
];

?>