<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 19 March, 2023
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');
global $opts, $all_years;

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'mysql_utilities.php';

/* MySQL table names */
if ($all_years) {	//	All years
	$db['tb'] = 'regall r, regvendorall s';
	$db['tbnoalias'] = 'regvendorall';
	$db['alias'] = 's';		//	Need this for duplicating records. Only fields
							//	with a table spec matching this alias will be
							//	used in the get_mysql_fields() function.
} else {	//	Current year only
	$db['tb'] = 'reg r, regvendor s';
	$db['tbnoalias'] = 'regvendor';
	$db['alias'] = 's';		//	Need this for duplicating records. Only fields
							//	with a table spec matching this alias will be
							//	used in the get_mysql_fields() function.
}
$opts['join_clause'] = 'r.confirmation_no=s.confirmation_no';

/* Field definitions start here */

if ($all_years) {
	$fields['esprit_year'] = [
			'heading' => "Esprit Year",
			'table' => 's',
			'select' => true,
			'search_more' => true,
			'copyValue' => $GLOBALS['esprit_year'],
			'display' => true,
			'fieldgroup' => '*, Master',
			'filter' => ""];
} else {
	$fields['esprit_year'] = [
			'heading' => "Esprit Year",
			'table' => 's',
			'select' => true,
			'search_more' => true,
			'copyValue' => $GLOBALS['esprit_year'],
			'display' => true,
			'fieldgroup' => '*',
			'filter' => ""];
}
$fields['timestamp'] = [
		'heading' => "Time Stamp",
		'table' => 's',
		'helpfile' => 'help/timestamphelp.php',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'width' => '15%',
		'fieldgroup' => 'Master, Vendor, Letters, VendorRO',	//	No copy
		'filter' => ""];
$fields['updated'] = [
		'heading' => "Updated",
		'table' => 's',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'search_more' => true,
		'width' => '10%',
		'fieldgroup' => 'Master, Vendor, Letters, VendorRO',	//	No copy
		'filter' => ""];
$fields['firstnamepref'] = [
		'heading' => "First Name",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'fieldgroup' => 'Master, Vendor, Letters, VendorRO',
		'filter' => ""];
$fields['lastnamepref'] = [
		'heading' => "Last Name",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'fieldgroup' => 'Master, Vendor, Letters, VendorRO',
		'filter' => ""];
$fields['firstname'] = [
		'heading' => "Business First Name",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor, VendorRO',
		'filter' => ""];
$fields['lastname'] = [
		'heading' => "Business Last Name",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor, VendorRO',
		'filter' => ""];
$vendor_list = get_vendor_list("conf");
$vendor_names = get_vendor_list("name");
$vendor_venues = get_vendor_venues();
$fields['confirmation_no'] = [
		'heading' => "Registration No.",
		'table' => 's',
		'fieldgroup' => '*, Master, Vendor, Letters',
		'display' => true,
		'width' => '10%',
		'allowedvalues' => $vendor_list,
		'allowedlabels' => $vendor_names,
		'arrayedit' => true,
		'widget' => 'menu',
		'filter' => ""];
$fields['bus_name'] = [
		'heading' => "Business Name",
		'fieldgroup' => 'Master, Vendor, Letters, AddNew, Delete, VendorRO',
		'table' => 's',
		'display' => true,
		'truncate_display' => 80,
//		'width' => '30%',
		'arrayedit' => true,
		'filter' => ""];
$fields['email'] = [
		'heading' => "Email",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Vendor, Letters',
		'filter' => ""];
$fields['address'] = [
		'heading' => "Address",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, VendorRO',
		'filter' => ""];
$fields['city'] = [
		'heading' => "City",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, VendorRO',
		'filter' => ""];
$fields['state'] = [
		'heading' => "State/Prov",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, VendorRO',
		'arrayedit' => true,
		'filter' => ""];
$fields['zip'] = [
		'table' => 'r',
		'heading' => "Zip/Postal",
		'fieldgroup' => 'Vendor, Letters, VendorRO',
		'filter' => ""];
$fields['country'] = [
		'heading' => "Country",
		'fieldgroup' => 'Vendor, Letters, VendorRO',
		'table' => 'r',
		'filter' => ""];
$fields['phone'] = [
		'heading' => "Phone",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Vendor, Letters',
		'search_more' => true,
		'filter' => ""];
$fields['besttimetocall'] = [
		'heading' => "Time to Call",
		'table' => 'r',
		'search_more' => true,
		'fieldgroup' => 'Vendor',
//		'select' => true,
		'filter' => ""];
$fields['nametoaskfor'] = [
		'heading' => "Ask for",
		'table' => 'r',
		'search_more' => true,
		'fieldgroup' => 'Vendor',
//		'select' => true,
		'filter' => ""];
$fields['is_vendor'] = [
		'heading' => "Is a Vendor",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor',
//		'arrayedit' => true,
		'allowedvalues' => [1, 0],
		'allowedlabels' => ['Yes', 'No'],
		'search_more' => true,
		'filter' => ""];
$fields['resourceroom'] = [
		'heading' => "Room Assigned",
		'table' => 's',
		'display' => true,
		'width' => '8%',
		'fieldgroup' => 'Vendor, VendorRO',	//	Don't Add New (manually assigned)
		'allowedvalues' => $vendor_venues,	//	Selected from regvenues table
		'allowedlabels' => $vendor_venues,	//	Selected from regvenues table
		'arrayedit' => true,
		'widget' => 'menu',
		'filter' => ""];
$fields['resourcedate'] = [
		'heading' => "Date Scheduled",
		'table' => 's',
		'display' => true,
		'width' => '15%',
		'fieldgroup' => 'Master, *',
		'arrayedit' => true,
		'widget' => 'datetimepicker',
		'type' => 'date',
		'date_format' => '%d%b%Y %T',
		'css' => 'font-size:80%',
		'filter' => ""];
$fields['resourcestatus'] = [
		'heading' => "Status",
		'table' => 's',
		'display' => true,
		'width' => '10%',
		'fieldgroup' => 'Master, Vendor, Letters, AddNew, VendorRO',
		'arrayedit' => true,
		'widget' => 'menu',
		'search_more' => true,
		'allowedvalues' => ['', 'Inquiry', 'Approved', 'Scheduled',
			'Co-Presenter', 'Suspended', 'Cancelled'],
		'allowedlabels' => ['None', 'Inquiry', 'Approved', 'Scheduled',
			'Co-Presenter', 'Suspended', 'Cancelled'],
		'copyValue' => 'Inquiry',
		'filter' => ""];
// $fields['firstesprit'] = [
// 		'heading' => "First Esprit",
// 		'table' => 'r',
//		'fieldgroup' => 'Vendor',
// 		'search_more' => true,
// 		'filter' => ""];
$fields['reg_status'] = [
		'heading' => "Registration Status",
		'table' => 'r',
//		'display' => true,
		'fieldgroup' => 'Vendor, VendorRO',
		'allowedvalues' => ['Pre-registered', 'Paid', 'Checked In',
			'Participant Cancelled', 'Esprit Cancelled', 'Blocked',
			'Checked Out'],
		'helpfile' => 'help/regstatushelp.php',
		'search_more' => true,
		'filter' => ""];
$fields['daysun1'] = [
		'heading' => "Sunday (start)",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor, VendorRO',
		'search_more' => true,
		'filter' => ""];
$fields['daymon'] = [
		'heading' => "Monday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor, VendorRO',
		'search_more' => true,
		'filter' => ""];
$fields['daytue'] = [
		'heading' => "Tuesday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor, VendorRO',
		'search_more' => true,
		'filter' => ""];
$fields['daywed'] = [
		'heading' => "Wednesday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor, VendorRO',
		'search_more' => true,
		'filter' => ""];
$fields['daythu'] = [
		'heading' => "Thursday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor, VendorRO',
		'search_more' => true,
		'filter' => ""];
$fields['dayfri'] = [
		'heading' => "Friday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor, VendorRO',
		'search_more' => true,
		'filter' => ""];
$fields['daysat'] = [
		'heading' => "Saturday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor, VendorRO',
		'search_more' => true,
		'filter' => ""];
$fields['daysun2'] = [
		'heading' => "Sunday (end)",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor, VendorRO',
		'search_more' => true,
		'filter' => ""];
$fields['meal1'] = [
		'heading' => "Meal 1",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor',
		'search_more' => true,
		'filter' => ""];
$fields['meal2'] = [
		'heading' => "Meal 2",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor',
		'search_more' => true,
		'filter' => ""];
$fields['meal3'] = [
		'heading' => "Meal 3",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor',
		'search_more' => true,
		'filter' => ""];
$fields['meal4'] = [
		'heading' => "Meal4",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor',
		'search_more' => true,
		'filter' => ""];
$fields['meal5'] = [
		'heading' => "Meal 5",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor',
		'search_more' => true,
		'filter' => ""];
$fields['meal6'] = [
		'heading' => "Meal 6",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor',
		'search_more' => true,
		'filter' => ""];
$fields['form_type'] = [
		'heading' => "Form Type",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Master, Vendor',
		'width' => '8%',
		'helpfile' => 'help/formtypehelp.php',
		'search_more' => true,
		'filter' => ""];
$fields['notes'] = [
		'heading' => "Notes",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Vendor',
		'search_more' => true,
		'filter' => ""];
$fields['bus_desc'] = [
		'heading' => "Business Description",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, AddNew',
		'search_more' => true,
		'css' => 'max-height: 100; overflow: auto',
		'filter' => ""];
$fields['resourcebio'] = [
		'heading' => "Biography",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, AddNew',
		'search_more' => true,
		'filter' => ""];
$fields['flyer'] = [
		'heading' => "Flyer/Coupon",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, AddNew',
		'search_more' => true,
		'filter' => ""];

/* Room setup requirements for vendors */

$fields['desk'] = [
		'heading' => "Desk",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, AddNew',
		'search_more' => true,
		'filter' => ""];
$fields['deskchair'] = [
		'heading' => "Desk Chair",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, AddNew',
		'search_more' => true,
		'filter' => ""];
$fields['mirror'] = [
		'heading' => "Mirror",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, AddNew',
		'search_more' => true,
		'filter' => ""];
$fields['bigchair'] = [
		'heading' => "Overstuffed Chair",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, AddNew',
		'search_more' => true,
		'filter' => ""];
$fields['nightstands'] = [
		'heading' => "Nightstands",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, AddNew',
		'search_more' => true,
		'filter' => ""];
$fields['table6x35'] = [
		'heading' => "Tables 6x3.5",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, AddNew',
		'search_more' => true,
		'filter' => ""];
$fields['table6x15'] = [
		'heading' => "Tables 6x1.5",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, AddNew',
		'search_more' => true,
		'filter' => ""];
$fields['foldchairs'] = [
		'heading' => "Folding Chairs",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, AddNew',
		'search_more' => true,
		'filter' => ""];
$fields['rollaways'] = [
		'heading' => "Rollaway Cot",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, AddNew',
		'search_more' => true,
		'filter' => ""];
$fields['resourcenotes'] = [
		'heading' => "Notes",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Vendor, Letters, AddNew',
		'search_more' => true,
		'filter' => ""];
$fields['flyer'] = [
		'heading' => "Flyer/Coupon",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Vendor, AddNew',
		'search_more' => true,
		'filter' => ""];
$fields['specialrequests'] = [
		'heading' => "Special Requests",
		'table' => 's',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['id'] = [
		'heading' => "Record ID",
		'table' => 's',
		'primarykey' => true,
		'width' => '5%',
		'fieldgroup' => '*, Master',
		'search_more' => true,
		'filter' => ""];

/* End of special setup requirements */

/* End of Field definitions. */

/*	Field group definitions */

if (!$all_years) {	//	Current year
	$tpl['fieldgroups'] = [
		'Master' => ['label'=>'Master',
			'url' =>''],
		'Vendor' => ['label' => 'Business',
			'url' => 'taburl.php?template=vendor_detail.tpl',
			'width' => 1000,	// Override default window width
			'height' => 800,
			'authgroup' => ['Registrar', 'Desk', 'Vendor', 'Admin']],
		'VendorRO' => ['label' => 'Business',
			'url' => 'taburl.php?template=vendor_detail.tpl&access=read_only',
			'authgroup' => ['Hotel']],
		'Letters' => ['label' => 'Letters',
			'url' =>'../letterssendmailtaburl.php?appname=vendors',
			'width' => 1000,
			'height' => 800,
			'authgroup' => ['Registrar', 'Admin', 'Vendor']],
		'Logs' => ['label' => 'Log Entries',
			'url' => "../log-list.php?tbname={$db['tbnoalias']}",
			'width' => 1500,
			'height' => 800,
			'authgroup' => ['Admin']],
		'All' => ['label' => 'All Fields',
			'url' => '../allfieldsurl.php?dirname=vendors',
			'authgroup' => ['Admin']],
		'AddNew' => ['label' => 'Copy - CAUTION',
			'url' => 'add.php?group=AddNew',
			'authgroup' => ['Registrar', 'Vendor', 'Admin'],
			'scroll' => 'No'	//	Prevent scrolling to this screen
			],
		'Delete' => ['label' => 'Delete',
			'url' => 'delete.php?group=AddNew',
			'authgroup' => ['Registrar', 'Vendor', 'Admin'],
			'scroll' => 'No'	//	Prevent scrolling to this screen
			]
	];
} else {	//	All years
	$tpl['fieldgroups'] = [
		'Master' => ['label'=>'Master',
			'url' =>''],
		'Vendor' => ['label' => 'Business',
			'url' => 'taburl.php?template=vendor_detail.tpl&all_years=true&access=read_only',
			'authgroup' => ['Registrar', 'Desk', 'Vendor', 'Presenter', 'Admin']],
		'Letters' => ['label' => 'Letters',
			'url' =>'../letterssendmailtaburl.php?appname=vendorsall',
			'width' => 1000,
			'height' => 800,
			'authgroup' => ['Registrar', 'Admin','Vendor']],
		'Logs' => ['label' => 'Log Entries',
			'url' => "../log-list.php?tbname={$db['tbnoalias']}",
			'width' => 1500,
			'height' => 800,
			'authgroup' => ['Admin']],
		'All' => ['label' => 'All Fields',
			'url' => '../allfieldsurl.php?dirname=vendorsall',
			'authgroup' => ['Admin']],
		'Copy' => ['label' => 'Copy to Current Year',
			'url' => 'copy_to_current.php?all_years=true',
			'authgroup' => ['Registrar', 'Admin', 'Vendor', 'Presenter']]
	];
}

function get_vendor_list($type) {
	/*
		Get list of registered vendors for use in the Relink button. 
		Parameter $type is:
		"name"	return names
		"conf"	return confirmation numbers
		"select"	return string for use in <select> clause of <input>
	*/
	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	require_once "mysql_utilities.php";
	global $tpl;
	mysql_login('Normal');
	$sql = 'SELECT firstnamepref,lastnamepref,confirmation_no
	FROM reg
	WHERE is_vendor="Yes"
		AND reg_status NOT LIKE "%cancel%"
	ORDER BY lastnamepref';
	$sql_result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error getting vendor list: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to retrieve list of vendor names - sorry!');
	$r = [];
	while ($row = mysqli_fetch_assoc($sql_result)) {
		switch ($type) {
		case 'name':
			$r[] = "{$row['firstnamepref']} {$row['lastnamepref']}";
			break;
		case 'conf':
			$r[] = $row['confirmation_no'];
			break;
		case 'both':
			$r[] = "{$row['firstnamepref']} {$row['lastnamepref']} {$row['confirmation_no']}";
		}
	}
	return $r;
}
function get_vendor_venues() {
	/*	Get list of venues from the regvenues table. Note that vendor rooms are
		generally limited to rooms in the hotel that are so designated.
		
		Check for online Esprit instead of in-person, restrict offerings
	*/
	include_once "online_switch.php";

	global $tpl;
	$temp_access = $tpl['access'];
	mysql_login('Normal');
	$sql = 'SELECT DISTINCT venue_long
	FROM regvenues
	WHERE venue_type LIKE "%vendor"';
	$sql_result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error getting venue table: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to get venue names for vendors - sorry!');
	$r = [];
	while ($row = mysqli_fetch_assoc($sql_result)) {
		$r[] = $row['venue_long'];
	}
	return $r;
}

?>