<?php
/*
	Sets up and displays the "Copy to Current" tab for the Vendors susbystem.
	Only appears in the vendorsall screen (All Years Vendors).
	
	Stephanie Mitchell, 4 April, 2023
*/
/*
	See if logged in via Quadodo
*/

global $tpl;
define('QUADODO_IN_SYSTEM', true);
$dirname = dirname(__FILE__);
$basename = dirname($dirname);

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once "mysql_utilities.php";
require_once "header.php";
require_once ".config.php";
require_once "generate_confirmation.php";
require_once "setup.php";
require_once "fieldlist.php";
require_once "template_options.php";
$tpl['authgroup'] = $qls->group_id_to_name($qls->user_info['group_id']);
$tpl['username'] = $qls->user_info['username'];
if ($tpl['username'] == '') {
	header('Location: ../qls/login.php');
	exit;
}

$primarykeyfieldvalue = $_REQUEST['pkfv'];
$primarykeyfieldname = $_REQUEST['pkfn'];
$group = $_REQUEST['group'];
$all_years = $_REQUEST['all_years'] ?? '';
mysql_login('Normal');
$mydata = get_mysql_fields('AddNew', $fields, $primarykeyfieldname, $primarykeyfieldvalue, 'regall r, regvendorall s', 'r.confirmation_no=s.confirmation_no', 's');

/*
	Force a distinctive group name to identify the new record
*/
$mydata['bus_name'] .= ' (NEW)';

/*
	Some vendor records don't have resourcedate set (it's not usually required
	for businesses). If there isn't one (i.e. it's empty), we unset it so it
	will default to NULL on the table insert.
*/
if ($mydata['resourcedate'] == '') {
	unset($mydata['resourcedate']);
} 

/*	Now we must figure out which confirmation number to attach the cloned record
	to. We first look for matching email address and is_vendor flag in the
	current year. If there isn't one (usually because the vendor hasn't (yet)
	been cloned), tell the user and suggest she clone the vendor record first.
*/
/*	First get the email address required. Have to look it up in the regall table. */

$sql = "SELECT email
FROM regall
WHERE confirmation_no='{$mydata['confirmation_no']}'";
// print __FILE__ . ':' . __LINE__ .": SQL command is $sql....<br />";
$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die("Internal error - should be able to find email for confirmation _no {$mydata['confirmation_no']} but can't.");

$r = mysqli_fetch_assoc($result);

$sql = "SELECT confirmation_no, email
FROM reg
WHERE email='{$r['email']}'
	AND is_vendor='Yes'";
// print __FILE__ . ':' . __LINE__ .": SQL command is $sql....<br />";
$result = mysqli_query($GLOBALS['dbConnect'], $sql);

if ($r = mysqli_fetch_assoc($result)) {	//	Did we find one?
	print "<span style=\"color: green\">Found matching vendor {$r['email']} ({$r['confirmation_no']})</span><br />";
	$mydata['confirmation_no'] = $r['confirmation_no'];
} else {
	print "<span style=\"color: red\">NO MATCHING VENDOR found. Cannot clone business. Please create or clone VENDOR first, then retry this.</span>";
	$mydata['confirmation_no'] = null;
}

// print __FILE__ . ':' . __LINE__ . 'Copy to Current: got data.<br />';
// print_r($mydata);

//	Delete imported timestamp and update dates as they're not appropriate to new record.
unset($mydata['timestamp']);	//	MySQL inserts this automatically
unset($mydata['updated']);		//	MySQL inserts this automatically

if ($mydata['confirmation_no'] == null) {	//	Can't clone.
	exit;
}

$possible_nulls = ['desk', 'flyer', 'deskchair', 'mirror', 'bigchair', 'nightstands', 'table6x35',
	'table6x15', 'foldchairs', 'rollaways'];

foreach ($possible_nulls as $possible_null) {
	if ($mydata[$possible_null] == null) {	//	Avoid null-value errors when updating
		$mydata[$possible_null] = 0;
	}
}
// insert the new record and get the new auto_increment id
$sql = "INSERT INTO regvendorall (`{$primarykeyfieldname}`) VALUES (NULL)";
$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on insert while copying vendor to current year: ' . mysqli_error($GLOBALS['dbConnect']) . ". Query=$sql", 'Unable to update information while copying vendor to current year - sorry!');
$newid = mysqli_insert_id($GLOBALS['dbConnect']);

/*	This is SO ugly. we must skip the email data item as it's not a field in
	the table we're updating. There should be a better way but for the moment
	this will have to do.
*/

// generate the query to update the new record with the previous values
$sql = "UPDATE regvendorall SET ";
foreach ($mydata as $key => $value) {
	if ($key != $primarykeyfieldname) {
		if (isset($fields[$key]['copyValue'])) {
			$sql .= '`'.$key.'` = "'.str_replace('"','\"',$fields[$key]['copyValue']).'", ';
		} else {
			$sql .= '`'.$key.'` = "'.str_replace('"','\"',$value).'", ';
		}
	}
} 

$sql = substr($sql, 0, strlen($sql)-2); // lop off extra trailing comma
$sql .= " WHERE {$primarykeyfieldname}={$newid}";
$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on update while copying vendor to current year: ' . mysqli_error($GLOBALS['dbConnect']) . ". Query=$sql_escaped", 'Unable to update information while copying vendor to current year - sorry!');
$sql_escaped = $sql; //mysqli_real_escape_string($GLOBALS['dbConnect'], $sql);
Make_Log_Entry($GLOBALS['dbConnect'], "NEW BUSINESS CLONED: $sql_escaped");
mysql_logout();	//	Disconnect from database

$e = new Smarty_Esprit;
$e->addPluginsDir("{$_SERVER['DOCUMENT_ROOT']}/plugins/");
$e->registerPlugin("modifier","ss", "stripslashes");
$e->assign('mydata',$mydata);
// print_r($tpl);
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/templates/");
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/$dirname/templates/");
$e->display('vendor_detail.tpl');
?>
