{* Smarty *}
{*	smse_recordlist.tpl
	Smarty template that produces a list of records using Highslide. The
	list includes the fields that have 'Master' in their fieldgroup parameter in
	fieldlist.php, with a dropdown menu for displaying further detail.
	
	In this version, double-clicking anywhere on a row opens a Highslide window with the
	initial detail displayed. There is no action button any more.
	
	This works by listening for a double-click event on any table row. The first
	<td> in the row contains <a> elements to open all the highslide windows for
	each tab. A double-click on a row triggers a click on the frst <a>, thus
	opening its Highslide window. We use a double-click to make it more
	deliberate and to prevent the click event from bubbling up and causing
	recursion.
*}
<!--smse_recordlist.tpl - BEGIN-->

<script>
	$(function() {
		$( ".tabs" ).tabs({
			ajaxOptions: {
				cache: false,
				/* async: false, */
				error: function( xhr, status, index, anchor ) {
					$( anchor.hash ).html(
						"<span class=\"warning\">Couldn't show this tab. There may be a problem with it or it may not have been written yet.</span>" );
				}
			}
		} );
		$("#smse_tablebody tr").dblclick(function() {
				$(this).find("a").first().click();
		} );
		$("#smse_tablebody tr").taphold(function() {
				$(this).find("a").first().click();
		} );
	} );
</script>
{* Generate heading "row" *}
<table class="records">
<!-- <thead> -->
<tr style="height:0px"><form name="Sortable_Headings" id="sortable_headings" action="#" method="POST">
<th style="width:0%; display: none">
<input type="hidden" name="_sort_table" value="{$sort_table}">
<input type="hidden" name="_sort_field" value="{$sort_field}">
<input type="hidden" name="_sort_order" value="{$sort_order}">
<input type="hidden" name="_action" value="">
</th><!-- Leave a column for URLs for Highslide tabs -->
{foreach $fields as $thisfield}
	{if $thisfield.table ne ''}
		{$sort_table = "`$thisfield.table`."}
	{/if}
	{if strpos(".{$thisfield.fieldgroup}", 'Master') > 0}
		<th>
		{if $thisfield.callback ne ''}
			<button type="button" name="_sort_field_button" title="Can't sort by  {$thisfield.heading}" onClick="alert('Sorry - Can\'t sort by this column'); return false;"><b>{$thisfield.heading}</b>
		{else}
			{$arrow = ''}	{* Not sorted, no arrow *}
			{$neworder = ''}	{* Action when clicked (default ascending sort) *}
			{if $thisfield@key == $sort_field}
				{if $sort_order == " DESC"}
					{$arrow = '<img src="/images/sm_desc.png">'}
					{$neworder = ''} {* Action when clicked *}
				{else}
					{$arrow = '<img src="/images/sm_asc.png">'}
					{$neworder = ' DESC'} {* Action when clicked *}
				{/if}
			{/if}
			{* Draw button *}
			<button type="button" name="_sort_field_button" title="Sort ascending by {$thisfield.heading}" onClick="this.form._sort_table.value='{$thisfield.table}';this.form._sort_field.value='{$thisfield@key}';this.form._sort_order.value='{$neworder}';this.form._action.value='Sort';this.form.submit();"><b>{$arrow}{$thisfield.heading}</b>
		{/if}
		</button>
		</th>
	{/if}
{/foreach}
</form>
</tr>
<!-- </thead> -->
<tbody id="smse_tablebody"><!-- Double-clicks are listened for via jQuery-->
{section name=sec1 loop=$data}
{$mydata=$data[sec1]}
<tr style="cursor: pointer">
<td style="width:0px; display:none"><!-- URLs for Highslide tabs -->
{foreach $tpl.fieldgroups as $thisgroup} {* build tabs *}
	{if $thisgroup@key ne 'Master' and ($thisgroup.authgroup eq '' or in_array($tpl.authgroup, $thisgroup.authgroup))}
		{$url="href=\"{$thisgroup.url}{if strpos($thisgroup.url,'?')>0}&{else}?{/if}group={$thisgroup@key}&pkfn={$primarykeyfield}&pkfv={$mydata.$primarykeyfield}\" 
		onclick=\"return hs.htmlExpand(this, { objectType: 'iframe', slideshowGroup:'{$mydata.$primarykeyfield}'{if $thisgroup.width>0}, width: {$thisgroup.width}{/if}{if $thisgroup.height>0},height: {$thisgroup.height}{/if} } )\""}
	<a {$url}>{$thisgroup.label}</a>
	{/if}
{/foreach}
</td><!-- End of Highslide tab URL td -->
{foreach $fields as $thisfield} {* Build master field list *}
	{if strpos(".{$thisfield.fieldgroup}", 'Master') > 0}
	<td {if $thisfield.css ne ''}style="{$thisfield.css}"{/if}>
	{if $thisfield.truncate_display gt 0}
		{$mydata.{$thisfield@key}|truncate:$thisfield.truncate_display:"[more...]"}
	{elseif $thisfield.date_format ne ''}
		{$mydata.{$thisfield@key}|date_format:$thisfield.date_format}
	{else}
		{$mydata.{$thisfield@key}}
	{/if}&nbsp;</td>
	{/if}
{/foreach}
</tr>
{/section}
</tbody>
</table>
<!--smse_recordlist.tpl - END-->
