{* Smarty template for displaying two fields in a detail screen. Place it inside <tr> tags *}
{* Parameters:
	$tname1		table name 1
	$fname1		field name 1
	$pkey1		primary key field name 1
	$ftype1		field display type 1
	$tname2		table name 2
	$fname2		field name 2
	$pkey2		primary key field name 2
	$ftype2		field display type 2
	$dname		field label (overrides heading or long_heading field from fieldlist.php
				if not null) - there is only one field label for both fields as they're
				assumed to be related
	$labelhelp	field help (explanatory note below field label) - there is only one field
				help for both fields as they're assumed to be related
	$labelcss	additional CSS for label (e.g. background colour)
	$fieldcss	additional CSS for value sections (e.g. background, bold)
*}
	<td class="label" width="15%" {if $labelcss ne ''}style="{$labelcss}"{/if}><span 
	{*	Generate additional help text in tooltip. If labelhelp parameter is supplied, use
		it. Otherwise use labelhelp field from fieldlist.php if any. *}
	{if $labelhelp ne ''} title="{$labelhelp}"
	{elseif $tpl.fields.$fname.labelhelp ne null} title="{$tpl.fields.$fname.labelhelp}"{/if}>
	{*	Generate field label. If dname is supplied, use that. Otherwise if field's
		long_heading is supplied in fieldlist.php file, use that. Failing that, use
		field's heading from fieldlist.php. *}
	{if $dname ne ''}{$dname}
	{elseif $tpl.fields.$fname1.long_heading ne ''}{$tpl.fields.$fname1.long_heading}
	{else}{$tpl.fields.$fname1.heading}</span></td>
	{/if}
	{*	Generate actual field 1. *}
	<td>{if $ftype1 eq 'display'}<span class="value" style={"$fieldcss"}>{$mydata.$fname1}</span>
	{else}<span class="{$ftype1}" style="{$fieldcss}" id="{$tname1}.{$fname1}.{$mydata.$pkey1}.{$pkey1}">{$mydata.$fname1}</span>{/if}

	{*	Generate actual field 2. *}
&nbsp;{if $ftype2 eq 'display'}<span class="value" style={"$fieldcss"}>{$mydata.$fname2}</span>
	{else}<span class="{$ftype2}" style="{$fieldcss}" id="{$tname2}.{$fname2}.{$mydata.$pkey2}.{$pkey2}">{$mydata.$fname2}</span>{/if}</td>