{*	Snippet that generates multicoloured meals table.
	Updated to accept "editable" parameter to support jEditable jQuery plugin
	for edit-in-place capabilities. Edit-in-place puts actual meal counts (which
	may be >1) in place of the L or D.
	Updated to include mealxchecked fields when editable is true.
	Updated to accept $editable=blank to omit letter tags and display only the
	coloured bar.
	
*}
<div style="width: {$width};">
<table>
<tr class="daytable" style="font-size: 5pt">
{$days=array('daysun1','daymon','daytue','daywed','daythu','dayfri','daysat','daysun2')} {* styles with these names must appear in stylesheet *}
{foreach $days as $day}
	<td width="12.5%"{if $mydata.$day eq 1} class="{$day}"{/if}>
	
	{if $editable === true} {* use edit-in-place form *}
	
		{if $day == 'dayfri'}
			<table>
			<tr>
			<td>&nbsp;<br /> <!-- No veterans' breakfast (meal1) -->
			&nbsp;</span></td>
			<td><span class="edit clear whitefont inlineblock" id="reg.meal2.{$mydata.entrynum}.entrynum">{$mydata.meal2}</span><br />
			<span class="edit clear whitefont inlineblock" id="reg.meal2checked.{$mydata.entrynum}.entrynum">{$mydata.meal2checked}</span></td>
			<td><span class="edit clear whitefont inlineblock" id="reg.meal3.{$mydata.entrynum}.entrynum">{$mydata.meal3}</span><br />
			<span class="edit clear whitefont inlineblock" id="reg.meal3checked.{$mydata.entrynum}.entrynum">{$mydata.meal3checked}</span></td>
			</tr>
			</table>
		{/if}
		{if $day == 'daysat'}
			<table>
			<tr>
			<td><span class="edit clear whitefont inlineblock" id="reg.meal4.{$mydata.entrynum}.entrynum">{$mydata.meal4}</span><br />
			<span class="edit clear whitefont inlineblock" id="reg.meal4checked.{$mydata.entrynum}.entrynum">{$mydata.meal4checked}</span></td>
			<td><span class="edit clear whitefont inlineblock" id="reg.meal5.{$mydata.entrynum}.entrynum">{$mydata.meal5}</span><br />
			<span class="edit clear whitefont inlineblock" id="reg.meal5checked.{$mydata.entrynum}.entrynum">{$mydata.meal5checked}</span></td>
			</tr>
			</table>
		{/if}
		{if $day == 'daysun2'}
			<table>
			<tr>
			<td><span class="edit clear whitefont inlineblock" id="reg.meal6.{$mydata.entrynum}.entrynum">{$mydata.meal6}</span><br />
			<span class="edit clear whitefont inlineblock" id="reg.meal6checked.{$mydata.entrynum}.entrynum">{$mydata.meal6checked}</span></td>
			</tr>
			</table>
		{/if}
	{elseif $editable == 'blank'}	{* don't display letters, just colour bar *}
	{else} {* use display-only form *}
		<span class="whitefont inlineblock">
		{if $day == 'dayfri'}
			{* {if $mydata.meal1 > 0} B {/if} *}&nbsp; <!-- no veterans' breakfast -->
			{if $mydata.meal2 > 0} L {/if}
			{if $mydata.meal3 > 0} D {/if}
		{/if}
		{if $day == 'daysat'}
			{if $mydata.meal4 > 0} L {/if}
			{if $mydata.meal5 > 0} D {/if}
		{/if}
		{if $day == 'daysun2'}
			{if $mydata.meal6 > 0} B {/if}
		{/if}
		</span>
	{/if}
	
	</td>
{/foreach}
</tr>
</table>
</div>