<?php
/*	Tab setup.
	Creates and displays a tab for the selected record.
	The following variables should be set before including this:
		$dirname		directory for this subsystem
		$tabtemplate	Smarty template for tab
		$access			unset (full access) or "read_only"
		$editable		This is for allfields_detail.tpl;
						unset (all fields are editable) or
						table alias for editable fields. Necessary because some
						fieldlists have fields from more than one table.
*/
	/*
		See if logged in via Quadodo
	*/
define('QUADODO_IN_SYSTEM', true);

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'header.php';
global $tpl;
if (!isset($editable)) {
	$editable = false;
}
$tpl['authgroup'] = $qls->group_id_to_name($qls->user_info['group_id']);
$tpl['username'] = $qls->user_info['username'];
$tpl['access'] = $access;
$tpl['editable'] = isset($editable) ? $editable : false;
if ($tpl['username'] == '') {
	header('Location: /qls/login.php');
	exit;
}
//	print '<pre>';print_r($_SERVER);print '</pre>';
require_once ".config.php";
require_once "utils.php";
//	check_access($tpl['authgroup']);
require_once "$dirname/fieldlist.php";
require_once "$dirname/template_options.php";
require_once "mysql_utilities.php";
require_once "setup.php";
// print __FILE__ . '/' . __LINE__ . '<pre>'; print_r($db);print '</pre>';
$mydata = get_mysql_fields($group, $fields, $primarykeyfieldname, $primarykeyfieldvalue, $db['tb'], $opts['join_clause']);
// 	print '<pre>';print_r($mydata);print '</pre>';
$e = new Smarty_Esprit;
$e->addPluginsDir("{$_SERVER['DOCUMENT_ROOT']}/plugins/");
// print "Pluginsdir: "; $temp = realpath("{$_SERVER['DOCUMENT_ROOT']}/plugins/"); print $temp; print '...';
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/templates/");
$e->registerPlugin("modifier","ss", "stripslashes");
$e->assign('mydata', $mydata);
$e->assign('dirname', $dirname);
$e->assign('db', $db);
$e->assign('editable', $editable);
$e->assign('pkfv', $primarykeyfieldvalue);
$e->assign('pkfn', $primarykeyfieldname);
$pgd = $e->getPluginsDir();
$e->assign('myplugindirs', print_r($pgd, true));

$e->display($tabtemplate);
?>
