<?php
/*
	Esprit Online Scholarship System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');
global $opts, $all_years;

/* MySQL table names */

if ($all_years) {
	$db['tb'] = 'scholappall r';
	$db['tbnoalias'] = 'scholappall';
} else {
	$db['tb'] = 'scholapp r';
	$db['tbnoalias'] = 'scholapp';
}
$opts['join_clause'] = '';
/* Field definitions start here */
// print "\$all_years: $all_years";
if ($all_years) {
	$fields['esprit_year'] = [
			'heading' => "Esprit Year",
			'table' => 'r',
			'select' => true,
			'display' => true,
			'fieldgroup' => '*, Master',
	// 		'copyValue' => '9999',	//	Uncomment to test copyValue
			'width' => '8%',
			'search_more' => false,
			'filter' => ""];
} else {
	$fields['esprit_year'] = [
			'heading' => "Esprit Year",
			'table' => 'r',
			'select' => true,
			'display' => true,
			'fieldgroup' => '*',
			'search_more' => false,
			'filter' => ""];
}
// print "\$all_years=$all_years, \$db[tb]={$db['tb']}";
$fields['timestamp'] = [
		'heading' => "Time Stamp",
		'table' => 'r',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'width' => '8%',
		'css' => 'font-size:80%',
		'fieldgroup' =>  'Master, Basic, Application, Award, Letters',	//	No copy
		'helpfile' => 'help/timestamphelp.php',
		'filter' => ""];
$fields['updated'] = [
		'heading' => "Updated",
		'table' => 'r',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'width' => '8%',
		'css' => 'font-size:80%',
		'search_more' => true,
		'fieldgroup' =>  'Master, Basic, Application, Award, Letters',	//	No copy
		'filter' => ""];
$fields['preferredfirst'] = [
		'heading' => "Preferred First Name",
		'table' => 'r',
		'fieldgroup' => 'Master, *',
		'display' => true,
		'width' => '20%',
		'filter' => ""];
$fields['preferredlast'] = [
		'heading' => "Preferred Last Name",
		'table' => 'r',
		'fieldgroup' => 'Master, *',
		'display' => true,
		'width' => '20%',
		'filter' => ""];
$fields['legalfirst'] = [
		'heading' => "Legal First Name",
		'table' => 'r',
		'fieldgroup' => '*',
		'display' => true,
		'filter' => ""];
$fields['legallast'] = [
		'heading' => "Legal Last Name",
		'table' => 'r',
		'fieldgroup' => '*',
		'display' => true,
		'filter' => ""];
$fields['email'] = [
		'heading' => "Email",
		'table' => 'r',
		'fieldgroup' => '*',
		'display' => true,
		'filter' => ""];
$fields['confirmation_no'] = [
		'heading' => "Confirmation No",
		'table' => 'r',
		'fieldgroup' => '*',
		'display' => true,
		'filter' => ""];
$fields['address1'] = [
		'heading' => "Address 1",
		'table' => 'r',
		'fieldgroup' => '*',
		'select' => true,
		'filter' => ""];
$fields['address2'] = [
		'heading' => "Address 2",
		'table' => 'r',
		'fieldgroup' => '*',
		'select' => true,
		'filter' => ""];
$fields['city'] = [
		'heading' => "City",
		'table' => 'r',
		'fieldgroup' => '*, Master',
		'display' => true,
		'width' => '10%',
		'filter' => ""];
$fields['stateprov'] = [
		'heading' => "State/Prov",
		'table' => 'r',
		'fieldgroup' => '*',
		'display' => true,
		'arrayedit' => true,
		'filter' => ""];
$fields['status'] = [
		'heading' => "Status",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'fieldgroup' => 'Master, Application, Award',
		'arrayedit' => true,
		'widget' => 'menu',
		'allowedvalues' => ['New', 'Pending Reference',
			'Pending Committee', 'Awarded', 'Denied', 'Notified', 'Accepted',
			'Declined', 'Withdrawn', 'Participant Cancelled'],
		'allowedlabels' => ['New', 'Pending Reference',
			'Pending Committee', 'Awarded', 'Denied', 'Notified', 'Accepted',
			'Declined', 'Withdrawn', 'Participant Cancelled'],
		'helpfile' => 'help/scholstatushelp.php',
		'filter' => ""];
$fields['zippostal'] = [
		'heading' => "Zip/Postal",
		'table' => 'r',
		'fieldgroup' => '*',
		'select' => true,
		'filter' => ""];
$fields['country'] = [
		'heading' => "Country",
		'table' => 'r',
		'fieldgroup' => '*',
		'select' => true,
		'filter' => ""];
$fields['phone'] = [
		'heading' => "Phone",
		'table' => 'r',
		'fieldgroup' => '*',
		'display' => true,
		'arrayedit' => true,
		'widget' => 'phonemask',
		'search_more' => true,
		'filter' => ""];
$fields['phonebesttime'] = [
		'heading' => "Time to Call",
		'table' => 'r',
		'fieldgroup' => '*',
		'search_more' => true,
		'display' => true,
		'filter' => ""];
$fields['phoneaskfor'] = [
		'heading' => "Ask for",
		'table' => 'r',
		'fieldgroup' => '*',
		'search_more' => true,
		'display' => true,
		'filter' => ""];
$fields['timesattended'] = [
		'heading' => "Times attended",
		'table' => 'r',
		'fieldgroup' => 'Application',
		'select' => true,
		'filter' => ""];
$fields['category01'] = [
		'heading' => "First timer",
		'table' => 'r',
		'fieldgroup' => 'Application, Award, *',
		'select' => true,
		'filter' => ""];
$fields['category02'] = [
		'heading' => "International",
		'table' => 'r',
		'fieldgroup' => 'Application, Award, *',
		'select' => true,
		'filter' => ""];
$fields['category03'] = [
		'heading' => "Couple",
		'table' => 'r',
		'fieldgroup' => 'Application, Award, *',
		'select' => true,
		'filter' => ""];
$fields['category04'] = [
		'heading' => "Financial Need",
		'table' => 'r',
		'fieldgroup' => 'Application, Award, *',
		'select' => true,
		'filter' => ""];
$fields['reasonforapplying'] = [
		'heading' => "App. Reason",
		'table' => 'r',
		'fieldgroup' => 'Application',
		'select' => true,
		'filter' => ""];
$fields['incomelevel'] = [
		'heading' => "Income level",
		'table' => 'r',
		'fieldgroup' => 'Application',
		'select' => true,
		'filter' => ""];
$fields['daysattending'] = [
		'heading' => "Days attending",
		'table' => 'r',
		'fieldgroup' => 'Application',
		'select' => true,
		'filter' => ""];
$fields['nightsattending'] = [
		'heading' => "Nights attending",
		'table' => 'r',
		'fieldgroup' => 'Application',
		'select' => true,
		'filter' => ""];
$fields['reference'] = [
		'heading' => "Reference",
		'table' => 'r',
		'fieldgroup' => '*',
		'select' => true,
		'search_more' => true,
		'filter' => ""];
$fields['referenceemail'] = [
		'heading' => "Reference email",
		'table' => 'r',
		'fieldgroup' => '*',
		'select' => true,
		'search_more' => true,
		'filter' => ""];
$fields['referenceorg'] = [
		'heading' => "Reference club",
		'table' => 'r',
		'fieldgroup' => '*',
		'select' => true,
		'search_more' => true,
		'filter' => ""];
$fields['notes'] = [
		'heading' => "Notes",
		'table' => 'r',
		'fieldgroup' => '*',
		'select' => true,
		'filter' => ""];
$fields['attsig'] = [
		'heading' => "Signed",
		'table' => 'r',
		'fieldgroup' => '*',
		'select' => true,
		'filter' => ""];
$fields['sigothersig'] = [
		'heading' => "Signed",
		'table' => 'r',
		'fieldgroup' => '*',
		'select' => true,
		'filter' => ""];
$fields['travelradius'] = [
		'heading' => "Travel Radius",
		'table' => 'r',
		'fieldgroup' => 'Application',
		'select' => true,
		'filter' => ""];
$fields['scholarship_request'] = [
		'heading' => "Amount Requested",
		'table' => 'r',
		'fieldgroup' => 'Award, *',
		'display' => true,
		'search_more' => true,
		'arrayedit' => true,
		'filter' => ""];
$fields['scholarship_req_prorate_by_stay'] = [
		'heading' => "Prorated by Stay",
		'table' => 'r',
		'fieldgroup' => 'Award',
		'display' => true,
		'search_more' => true,
		'arrayedit' => true,
		'filter' => ""];
$fields['scholarship_req_prorate_by_repeat'] = [
		'heading' => "Prorated by Repeat",
		'table' => 'r',
		'fieldgroup' => 'Award',
		'display' => true,
		'search_more' => true,
		'arrayedit' => true,
		'filter' => ""];
$fields['scholarship_req_prorate_by_combined'] = [
		'heading' => "Prorated by Both",
		'table' => 'r',
		'fieldgroup' => 'Award',
		'display' => true,
		'search_more' => true,
		'arrayedit' => true,
		'filter' => ""];
$fields['scholarship_amount'] = [
		'heading' => "Amount Awarded",
		'table' => 'r',
		'fieldgroup' => 'Award, *',
		'display' => true,
		'search_more' => true,
		'arrayedit' => true,
		'filter' => ""];
$fields['committeenotes'] = [
		'heading' => "Committee Notes",
		'table' => 'r',
		'fieldgroup' => '*',
		'select' => true,
		'filter' => ""];
$fields['entrynum'] = [
		'primarykey' => true,
		'table' => 'r',
		'fieldgroup' => '*, AddNew',
		'filter' => ""];
// print_r($fields['esprit_year']); exit;
/* End of Field definitions. */

/*	Field group definitions */

if (!$all_years) {	//	Current year

	$tpl['fieldgroups'] = [
		'Master' => ['label'=>'Master',
			'url' =>'',
			'authgroup' => ['Admin', 'Scholarships'],
			'width' => 1000,
			'height' => 800],
		'Basic' => ['label' => 'Basic',
			'url' => 'taburl.php?template=basic_detail.tpl',
			'authgroup' => ['Admin', 'Scholarships'],
			'width' => 1000,
			'height' => 800],
		'Application' => ['label' => 'Application',
			'url' => 'taburl.php?template=application_detail.tpl',
			'authgroup' => ['Admin', 'Scholarships'],
			'width' => 1000,
			'height' => 800],
		'Award' => ['label' => 'Award',
			'url' => 'taburl.php?template=award_detail.tpl',
			'authgroup' => ['Admin', 'Scholarships'],
			'width' => 1000,
			'height' => 800],
		'Letters' => ['label' => 'Letters',
			'url' =>'../letterssendmailtaburl.php?appname=scholarships',
			'authgroup' => ['Admin', 'Scholarships'],
			'width' => 1000,
			'height' => 800],
		'Logs' => ['label' => 'Log Entries',
			'url' => "../log-list.php?tbname={$db['tbnoalias']}",
			'width' => 1500,
			'height' => 800,
			'authgroup' => ['Admin']],
		'All' => ['label' => 'All Fields',
			'url' => '../allfieldsurl.php?dirname=scholarships',
			'authgroup' => ['Admin', 'Scholarships'],
			'width' => 1000,
			'height' => 800],
		'Delete' => ['label' => 'Delete',
			'url' => 'delete.php',
			'authgroup' => ['Registrar', 'Admin'],
			'scroll' => 'No'	//	Prevent scrolling to this screen
			]
	];
} else {	//	All years

	$tpl['fieldgroups'] = [
		'Master' => ['label'=>'Master',
			'url' =>'',
			'authgroup' => ['Admin', 'Scholarships']],
		'Basic' => ['label' => 'Basic',
			'url' => 'taburl.php?template=basic_detail.tpl&all_years=true&access=read_only',
			'authgroup' => ['Admin', 'Scholarships']],
		'Application' => ['label' => 'Application',
			'url' => 'taburl.php?template=application_detail.tpl&all_years=true&access=read_only',
			'authgroup' => ['Admin', 'Scholarships']],
		'Award' => ['label' => 'Award',
			'url' => 'taburl.php?template=award_detail.tpl&all_years=true&access=read_only',
			'authgroup' => ['Admin', 'Scholarships']],
		'Logs' => ['label' => 'Log Entries',
			'url' => "../log-list.php?tbname={$db['tbnoalias']}",
			'width' => 1500,
			'height' => 800,
			'authgroup' => ['Admin']],
		'All' => ['label' => 'All Fields',
			'url' => '../allfieldsurl.php?dirname=scholarshipsall',
			'authgroup' => ['Admin', 'Scholarships']],
		'Copy' => ['label' => 'Copy to Current Year',
			'url' => 'copy_to_current.php?group=Copy',
			'authgroup' => ['Registrar', 'Admin', 'Presenter', 'Vendor']]
	];
}
/*
	All-years field groups (all set to read-only)
*/
/* Field group definitions */


?>