<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 10 January, 2013
		
	This configuration file provides the template options for SM_SQLEdit.
*/

/*	Protect from non-logged in users */

//	print_r($_SERVER);
global $tpl;

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once "mysql_utilities.php";
require_once "utils.php";

$tpl['regsystemversion'] = $GLOBALS['regsystemversion'];	// From config.php

$tpl['fileprefix'] = '/';	// For use with multi-file applications
$tpl['appname'] = basename(dirname(__FILE__));

/*	Template parameters.
	All these get passed straight through to the Smarty template. They include
	style sheets, included templates, headings etc. File path is relative to
	the current directory.
*/

/* Fieldlist */

$tpl['fields'] = $fields;

/* Stylesheets */

$cssdir = '/css';
$tpl['stylesheet'] = [];
$tpl['stylesheet'][] = "$cssdir/styles.css";
$tpl['stylesheet'][] = "$cssdir/reports.css";
$tpl['stylesheet'][] = "$cssdir/maint.css";
/* Custom stylesheet for jQuery UI elements. Uses symlink to ease updating */
$tpl['stylesheet'][] = "$cssdir/esprit-theme/jquery-ui.css";

/*
	Include all required Javascript bits for jQuery and jEditable.
*/

require_once "jeditable_includes.php";

/*
	Letters and Reports
*/

$tpl['letter_templates'] = get_mysql_letters($tpl['appname'], $tpl['authgroup']);
$tpl['table_reports'] = get_mysql_reports($tpl['appname'], $tpl['authgroup']);

/*
	Other options
*/
global $opts;
$opts['debug'] = false;
$opts['sort_field'] = 'r.report_group';
$opts['sort_order'] = '';
$opts['showdittos'] = 'true';
$opts['pagelimit'] = 100;	// override built-in limit of 20

/* Template header parameters. Edit to suit this system. */

$tpl['header']['title'] = "Esprit $esprit_year Registration System - Report Manager";
$tpl['header']['heading1'] = "<img src=\"/images/logo.gif\" width=\"250\" height=\"54\"> Esprit $esprit_year Registration - Report Manager";
$tpl['header']['preamblefile'] = "../{$tpl['appname']}/preamble.php";
$tpl['header']['year'] = $esprit_year;
$tpl['header']['esprit_address'] = $GLOBALS['esprit_address'];
$tpl['header']['menubar'] = '../menubar.tpl';

/* SM_SQLEdit template controls */

$tpl['detailtemplate'] = $tpl['fileprefix'].'detail.tpl';
$tpl['edittemplate'] = $tpl['fileprefix'].'edit.tpl';
$tpl['privileges']['canedit'] = true; // set to false to remove edit buttons
$tpl['navbar'] = $tpl['fileprefix'].'nav.tpl';
$tpl['pagecounts'] = [10,20,30,50,100,500];	// extend pagecount limits
$tpl['recordlist'] = 'smse_recordlist.tpl';
$tpl['arrayedit'] = 'smse_arrayeditinplace.tpl';
$tpl['pluginsdir'] = '../plugins/';

/* Other URLS */

// $tpl['badgephotourl'] = $GLOBALS['badgephotodir'];	// folder for badge photos
// $tpl['qrurl'] = $GLOBALS['qrcodedir'];		// folder for QR codes
// $tpl['badgeiconurl'] = $GLOBALS['badgeicondir'];	// folder for badge icons

?>