<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

/* MySQL table names */

$db['tb'] = 'regvolunteertypes v';
$db['tbnoalias'] = 'regvolunteertypes';

global $opts;
$opts['join_clause'] = '';

/* Field definitions start here */

$fields['voltype_created'] = [
		'heading' => "Created",
		'table' => 'v',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'search_more' => true,
		'width' => '10%',
		'fieldgroup' =>  'Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['voltype_updated'] = [
		'heading' => "Updated",
		'table' => 'v',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'search_more' => true,
		'width' => '10%',
		'fieldgroup' =>  'Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['voltype_order'] = [
		'heading' => "Display Order",
		'table' => 'v',
		'display' => true,
		'arrayedit' => true,
		'search_more' => true,
		'width' => '10%',
		'fieldgroup' =>  'Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['voltype_name'] = [
		'heading' => "Activity Name",
		'table' => 'v',
		'display' => true,
		'width' => '20%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master, Detail, AddNew',
		'filter' => ""];
$fields['voltype_abbr'] = [
		'heading' => "Abbreviation",
		'table' => 'v',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master, Detail, AddNew',
		'filter' => ""];
$fields['voltype_date'] = [
		'heading' => "Date Required",
		'table' => 'v',
		'display' => true,
		'arrayedit' => true,
		'widget' => 'datetimepicker',
		'width' => '10%',
		'fieldgroup' => '*, Master, Detail, AddNew',
		'filter' => ""];
$fields['voltype_numreq'] = [
		'heading' => "Number Required",
		'table' => 'v',
		'display' => true,
		'arrayedit' => true,
		'width' => '10%',
		'fieldgroup' => '*, Master, Detail, AddNew',
		'filter' => ""];
$fields['voltype_esprit_format'] = [
		'heading' => "Esprit Format",
		'table' => 'v',
		'display' => true,
		'arrayedit' => true,
		'widget' => 'menu',
		'allowedvalues' => ['In-Person', 'Online', 'Dunno'],
		'allowedlabels' => ['In-Person', 'Online', 'Dunno'],
		'fieldgroup' => '*, Master, Detail, AddNew',
		'filter' => ""];
$fields['voltype_desc'] = [
		'heading' => "Description",
		'table' => 'v',
		'display' => true,
		'arrayedit' => true,
		'widget' => 'ckeditor',
		'fieldgroup' => '*, Master, Detail, AddNew',
		'filter' => ""];
$fields['voltype_contact'] = [
		'heading' => "Contact Email",
		'table' => 'v',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => '*, Master, Detail, AddNew',
		'filter' => ""];
$fields['voltype_id'] = [
		'heading' => 'Entry number',
		'primarykey' => true,
		'table' => 'v',
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];

/* End of Field definitions. */

/* Field group definitions */

$tpl['fieldgroups'] = [
/*	'Blank' => ['label' => '>',
		'url' => 'blank.php'], */
	'Master' => ['label'=>'Master',
		'url' =>''
		],
	'Detail' => ['label' => 'Details',
		'url' => 'taburl.php?template=volunteertypes_detail.tpl',
		'height' => '700',
		'width' => '1800',
		'authgroup' => ['Admin','Volunteer']
		],
	'AddNew' => ['label' => 'Copy',
		'url' => 'add.php',
		'authgroup' => ['Admin','Volunteer'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
	],
	'Logs' => ['label' => 'Log Entries',
		'url' => "../log-list.php?tbname={$db['tbnoalias']}",
		'width' => 1500,
		'height' => 800,
		'authgroup' => ['Admin']],
	'DeleteThis' => ['label' => 'Delete',
		'url' => 'delete.php',
		'authgroup' => ['Admin','Volunteer'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
		]
];

?>