<?php
/*
	Esprit Chart System, by Stephanie Mitchell
	3 December, 2017
	
	This file creates the Scholarships by Month Chart for the current year overview.
*/
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'mysql_utilities.php';
require_once ".config.php";
if (!isset($_REQUEST['data'])) {

	/*	This section sets up and actually outputs the chart into a div. It is only used if this file is called without the "data=true" parameter. */
	
	define('QUADODO_IN_SYSTEM', true);
	$chart_year = $_REQUEST['chart_year'];
	print <<< STUFF
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<title>Esprit $chart_year Online Registration Charts $test_msg</title>
<link href="../../lib/css/styles.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="/lib/js/jquery.js"></script>
<script type="text/javascript" src="/lib/js/jquery-ui.js"></script>
<script type="text/javascript" src="/lib/js/jquerymobile.js"></script>
<script language="javascript" src="/lib/js/fusioncharts.js"></script>
<script language="javascript" src="/lib/js/fusioncharts.maps.js"></script>
<script language="javascript" src="/lib/js/fusioncharts-jquery-plugin.js"></script>
<script type="text/javascript" src="/lib/js/themes/fusioncharts.theme.esprit.js"></script>


<script type="text/javascript">
jQuery(document).ready(function(){
    $("#chart").insertFusionCharts({
		type: "mscolumn3d",
		theme: "esprit",
		width: "800",
		height: "450",
		dataFormat: "XMLURL",
		dataSource: "scholarships_by_year_amount.php?data=true&chart_year=$chart_year"
    });
});
</script>
</head>
<body>
<div style="width:1800px" id="chart"></div>
STUFF;
print '
	<form id="form1" name="form1" method="post" action="#" class="noprint">
		Select a year:
		<select name="chart_year" id="chart_year" onchange="this.form.submit();">';

mysql_login('Read-only');

	$sql = "SELECT DISTINCT esprit_year
	FROM regall
	ORDER BY esprit_year DESC;";

	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
while ($row = mysqli_fetch_array($result)) {	// collect years for dropdown
	print "<option";
	if ($chart_year == $row['esprit_year']) {
		print ' selected="selected"';
	}
	print ">".$row['esprit_year']."</option>\n";
}
mysql_logout();	//	Disconnect from database

print "		</select>
	</form>

</body>
</html>";
} else {

	/* This section compiles, formats and outputs the data required for the chart that's called above.*/
	
	define('QUADODO_IN_SYSTEM', true);
	$chart_year = $_REQUEST['chart_year'];
	mysql_login('Read-only');

	$sql = 'SELECT count(*) AS schols, sum(scholarship_amount) AS amount,
		DATE(MAX(timestamp)) AS p
		FROM scholappall
		WHERE status NOT IN ("Cancelled", "DELETED")
			AND esprit_year='.$chart_year.'
		GROUP BY YEAR(timestamp),MONTH(timestamp)';

		$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);

	$count_shown = 0;
	// Get all the rows
	while ($row = mysqli_fetch_array($result)) {
		$data[] = $row;
		$count_shown++;
	}
	mysql_logout();	//	Disconnect from database

	$chart ='<chart
		caption="Esprit '.$chart_year.' Scholarship Amounts by Month"
		theme="esprit"
		xaxisname="Month"
		yaxisname="Number"
		exportenabled="1"
		exportformats="PNG=Export as PNG Image|PDF=Export as Printable|JPG=Export as JPEG|XLS=Export Chart Data"
		exporttargetwindow="_self"
		exportfilename="Scholarship Amounts by Month '.$chart_year.'"
		showvalues="1"
		valuefontcolor="#ffffff"
		placevaluesinside="1"
		rotatevalues="0"
		rotatelabels="1"
		slantlabels="1"
		formatNumberScale="0"
		decimals="0"
		numberprefix="$">';
	/*	plotfillalpha="80"
		basefontcolor="#333333"
		basefont="Helvetica Neue,Arial"
		captionfontsize="14"
		subcaptionfontsize="14"
		subcaptionfontbold="0"
		showborder="0"
		bgcolor="#ffffff"
		showshadow="0"
		canvasbgcolor="#ffffff"
		canvasborderalpha="0"
		divlinealpha="100"
		divlinecolor="#999999"
		divlinethickness="1"
		divlineisdashed="1"
		divlinedashlen="1"
		divlinegaplen="1"
		useplotgradientcolor="0"
		showplotborder="0"
		valuefontcolor="#ffffff"
		placevaluesinside="1"
		showhovereffect="1"
		rotatevalues="1"
		rotatelabels="1"
		slantlabels="1"
		showxaxisline="1"
		xaxislinethickness="1"
		xaxislinecolor="#999999"
		showalternatehgridcolor="0"
		anchorAlpha="0"
		showlegend="1"
		legendbgalpha="100"
		legendborderalpha="100"
		legendshadow="100"
		legenditemfontsize="10"
		legenditemfontcolor="#666666">
	';*/

	$chart .="<categories>\n";
	for ($n = 0 ; $n < $count_shown ; $n++) {
		$chart .="		<category label=\"".$data[$n]['p']."\" />\n";
	}

	$chart .="</categories>\n";

	/* Process awarded applications */
	$chart .="	<dataset seriesName=\"Amount\">\n";
	$total = 0;
	for ($n = 0 ; $n < $count_shown ; $n++) {
		$total += $data[$n]['amount'];
		$chart .="		<set value=\"$total\" tooltext=\"{$data[$n]['amount']} awarded this month\"/>\n";
	}
	$chart .="	</dataset>\n";

	$chart .="</chart>\n";
	print $chart;
}
?>
