<?php
/*
	Esprit Chart System, by Stephanie Mitchell
	3 December, 2017
	
	This file creates the Scholarships by Type Chart for the current year overview.
*/
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'mysql_utilities.php';
require_once ".config.php";
if (!isset($_REQUEST['data'])) {

	/*	This section sets up and actually outputs the chart into a div. It is only used if this file is called without the "data=true" parameter. */
	
	define('QUADODO_IN_SYSTEM', true);
	$chart_year = $_REQUEST['chart_year'];
	print <<< STUFF
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<title>Esprit $chart_year Online Registration Charts $test_msg</title>
<link href="../../lib/css/styles.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="/lib/js/jquery.js"></script>
<script type="text/javascript" src="/lib/js/jquery-ui.js"></script>
<script type="text/javascript" src="/lib/js/jquerymobile.js"></script>
<script language="javascript" src="/lib/js/fusioncharts.js"></script>
<script language="javascript" src="/lib/js/fusioncharts.maps.js"></script>
<script language="javascript" src="/lib/js/fusioncharts-jquery-plugin.js"></script>
<script type="text/javascript" src="/lib/js/themes/fusioncharts.theme.esprit.js"></script>


<script type="text/javascript">
jQuery(document).ready(function(){
    $("#chart").insertFusionCharts({
		type: "pie3d",
		theme: "esprit",
		width: "800",
		height: "450",
		dataFormat: "XMLURL",
		dataSource: "scholarships_by_type.php?data=true&chart_year=$chart_year"
    });
});
</script>
</head>
<body>
<div style="width:1800px" id="chart"></div>   
STUFF;
print '
	<form id="form1" name="form1" method="post" action="#" class="noprint">
		Select a year:
		<select name="chart_year" id="chart_year" onchange="this.form.submit();">';

mysql_login('Read-only');

	$sql = "SELECT DISTINCT esprit_year
	FROM regall
	ORDER BY esprit_year DESC;";

	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
while ($row = mysqli_fetch_array($result)) {	// collect years for dropdown
	print "<option";
	if ($chart_year == $row['esprit_year']) {
		print ' selected="selected"';
	}
	print ">".$row['esprit_year']."</option>\n";
}
mysql_logout();	//	Disconnect from database

print "		</select>
	</form>

</body>
</html>";
} else {

	/* This section compiles, formats and outputs the data required for the chart that's called above.*/
	
	define('QUADODO_IN_SYSTEM', true);
	$chart_year = $_REQUEST['chart_year'];
	mysql_login('Read-only');

	$sql = 'select count(*) as c, status as s from scholappall where status!="DELETED" AND esprit_year='.$chart_year.' group by status';

		$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);

	$count_shown = 0;
	$canvasStartX = 0;
	$canvasStartY = 0;
	// Get all the rows
	while ($row = mysqli_fetch_array($result)) {
		$data[] = $row;
		$count_shown++;
	}
	mysql_logout();	//	Disconnect from database

	$chart ='<chart
		caption="Esprit '.$chart_year.' Scholarships by Status"
		theme="esprit"
		showhovereffect="1"
		showpercentintooltip="0"
		showvalues="0"
		palettecolors="#FF3366,#AAAAAA,#FFCCCC,#DDDDDD,#FF99CC,#888888,#CC99CC,#666666,#CC99FF,#444444"
		bgcolor="#ffffff"
		exportenabled="1"
		exportformats="PNG=Export as PNG Image|PDF=Export as Printable|JPG=Export as JPEG|XLS=Export Chart Data"
		exporttargetwindow="_self"
		exportfilename="Scholarships by Status '.$chart_year.'">';
		/*
		showborder="0"
		use3dlighting="1"
		showshadow="1"
		enablesmartlabels="1"
		startingangle="0"
		showpercentvalues="0"
		decimals="1"
		captionfontsize="14"
		subcaptionfontsize="14"
		subcaptionfontbold="0"
		tooltipcolor="#ffffff"
		tooltipborderthickness="0"
		tooltipbgcolor="#000000"
		tooltipbgalpha="80"
		tooltipborderradius="2"
		tooltippadding="5"
		showlegend="0"
		legendbgcolor="#ffffff"
		legendborderalpha="0"
		legendshadow="0"
		legenditemfontsize="10"
		legenditemfontcolor="#666666"
		usedataplotcolorforlabels="1">'; */
	// Get all the rows of data selected earlier
	/* Process total registrations */
	for ($n = 0 ; $n < $count_shown ; $n++) {
		$chart .="		<set label=\"{$data[$n]['s']}\" value=\"{$data[$n]['c']}\" />\n";
	}
	$chart .= "    <annotations width=\"500\" height=\"300\" autoscale=\"1\">
			<annotationgroup id=\"user-images\">
				<annotation id=\"dyn-label\" type=\"text\" fillcolor=\"#000000\" fontsize=\"10\" text=\"Hover over segments to see values.\" italic=\"1\" wrap=\"1\" wrapwidth=\"170\" x=\"$canvasStartX+144\" y=\"$canvasStartY + 50\" />
			</annotationgroup>
		</annotations>";
	$chart .="</chart>\n";
	print $chart;
}
?>
