<?php
/*
	Esprit Chart System, by Stephanie Mitchell
	3 December, 2017
	
	This file creates the Registrations by Day Column Chart for the current year overview,
	excluding committee registrations.
*/
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'mysql_utilities.php';
require_once ".config.php";
if (!isset($_REQUEST['data'])) {

	/*	This section sets up and actually outputs the chart into a div. It is only used if this file is called without the "data=true" parameter. */
	
	define('QUADODO_IN_SYSTEM', true);
	$chart_year = $_REQUEST['chart_year'];
	print <<< STUFF
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<title>Esprit $chart_year Online Registration Charts $test_msg</title>
<link href="../../lib/css/styles.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="/lib/js/jquery.js"></script>
<script type="text/javascript" src="/lib/js/jquery-ui.js"></script>
<script type="text/javascript" src="/lib/js/jquerymobile.js"></script>
<script language="javascript" src="/lib/js/fusioncharts.js"></script>
<script language="javascript" src="/lib/js/fusioncharts.maps.js"></script>
<script language="javascript" src="/lib/js/fusioncharts-jquery-plugin.js"></script>
<script type="text/javascript" src="/lib/js/themes/fusioncharts.theme.esprit.js"></script>


<script type="text/javascript">
jQuery(document).ready(function(){
    $("#chart").insertFusionCharts({
		type: "zoomline",
		theme: "esprit",
		width: "800",
		height: "450",
		dataFormat: "XMLURL",
		dataSource: "regs_by_day_nocommittee.php?data=true&chart_year=$chart_year"
    });
});
</script>
</head>
<body>
<div style="width:1800px" id="chart"></div>
STUFF;
print '
	<form id="form1" name="form1" method="post" action="#" class="noprint">
		Select a year:
		<select name="chart_year" id="chart_year" onchange="this.form.submit();">';

mysql_login('Read-only');

	$sql = "SELECT DISTINCT esprit_year
	FROM regall
	ORDER BY esprit_year DESC;";

	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
while ($row = mysqli_fetch_array($result)) {	// collect years for dropdown
	print "<option";
	if ($chart_year == $row['esprit_year']) {
		print ' selected="selected"';
	}
	print ">".$row['esprit_year']."</option>\n";
}
mysql_logout();	//	Disconnect from database

print "		</select>
	</form>

</body>
</html>";
} else {

	/* This section compiles, formats and outputs the data required for the chart that's called above.*/
	
	define('QUADODO_IN_SYSTEM', true);
	$chart_year = $_REQUEST['chart_year'];
	mysql_login('Read-only');

	$sql = 'SELECT COUNT(*) AS regs, SUM(firstesprit='.$chart_year.') AS first,
		SUM(acct_status="Paid" AND firstesprit='.$chart_year.') AS firstpaid,
		SUM(acct_status="Paid") AS paid,
		DATE(MAX(timestamp)) AS p
	FROM regall
	WHERE reg_status NOT LIKE "%Cancelled%"
		AND reg_status != "DELETED"
		AND esprit_year='.$chart_year.'
		AND form_type NOT IN ("Internal", "Ticket", "Resource_Presenter", "Resource_Vendor", "Assistant", "Committee_Full", "Committee_Partial")
	GROUP BY YEAR(timestamp),MONTH(timestamp), DAY(timestamp)';
		$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);


	$chart ='<chart
		caption="Esprit '.$chart_year.' Registrations by Date"
		subcaption="(Excluding Vendors, Presenters and Committee Members)"
		theme="esprit"
		xaxisname="Date"
		yaxisname="Number"
		exportenabled="1"
		exportformats="PNG=Export as PNG Image|PDF=Export as Printable|JPG=Export as JPEG|XLS=Export Chart Data"
		exporttargetwindow="_self"
		exportfilename="Regs By Day '.$chart_year.'"
		anchorAlpha="0"
		showalternatehgridcolor="0"
		showTerminalValidData="1"
		numberprefix="">';
	/*	plotfillalpha="80"
		basefontcolor="#333333"
		basefont="Helvetica Neue,Arial"
		captionfontsize="14"
		subcaptionfontsize="14"
		subcaptionfontbold="0"
		showborder="0"
		bgcolor="#ffffff"
		showshadow="0"
		canvasbgcolor="#ffffff"
		canvasborderalpha="0"
		divlinealpha="100"
		divlinecolor="#999999"
		divlinethickness="1"
		divlineisdashed="1"
		divlinedashlen="1"
		divlinegaplen="1"
		useplotgradientcolor="0"
		showplotborder="0"
		valuefontcolor="#ffffff"
		placevaluesinside="1"
		showhovereffect="1"
		rotatevalues="1"
		rotatelabels="1"
		slantlabels="1"
		showxaxisline="1"
		xaxislinethickness="1"
		xaxislinecolor="#999999"
		showlegend="1"
		legendbgalpha="100"
		legendborderalpha="100"
		legendshadow="100"
		legenditemfontsize="10"
		legenditemfontcolor="#666666">
	';
	*/
	/*
		Build destination array of days. This will be filled sparsely by whatever
		day's data comes in, so we have a properly scaled timeline.
	*/
	$sql = 'SELECT DATE(MAX(timestamp)) AS e, DATE(MIN(timestamp)) as s
	FROM regall
	WHERE reg_status != "DELETED"
		AND reg_status NOT LIKE "%cancelled%"
		AND esprit_year = '.$chart_year.'
		AND form_type NOT LIKE "%Resource%"';
	$days = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);

	$row = mysqli_fetch_assoc($days);
	$start_day = $row['s'];
	$end_day = $row['e'];

	$chart .="<categories>\n";
	$data = array();
	$start_day_date = strtotime($start_day);
	$end_day_date = strtotime($end_day);
	for ($this_day_date = $start_day_date; $this_day_date <= $end_day_date; 
		$this_day_date = $this_day_date + (24 * 60 * 60)) {
		//	Create placeholder for 4 variables to be charted
		$data[date('Y-m-d', $this_day_date)] = array();
		//	Generate category heading
		$chart .="		<category label=\"".date('Y-m-d', $this_day_date)."\" />\n";
	}

	$chart .="</categories>\n";


	// Get all the rows of data selected earlier
	$count_shown = 0;
	while ($row = mysqli_fetch_assoc($result)) {
		$data[$row['p']]['regs'] = $row['regs'];
		$data[$row['p']]['first'] = $row['first'];
		$data[$row['p']]['firstpaid'] = $row['firstpaid'];
		$data[$row['p']]['paid'] = $row['paid'];
		$count_shown++;
	// print_r($row);
	// print '<br />';
	// print '<br />------------<br />';
	}
	mysql_logout();	//	Disconnect from database

	// exit;
	/*	Now populate the array with the values in $data. There will be zero-value
		elements where there is no data.
	*/

	foreach ($data as $d) {	//	Create empty prev_data array
		$prev_data = 0;
	}
	$ndata = array();
	$chart_regs = '';
	$chart_paid = '';
	$chart_first = '';
	$chart_firstpaid = '';
	$canvasStartX = 0;
	$canvasStartY = 0;
	foreach ($data as $this_date => $this_data) {
		foreach($this_data as $k => $d) {
			$ndata[$k] = $prev_data[$k] + $d;
		}
		$chart_regs .= "	<set value=\"{$ndata['regs']}\" tooltext=\"{$ndata['regs']} registered today\"/>\n";
		$chart_paid .= "	<set value=\"{$ndata['paid']}\" tooltext=\"{$ndata['paid']} paid today\"/>\n";
		$chart_first .= "	<set value=\"{$ndata['first']}\" tooltext=\"{$ndata['first']} first-timers registered today\"/>\n";
		$chart_firstpaid .= "	<set value=\"{$ndata['firstpaid']}\" tooltext=\"{$ndata['firstpaid']} first-timers paid today\"/>\n";
		$prev_data = $ndata;
	}
	$chart .= "    <annotations width=\"500\" height=\"300\" autoscale=\"1\">
			<annotationgroup id=\"user-images\">
				<annotation id=\"dyn-label\" type=\"text\" fillcolor=\"#000000\" fontsize=\"10\" text=\"Drag horizontally to zoom in, then use scroll bar at bottom.\nUse buttons at top right to zoom out or pin.\" italic=\"1\" wrap=\"1\" wrapwidth=\"170\" x=\"$canvasStartX+144\" y=\"$canvasStartY + 80\" />
			</annotationgroup>
		</annotations>";

	/* Process total registrations */
	$chart .="	<dataset seriesName=\"All\">\n$chart_regs</dataset>\n";

	/* Process Paid registrations */
	$chart .="	<dataset seriesName=\"Paid\">\n$chart_paid</dataset>\n";

	/* Process first-timer registrations */
	$chart .="	<dataset seriesName=\"First-Timers\">\n$chart_first</dataset>\n";

	/* Process first-timer PAID registrations */
	$chart .="	<dataset seriesName=\"FT Paid\">\n$chart_firstpaid</dataset>\n";

	$chart .="</chart>\n";
	print $chart;
}
?>
