<?php
/*
	Esprit Chart System, by Stephanie Mitchell
	3 December, 2017
	
	This file creates the Registrations by Canadian Province Map for the current year overview.
*/
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'mysql_utilities.php';
require_once ".config.php";
if (!isset($_REQUEST['data'])) {

	/*	This section sets up and actually outputs the chart into a div. It is only used if this file is called without the "data=true" parameter. */
	
	define('QUADODO_IN_SYSTEM', true);
	$chart_year = $_REQUEST['chart_year'];
	print <<< STUFF
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<title>Esprit $chart_year Online Registration Maps $test_msg</title>
<link href="../../lib/css/styles.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="/lib/js/jquery.js"></script>
<script type="text/javascript" src="/lib/js/jquery-ui.js"></script>
<script type="text/javascript" src="/lib/js/jquerymobile.js"></script>
<script language="javascript" src="/lib/js/fusioncharts.js"></script>
<script language="javascript" src="/lib/js/fusioncharts.maps.js"></script>
<script language="javascript" src="/lib/js/fusioncharts-jquery-plugin.js"></script>
<script type="text/javascript" src="/lib/js/themes/fusioncharts.theme.esprit.js"></script>


<script type="text/javascript">
jQuery(document).ready(function(){
    $("#chart").insertFusionCharts({
		type: "maps/canada",
		theme: "esprit",
		width: "800",
		height: "550",
		dataFormat: "XMLURL",
		dataSource: "maps_by_where_canada.php?data=true&chart_year=$chart_year"
    });
});
</script>
</head>
<body>
<div style="width:1000px" id="chart"></div>   
STUFF;
print '
	<form id="form1" name="form1" method="post" action="#" class="noprint">
		Select a year:
		<select name="chart_year" id="chart_year" onchange="this.form.submit();">';

mysql_login('Read-only');

	$sql = "SELECT DISTINCT esprit_year
	FROM regall
	ORDER BY esprit_year DESC;";

	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
while ($row = mysqli_fetch_array($result)) {	// collect years for dropdown
	print "<option";
	if ($chart_year == $row['esprit_year']) {
		print ' selected="selected"';
	}
	print ">".$row['esprit_year']."</option>\n";
}
mysql_logout();	//	Disconnect from database

print '		</select>
	</form>

</body>
</html>';

} else {

	/* This section compiles, formats and outputs the data required for the chart that's called above.*/
	
	define('QUADODO_IN_SYSTEM', true);
	$chart_year = $_REQUEST['chart_year'];
	mysql_login('Read-only');

	$sql = 'SELECT count(*) AS c, upper(state) AS p,
		CASE upper(state)
			WHEN "AB" THEN "01"
			WHEN "BC" THEN "02"
			WHEN "MB" THEN "03"
			WHEN "NB" THEN "04"
			WHEN "NL" THEN "05"
			WHEN "NS" THEN "07"
			WHEN "NU" THEN "14"
			WHEN "NT" THEN "13"
			WHEN "PE" THEN "09"
			WHEN "ON" THEN "08"
			WHEN "PQ" THEN "10"
			WHEN "QC" THEN "10"
			WHEN "SK" THEN "11"
			WHEN "YT" THEN "12"
			ELSE "00"
		END as pcode
	FROM regall
	WHERE reg_status NOT LIKE "%Cancelled%"
		AND reg_status != "DELETED"
			AND reg_status NOT LIKE "%cancelled%"
			AND country="Canada"
			AND esprit_year='.$chart_year.'
			AND form_type NOT IN ("Internal", "Ticket")
	GROUP BY state';

		$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);

	$count_shown = 0;
	$count_total = 0;
	// Get all the rows
	while ($row = mysqli_fetch_array($result)) {
		$data[] = $row;
		$count_shown++;
	}
	mysql_logout();	//	Disconnect from database


	$chart ="<chart
		caption=\"Canada Esprit $chart_year Registrations by Province\"
		theme=\"esprit\"
		exportenabled=\"1\"
		exportMode=\"client\"
		exportformats=\"PNG=Export as PNG Image|PDF=Export as Printable|JPG=Export as JPEG|XLS=Export Chart Data\"
		exporttargetwindow=\"_self\"
		exportfilename=\"Canada Reg $chart_year\">
		<annotations width=\"500\" height=\"300\" autoscale=\"1\">
			<annotationgroup id=\"user-images\">
				<annotation id=\"country-name\" type=\"text\" fillcolor=\"#000000\" fontsize=\"20\" text=\"Canada\" bold=\"1\"
				x=\"\$canvasEndX - 200\" y=\"\$canvasStartY + 150\" />
			</annotationgroup>
		</annotations>
		<colorrange minvalue=\"0\" startlabel=\"Low\" endlabel=\"High\" code=\"#FFFFFF\" gradient=\"1\">
			<color maxvalue=\"30\" code=\"#fbb4b9\" gradient=\"1\" />
			<color maxvalue=\"60\" code=\"#fbb4b9\" gradient=\"1\" />
			<color maxvalue=\"100\" code=\"#f768a1\" gradient=\"1\" />
			<color maxvalue=\"200\" code=\"#ae017e\" gradient=\"1\" />
		</colorrange>
	";

	for ($n = 0 ; $n < $count_shown ; $n++) {
		$chart .= "<set id=\"{$data[$n]['p']}\" value=\"{$data[$n]['c']}\" />\n";
	}
	$chart .="</chart>";
	print $chart;
}
?>