<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 10 January, 2013
		
	This configuration file provides the template options for SM_SQLEdit.
*/

/*	Protect from non-logged in users */

defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');
require_once('includes/mysql_utilities.php');
require_once('qls/includes/header.php');
$usergroup = $qls->group_id_to_name($qls->user_info['group_id']);

$tpl['regsystemversion'] = $regsystemversion;	// From config.php

$tpl['fileprefix'] = '';	// For use with multi-file applications
$tpl['appname'] = $_SESSION['appname'];

/*	Template parameters.
	All these get passed straight through to the Smarty template. They include
	style sheets, included templates, headings etc. File path is relative to
	the current directory.
*/

/* Stylesheets */

$tpl['stylesheetdir'] = $tpl['fileprefix'].'css/';
$tpl['stylesheet'][] = $tpl['stylesheetdir'].'styles.css';
$tpl['stylesheet'][] = $tpl['stylesheetdir'].'reports.css';
/*	Change following line for this system */
$tpl['stylesheet'][] = $tpl['stylesheetdir'].'mainall.css';

/* Custom stylesheet for jQuery UI elements. Uses symlink to ease updating */
$tpl['stylesheet'][] = $tpl['stylesheetdir']."esprit-theme/jquery-ui-css";

/*
	Include all required Javascript bits for jQuery and jEditable.
*/

require_once "../lib/jeditable_includes.php";

/*
	Letters
*/

/*	No letters for this subsystem
$r = array();
$tpl['letter_templates'] = get_mysql_letters($r);
//	print '<pre>';print_r($tpl['letter_templates']);print '</pre>';
*/

/*
	Reports
*/

$r = array('Array Edit', 'Presenters-History');
$tpl['table_reports'] = get_mysql_reports($r, $usergroup);
//	print '<pre>'; print_r($tpl['table_reports']); print '</pre>';

/*
	Other options
*/

global $opts;
$opts['debug'] = false;
$opts['sort_field'] = 'r.dt_datetime';
$opts['sort_order'] = 'DESC';
$opts['showdittos'] = 'true';
$opts['pagelimit'] = 100;	// override built-in limit of 20

/* Template header parameters. Edit to suit this system. */

$tpl['header']['title'] = "Esprit Database History - Presenters";
$tpl['header']['heading1'] = "<img src=\"/images/logo.gif\" width=\"250\" height=\"54\"> Esprit Database History - Presenters";
$tpl['header']['preamblefile'] = '../preamble.php';
$tpl['header']['year'] = $esprit_year;
$tpl['esprit_start'] =  strftime('%F %T', $date['esprit_start']);
$tpl['date'] = $date;
foreach ($date as $k => $d) {	// parse all dates into datetimes
	$tpl['datetime'][$k] = strftime('%F %T', $date[$k]);
}

$tpl['header']['menubar'] = '../menubar.tpl';

/* SM_SQLEdit template controls */

$tpl['detailtemplate'] = $tpl['fileprefix'].'detail.tpl';
$tpl['edittemplate'] = $tpl['fileprefix'].'edit.tpl';
$tpl['privileges']['canedit'] = true; // set to false to remove edit buttons
$tpl['navbar'] = $tpl['fileprefix'].'nav.tpl';
$tpl['pagecounts'] = array(10,20,30,50,100,500);	// extend pagecount limits
$tpl['recordlist'] = 'smse_recordlist.tpl';
$tpl['arrayedit'] = 'smse_arrayeditinplace.tpl';

/* Other URLS */

$tpl['badgephotourl'] = $GLOBALS['badgephotodir'];	// folder for badge photos
$tpl['pp_imageurl'] = '../pix/ppt/';		// folder for slide images
$tpl['desc_imageurl'] = '../pix/desc/';	// folder for writeup images
$tpl['pp_bgimageurl'] = '../pix/ppt/bg/';	// folder for slide backgrounds
$tpl['ticket_imageurl'] = '../pix/ticket/';	// folder for ticket images
$tpl['ticket_bgimageurl'] = '../pix/ticketbackgrounds/';	// folder for ticket backgrounds

?>