<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 19 March, 2023
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');
global $opts, $all_years;

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'mysql_utilities.php';

/* MySQL table names */
if ($all_years) {	//	All years
	$db['tb'] = 'regall r, regpresenterall s';
	$db['tbnoalias'] = 'regpresenterall';
	$db['alias'] = 's';		//	Need this for duplicating records. Only fields
							//	with a table spec matching this alias will be
							//	used in the get_mysql_fields() function.
} else {	//	Current year only
	$db['tb'] = 'reg r, regpresenter s';
	$db['tbnoalias'] = 'regpresenter';
	$db['alias'] = 's';		//	Need this for duplicating records. Only fields
							//	with a table spec matching this alias will be
							//	used in the get_mysql_fields() function.
}
$opts['join_clause'] = 'r.confirmation_no=s.confirmation_no';

/* Field definitions start here */

if ($all_years) {
	$fields['esprit_year'] = [
			'heading' => "Esprit Year",
			'table' => 's',
			'select' => true,
			'search_more' => true,
			'copyValue' => $GLOBALS['esprit_year'],
			'display' => true,
			'fieldgroup' => '*, Master',
			'filter' => ""];
} else {
	$fields['esprit_year'] = [
			'heading' => "Esprit Year",
			'table' => 's',
			'select' => true,
			'search_more' => true,
			'copyValue' => $GLOBALS['esprit_year'],
			'display' => true,
			'fieldgroup' => '*',
			'filter' => ""];
}
$fields['timestamp'] = [
		'heading' => "Time Stamp",
		'table' => 's',
		'helpfile' => 'help/timestamphelp.php',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'width' => '15%',
		'css' => 'font-size:80%',
		'fieldgroup' => 'Master, Presenter, Slide, Ticket, Preview, TicketPreview, Letters, PresenterRO',
		'filter' => ""];
$fields['updated'] = [
		'heading' => "Updated",
		'table' => 's',
		'display' => true,
		'search_more' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'width' => '10%',
		'css' => 'font-size:80%',
		'fieldgroup' => 'Master, Presenter, Slide, Ticket, Preview, TicketPreview, Letters, PresenterRO',
		'filter' => ""];
$fields['firstnamepref'] = [
		'heading' => "First Name",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Presenter, Slide, Ticket, Preview, TicketPreview, Letters, PresenterRO',
		'filter' => ""];
$fields['lastnamepref'] = [
		'heading' => "Last Name",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Presenter, Slide, Ticket, Preview, TicketPreview, Letters, PresenterRO',
		'filter' => ""];
$fields['firstname'] = [
		'heading' => "Business First Name",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, Ticket, Preview, TicketPreview, Letters, PresenterRO',
		'filter' => ""];
$fields['lastname'] = [
		'heading' => "Business Last Name",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, Ticket, Preview, TicketPreview, Letters, PresenterRO',
		'filter' => ""];
$presenter_list = get_presenter_list("conf");
$presenter_names = get_presenter_list("name");
$fields['confirmation_no'] = [
		'heading' => "Registration No.",
		'table' => 's',
		'fieldgroup' => 'Master, *',
		'display' => true,
		'width' => '10%',
		'allowedvalues' => $presenter_list,
		'allowedlabels' => $presenter_names,
		'arrayedit' => true,
		'widget' => 'menu',
		'filter' => ""];
$fields['bus_name'] = [
		'heading' => "Presentation Name",
		'fieldgroup' => 'Master, *',
		'table' => 's',
		'display' => true,
		'truncate_display' => 80,
//		'width' => '30%',
		'arrayedit' => true,
		'filter' => ""];
$fields['email'] = [
		'heading' => "Email",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Presenter, Slide, Ticket, Preview, TicketPreview, Letters, Copy',
		'filter' => ""];
$fields['address'] = [
		'heading' => "Address",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Preview, TicketPreview, Letters, PresenterRO',
		'filter' => ""];
$fields['city'] = [
		'heading' => "City",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Preview, TicketPreview, Letters, PresenterRO',
		'filter' => ""];
$fields['state'] = [
		'heading' => "State/Prov",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, PresenterRO',
		'arrayedit' => true,
		'filter' => ""];
$fields['zip'] = [
		'table' => 'r',
		'heading' => "Zip/Postal",
		'fieldgroup' => 'Presenter, Letters, PresenterRO',
		'filter' => ""];
$fields['country'] = [
		'heading' => "Country",
		'fieldgroup' => 'Presenter, Letters, PresenterRO',
		'table' => 'r',
		'filter' => ""];
$fields['phone'] = [
		'heading' => "Phone",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Presenter, Letters',
		'filter' => ""];
$fields['besttimetocall'] = [
		'heading' => "Time to Call",
		'table' => 'r',
		'search_more' => true,
		'fieldgroup' => 'Presenter',
//		'select' => true,
		'filter' => ""];
$fields['nametoaskfor'] = [
		'heading' => "Ask for",
		'table' => 'r',
		'search_more' => true,
		'fieldgroup' => 'Presenter',
//		'select' => true,
		'filter' => ""];
$fields['is_presenter'] = [
		'heading' => "Is a Presenter",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Preview, TicketPreview',
//		'arrayedit' => true,
		'allowedvalues' => [1, 0],
		'allowedlabels' => ['Yes', 'No'],
		'search_more' => true,
		'filter' => ""];
$venues = get_presenter_venues();
$fields['resourceroom'] = [
		'heading' => "Room Assigned",
		'table' => 's',
		'display' => true,
		'width' => '8%',
		'fieldgroup' => 'Master,Presenter, Slide, Ticket, AddNew, Preview, TicketPreview, Letters, PresenterRO',
 		'allowedvalues' => $venues,	//	Selected from regvenues table
		'allowedlabels' => $venues,	//	Selected from regvenues table
		'arrayedit' => true,
		'widget' => 'menu',
		'filter' => ""];
$fields['resourcedate'] = [
		'heading' => "Date Scheduled",
		'table' => 's',
		'display' => true,
		'width' => '15%',
		'fieldgroup' => 'Master, *',
		'arrayedit' => true,
		'widget' => 'datetimepicker',
		'type' => 'date',
		'date_format' => '%a %d%b%Y %T',
		'css' => 'font-size:80%',
		'filter' => ""];
$fields['resourcealsoadmit'] = [
		'heading' => "Also Admit on",
		'table' => 's',
		'display' => true,
		'width' => '15%',
		'fieldgroup' => 'Master, *',
		'arrayedit' => true,
		'widget' => 'datetimepicker',
		'type' => 'date',
		'date_format' => '%a%d%b %Y',
		'css' => 'font-size:80%',
		'filter' => ""];
$fields['resourceduration'] = [
		'heading' => "Duration",
		'table' => 's',
		'display' => true,
		'fieldgroup' => 'Presenter, Slide, Ticket, AddNew, Preview, TicketPreview, Letters, PresenterRO',
		'allowedvalues' => ['', '30', '60', '75', '90', '120', '180', '240',
			'300', '360', '420', '480', '540', '600', '660', '720'],
		'allowedlabels' => ['none', '30 min.', '1 hr', '1 hr 15 min', '1.5 hr', '2 hr',
			'3 hr', '4 hr', '5 hr', '6 hr', '7 hr', '8 hr', '9 hr', '10 hr', '11 hr', '12 hr'],
		'arrayedit' => true,
		'widget' => 'menu',
		'filter' => ""];
$fields['resourcesetuptime'] = [
		'heading' => "Setup Time",
		'table' => 's',
		'display' => true,
		'fieldgroup' => 'Presenter, Slide, Ticket, AddNew, Preview, TicketPreview, Letters, PresenterRO',
		'allowedvalues' => ['', '30', '60', '75', '90', '120', '180', '240',
			'300', '360', '420', '480', '540', '600', '660', '720'],
		'allowedlabels' => ['none', '30 min.', '1 hr', '1 hr 15 min', '1.5 hr', '2 hr',
			'3 hr', '4 hr', '5 hr', '6 hr', '7 hr', '8 hr', '9 hr', '10 hr', '11 hr', '12 hr'],
		'arrayedit' => true,
		'widget' => 'menu',
		'filter' => ""];
$fields['resourceteardowntime'] = [
		'heading' => "Teardown Time",
		'table' => 's',
		'display' => true,
		'fieldgroup' => 'Presenter, Slide, Ticket, AddNew, Preview, TicketPreview, Letters, PresenterRO',
		'allowedvalues' => ['', '30', '60', '75', '90', '120', '180', '240',
			'300', '360', '420', '480', '540', '600', '660', '720'],
		'allowedlabels' => ['none', '30 min.', '1 hr', '1 hr 15 min', '1.5 hr', '2 hr',
			'3 hr', '4 hr', '5 hr', '6 hr', '7 hr', '8 hr', '9 hr', '10 hr', '11 hr', '12 hr'],
		'arrayedit' => true,
		'widget' => 'menu',
		'filter' => ""];
$fields['resourcestatus'] = [
		'heading' => "Status",
		'table' => 's',
		'display' => true,
		'width' => '10%',
		'fieldgroup' => 'Master, Presenter, Slide, Ticket, AddNew, Preview, TicketPreview, Letters, PresenterRO',
		'arrayedit' => true,
		'widget' => 'menu',
		'search_more' => true,
		'allowedvalues' => ['', 'Inquiry', 'Approved', 'Scheduled',
			'Co-Presenter', 'Suspended', 'Cancelled'],
		'allowedlabels' => ['None', 'Inquiry', 'Approved', 'Scheduled',
			'Co-Presenter', 'Suspended', 'Cancelled'],
		'copyValue' => 'Inquiry',
		'filter' => ""];
$resource_formats = get_resource_formats();
$fields['resourceformat'] = [
		'heading' => "Format",
		'table' => 's',
		'display' => true,
		'fieldgroup' => 'Presenter, Slide, Ticket, AddNew, Preview, TicketPreview, Letters, PresenterRO',
		'arrayedit' => true,
		'widget' => 'menu',
		'search_more' => true,
		'allowedvalues' => $resource_formats,
		'allowedlabels' => $resource_formats,
		'filter' => ""];
// $fields['firstesprit'] = [
// 		'heading' => "First Esprit",
// 		'table' => 'r',
//		'fieldgroup' => 'Presenter',
// 		'search_more' => true,
// 		'filter' => ""];
$fields['reg_status'] = [
		'heading' => "Registration Status",
		'table' => 'r',
//		'display' => true,
		'fieldgroup' => 'Presenter, Preview, TicketPreview, Letters',
		'allowedvalues' => ['Pre-registered', 'Paid', 'Checked In',
			'Participant Cancelled', 'Esprit Cancelled', 'Blocked',
			'Checked Out'],
		'helpfile' => 'help/regstatushelp.php',
		'search_more' => true,
		'filter' => ""];
$fields['daysun1'] = [
		'heading' => "Sunday (start)",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['daymon'] = [
		'heading' => "Monday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['daytue'] = [
		'heading' => "Tuesday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['daywed'] = [
		'heading' => "Wednesday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['daythu'] = [
		'heading' => "Thursday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['dayfri'] = [
		'heading' => "Friday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['daysat'] = [
		'heading' => "Saturday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['daysun2'] = [
		'heading' => "Sunday (end)",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['meal1'] = [
		'heading' => "Meal 1",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter',
		'search_more' => true,
		'filter' => ""];
$fields['meal2'] = [
		'heading' => "Meal 2",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter',
		'search_more' => true,
		'filter' => ""];
$fields['meal3'] = [
		'heading' => "Meal 3",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter',
		'search_more' => true,
		'filter' => ""];
$fields['meal4'] = [
		'heading' => "Meal4",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter',
		'search_more' => true,
		'filter' => ""];
$fields['meal5'] = [
		'heading' => "Meal 5",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter',
		'search_more' => true,
		'filter' => ""];
$fields['meal6'] = [
		'heading' => "Meal 6",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter',
		'search_more' => true,
		'filter' => ""];
$fields['form_type'] = [
		'heading' => "Form Type",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Master, Presenter',
		'width' => '8%',
		'helpfile' => 'help/formtypehelp.php',
		'search_more' => true,
		'filter' => ""];
$fields['notes'] = [
		'heading' => "Notes",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide',
		'search_more' => true,
		'filter' => ""];
$fields['bus_desc'] = [
		'heading' => "Business Description",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, Slide, Ticket, AddNew, PresenterRO',
		'search_more' => true,
		'css' => 'max-height: 100; overflow: auto',
		'filter' => ""];
$fields['resourcebio'] = [
		'heading' => "Biography",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, Slide, Ticket, AddNew',
		'search_more' => true,
		'filter' => ""];
$fields['flyer'] = [
		'heading' => "Flyer/Coupon",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, Ticket, AddNew',
		'search_more' => true,
		'filter' => ""];

/* AV requirements for presentations */

$fields['seating'] = [
		'heading' => "Seating Arrangement",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, AddNew, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['avproj'] = [
		'heading' => "Computer Projector",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, AddNew, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['avslideproj'] = [
		'heading' => "Slide Projector",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, AddNew, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['avscreen'] = [
		'heading' => "Screen",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, AddNew, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['avcd'] = [
		'heading' => "CD Player",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, AddNew, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['avdvd'] = [
		'heading' => "DVD Player",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, AddNew, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['avvcr'] = [
		'heading' => "VCR Player",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, AddNew, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['avoverhead'] = [
		'heading' => "Overhead Projector",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, AddNew, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['avmic'] = [
		'heading' => "Microphone",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, AddNew, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['avpodium'] = [
		'heading' => "Podium",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, AddNew, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['avmonitor'] = [
		'heading' => "TV Monitor",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, AddNew, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['avpiano'] = [
		'heading' => "Piano",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, AddNew, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['resourcenotes'] = [
		'heading' => "Notes",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, Slide, Ticket, AddNew, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['flyer'] = [
		'heading' => "Flyer/Coupon",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, AddNew',
		'search_more' => true,
		'filter' => ""];
$fields['specialrequests'] = [
		'heading' => "Special Requests",
		'table' => 's',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];

/* End of special setup requirements */

/*	Fields for Slide generation */

$fields['slide_notes'] = [
		'heading' => "Slide Notes",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, AddNew, Preview',
		'search_more' => true,
		'filter' => ""];
$fields['slide_startdisplay'] = [
		'heading' => "Start Slide Display",
		'table' => 's',
		'display' => true,
		'width' => '10%',
		'fieldgroup' => 'Presenter, Slide, AddNew, Preview',
		'arrayedit' => true,
		'select' => true,
		'widget' => 'datetimepicker',
		'type' => 'date',
		'date_format' => 'm/d/Y H:i:s',
		'search_more' => true,
		'filter' => ""];
$fields['slide_image'] = [
		'heading' => "Slide Image",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, AddNew, Preview',
		'search_more' => true,
		'filter' => ""];
$fields['slide_bgimage'] = [
		'heading' => "Slide Background Image",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, AddNew, Preview',
		'search_more' => true,
		'filter' => ""];
$fields['slide_font'] = [
		'heading' => "Slide Font",
		'table' => 's',
		'select' => true,
		'allowedvalues' => get_slide_font_list(),
		'fieldgroup' => 'Presenter, Slide, AddNew, Preview',
		'search_more' => true,
		'filter' => ""];
$fields['slide_title_font_size'] = [
		'heading' => 'Title Font Size',
		'table' => 's',
		'select' => true,
		'allowedvalues' => ['',
			'60',
			'72',
			'84',
			'96',
			'120',
			'144'
		],
		'fieldgroup' => 'Presenter, Slide, AddNew, Preview',
		'search_more' => true,
		'filter' => ""];
$fields['slide_textcolour'] = [
		'heading' => "Slide Text Colour",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Slide, AddNew, Preview',
		'search_more' => true,
		'filter' => ""];
$fields['slide_format'] = [
		'heading' => "Slide Format",
		'table' => 's',
		'select' => true,
		'allowedvalues' => get_slide_styles("{$_SERVER['DOCUMENT_ROOT']}/css/slide_styles"),
		'fieldgroup' => 'Presenter, Slide, AddNew, Preview',
		'search_more' => true,
		'filter' => ""];
/*	End of Slide fields */

/*	Fields for Ticket generation */

$fields['ticket_image'] = [
		'heading' => "Ticket Image",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Ticket, AddNew, TicketPreview',
		'search_more' => true,
		'filter' => ""];
$fields['ticket_bgimage'] = [
		'heading' => "Ticket Background Image",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Ticket, AddNew, TicketPreview',
		'search_more' => true,
		'filter' => ""];
$fields['ticket_font'] = [
		'heading' => "Ticket Font",
		'table' => 's',
		'select' => true,
		'allowedvalues' => get_slide_font_list(),
		'fieldgroup' => 'Presenter, Ticket, AddNew, TicketPreview',
		'search_more' => true,
		'filter' => ""];
$fields['ticket_title_font_size'] = [
		'heading' => 'Title Font Size',
		'table' => 's',
		'select' => true,
		'allowedvalues' => ['',
			'16',
			'18',
			'24',
			'36',
			'60',
			'72'
		],
		'fieldgroup' => 'Presenter, Ticket, AddNew, TicketPreview',
		'search_more' => true,
		'filter' => ""];
$fields['ticket_textcolour'] = [
		'heading' => "ticket Text Colour",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Ticket, AddNew, TicketPreview',
		'search_more' => true,
		'filter' => ""];
$fields['ticket_format'] = [
		'heading' => "Ticket Format",
		'table' => 's',
		'select' => true,
		'allowedvalues' => get_slide_styles("{$_SERVER['DOCUMENT_ROOT']}/css/ticket_styles"),
		'fieldgroup' => 'Presenter, Ticket, AddNew, TicketPreview',
		'search_more' => true,
		'filter' => ""];

/*	End of Ticket fields */

/*	Other fields */

$fields['specialrequests'] = [
		'heading' => "Special Requests",
		'table' => 's',
		'select' => true,
		'fieldgroup' => 'Presenter, Letters, Slide, Ticket, AddNew, PresenterRO',
		'search_more' => true,
		'filter' => ""];
$fields['reg_count'] = [
		'heading' => "Attendance",
		'table' => 's',
		'select' => true,
		'search_more' => true,
		'copyValue' => 0,
		'display' => false,
		'fieldgroup' => 'Presenter, AddNew',
		'filter' => ""];
$fields['attendees'] = [
		'heading' => "Attendees",
		'table' => 's',
		'fieldgroup' => '*, Presenter, AddNew',
		'search_more' => true,
		'copyValue' => '',
		'filter' => ""];
$fields['id'] = [
		'heading' => "Record ID",
		'table' => 's',
		'primarykey' => true,
		'width' => '5%',
		'fieldgroup' => '*, Master, AddNew',
		'search_more' => true,
		'filter' => ""];

/* End of Field definitions. */

/*	Field group definitions */

if (!$all_years) {	//	Current year
	$tpl['fieldgroups'] = [
		'Master' => ['label'=>'Master',
			'url' =>''],
		'Presenter' => ['label' => 'Presentation',
			'url' => 'taburl.php?template=presenter_detail.tpl',
			'width' => 1000,	// Override default window width
			'height' => 800,
			'authgroup' => ['Registrar', 'Desk', 'Presenter', 'Admin']],
		'PresenterRO' => ['label' => 'Presentation',
			'url' => 'taburl.php?template=presenter_detail.tpl&access=read_only',
			'authgroup' => ['Hotel']],
/*	Disabled slide code */
/*		'Slide' => ['label' => 'Slide',
			'url' => 'taburl.php?template=presenter_slide_detail.tpl',
			'authgroup' => ['Admin', 'Presenter']],
		'Preview' => ['label' => 'Slide Preview',
			'url' => 'taburl.php?template=presenter_slide_preview.tpl',
			'width' => 1920,	// Override default width
			'height' => 1200,	// and height to 1080p size
			'authgroup' => ['Admin', 'Presenter']],
*/
	/*
		Ticket tabs are disabled as we don't have any ticketed items at the moment.
	*/
// 		'Ticket' => ['label' => 'Ticket',
// 			'url' => 'taburl.php?template=presenter_ticket_detail.tpl',
// 			'authgroup' => ['Admin', 'Presenter']],
// 		'TicketPreview' => ['label' => 'Ticket Preview',
// 			'url' => 'taburl.php?template=presenter_ticket_preview.tpl',
// 			'authgroup' => ['Admin', 'Presenter']],
	/*
		QR tab is disabled until there's a standard way to encode
		date and event information in QR codes.
	*/
	// 		'QR' => ['label' => 'QR Codes',
	// 		'url' =>'presenter_qr_url.php',
	// 		'authgroup' => ['Registrar', 'Desk', 'Presenter', 'Admin']],
		'Letters' => ['label' => 'Letters',
			'url' =>'../letterssendmailtaburl.php?appname=presenters',
			'width' => 1000,
			'height' => 800,
			'authgroup' => ['Registrar', 'Admin', 'Presenter']],
		'Logs' => ['label' => 'Log Entries',
			'url' => "../log-list.php?tbname={$db['tbnoalias']}",
			'width' => 1500,
			'height' => 800,
			'authgroup' => ['Admin']],
		'All' => ['label' => 'All Fields',
			'url' => "../allfieldsurl.php?dirname=presenters&editable={$db['alias']}",
			'authgroup' => ['Admin']],
		'AddNew' => ['label' => 'Copy - CAUTION',
			'url' => 'add.php?group=AddNew',
			'authgroup' => ['Registrar', 'Presenter', 'Admin'],
			'scroll' => 'No'	//	Prevent scrolling to this screen
			],
		'Delete' => ['label' => 'Delete',
			'url' => 'delete.php?group=AddNew',
			'authgroup' => ['Registrar', 'Presenter', 'Admin'],
			'scroll' => 'No'	//	Prevent scrolling to this screen
			]
	];
} else {	//	All years
	$tpl['fieldgroups'] = [
		'Master' => ['label'=>'Master',
			'url' =>''],
		'Presenter' => ['label' => 'Presentation',
			'url' => 'taburl.php?template=presenter_detail.tpl&access=read_only&all_years=true',
			'width' => 1000,	// Override default window width
			'authgroup' => ['Registrar', 'Desk', 'Presenter', 'Vendor', 'Admin']],
		'Slide' => ['label' => 'Slide',
			'url' => 'taburl.php?template=presenter_slide_detail.tpl&access=read_only&all_years=true',
			'authgroup' => ['Admin', 'Presenter']],
		'Preview' => ['label' => 'Slide Preview',
			'url' => 'taburl.php?template=presenter_slide_preview.tpl&access=read_only&all_years=true',
			'width' => 1080,	// Override default width
			'height' => 720,	// and height to 1080p size
			'authgroup' => ['Admin', 'Presenter']],

	/*
		Ticket tabs are disabled as we don't have any ticketed items at the moment.
	*/
// 		'Ticket' => ['label' => 'Ticket',
// 			'url' => 'taburl.php?template=ticket.tpl&access=read_only&all_years=true',
// 			'authgroup' => ['Admin', 'Presenter']],
// 		'TicketPreview' => ['label' => 'Ticket Preview',
// 			'url' => 'taburl.php?template=ticket_preview.tpl&access=read_only&all_years=true',
// 			'authgroup' => ['Admin', 'Presenter']],
		'Letters' => ['label' => 'Letters',
			'url' =>'../letterssendmailtaburl.php?appname=presentersall',
			'width' => 1000,
			'height' => 800,
			'authgroup' => ['Registrar', 'Admin','Presenter']],
		'Logs' => ['label' => 'Log Entries',
			'url' => "../log-list.php?tbname={$db['tbnoalias']}",
			'width' => 1500,
			'height' => 800,
			'authgroup' => ['Admin']],
		'All' => ['label' => 'All Fields',
			'url' => "../allfieldsurl.php?dirname=presentersall",
			'authgroup' => ['Admin']],
		'Copy' => ['label' => 'Copy to Current Year',
			'url' => 'copy_to_current.php?all_years=true',
			'authgroup' => ['Registrar', 'Admin', 'Presenter']]
	];
}

function get_presenter_list($type) {
	/*
		Get list of registered presenters for use in the Relink button. 
		Parameter $type is:
		"name"	return names
		"conf"	return confirmation numbers
		"select"	return string for use in <select> clause of <input>
	*/
	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	require_once "mysql_utilities.php";
	global $tpl;
	mysql_login('Normal');
	$sql = 'SELECT firstnamepref,lastnamepref,confirmation_no
	FROM reg
	WHERE is_presenter="Yes"
		AND reg_status NOT LIKE "%cancel%"
	ORDER BY lastnamepref';
	$sql_result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error getting presenter list: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to retrieve list of presenter names - sorry!');
	$r = [];
	while ($row = mysqli_fetch_assoc($sql_result)) {
		switch ($type) {
		case 'name':
			$r[] = "{$row['firstnamepref']} {$row['lastnamepref']}";
			break;
		case 'conf':
			$r[] = $row['confirmation_no'];
			break;
		case 'both':
			$r[] = "{$row['firstnamepref']} {$row['lastnamepref']} {$row['confirmation_no']}";
		}
	}
	return $r;
}

function get_presenter_venues() {
	/*	Get list of venues from the regvenues table. Presentations can happen even in
		vendors' rooms so no distinction is made, as it is in vendor rooms.
		
		Check for online Esprit instead of in-person, restrict offerings
	*/
	include_once "online_switch.php";

	global $tpl;
	$temp_access = $tpl['access'];
	mysql_login('Normal');
	$tpl['access'] = $temp_access;
	$sql = 'SELECT DISTINCT venue_long
	FROM regvenues
	WHERE ' . (ONLINE_ESPRIT ? 'venue_type = "Online"' : 'venue_type LIKE "%venue"');
//	print $sql;
	$sql_result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error getting venue table: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to retrieve venue names for presenters - sorry!');
	$r = [];
	while ($row = mysqli_fetch_assoc($sql_result)) {
		$r[] = $row['venue_long'];
	}
	return $r;
}

function get_slide_styles($dir) {
	$files = scandir($dir);
	if (!$files) {		//	Directory exists?
		$result[] = "No styles directory $dir";
		return $result;
	}
	natcasesort($files);
	foreach ($files as $f) {
		if (strtolower(strrchr($f, '.')) == '.css') {
			$result[] = $f;		//	Ignore anything not css
		}
	}
	if (!isset($result)) {	//	Any contents?
		$result[] = "Empty styles directory $dir";
	}
	return $result;
}

function get_resource_formats() {
	return ['', 'Class', 'Workshop', 'Event', 'External Event', 'Ticketed',
			'Excursion', 'Service', 'Private'];
}

function get_slide_font_list() {
	return ['',
			'Aguafina',
			'Airstream',
			'Arizonia',
			'Bubblegum',
			'Calligraphica',
			'Calligraphica2Rg',
			'CalligraphicaLight',
			'CevicheOne',
			'Champagne',
			'ChampagneSmall',
			'ChunkFive',
			'Coda',
			'DancingScript',
			'GreatVibes',
			'HennyPenny',
			'JungleFever',
			'KaushanScript',
			'Kitchenpolice',
			'Limelight',
			'Lobster13',
			'Mothproof',
			'PleasantlyPlump',
			'PoetsenOne',
			'PorterSans',
			'Qumpellkano',
			'Redressed',
			'SeasideResort',
			'SofaDione',
			'Titan_One',
			'Tradewinds',
			'TwentyDb',
			'Vanilla',
			'Wideawake',
			'WideawakeBlack',
			'Windsong',
			'Slideonly'
		];
}
?>
