<?php
/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:	modifier.tz.php
 * Type:	modifier
 * Name:	tz
 * Purpose:	Converts a UTC timestamp to a MySQL 14-digit timestamp
 *			(yyyymmddhhmmss) with the timezone adjusted as specified,
 *			ready to pass to date_format
 * -------------------------------------------------------------
 */
function smarty_modifier_tz($time, $timezone) {
	$changetime = new DateTime("@$time", new DateTimeZone('UTC'));
	$changetime->setTimezone(new DateTimeZone($timezone));
	return $changetime->format('YmdHis');
} 
?>