<?php
/*
Smarty plugin
-------------------------------------------------------------
File:		function.num2text.php
Author:		Stephanie Mitchell
Date:		19 November, 2012
Type:		function
Name:		num2text
Purpose:	converts a numeric value to words; for example,
			"423" returns "four hundred and twenty-three".
Modifications: mods to Brenton's original code to:
			- not require a decimal point in the num parameter;
			- support a currency parameter to output dollars
			and cents
			- also handles $1, $1.45 with proper singular form
Parameters:	num			the number to be converted.
			currency	true to produce output as dollars and cents
						false or omitted - straight word output
*/

function smarty_function_num2text($params, $template) {
$num=$params['num'];
$currency = $params['currency']; // true to show as dollars and cents
if (!function_exists('convertGroup')) {
	function convertGroup($index) {
		switch($index) {
			case 11: return " decillion";
			case 10: return " nonillion";
			case 9: return " octillion";
			case 8: return " septillion";
			case 7: return " sextillion";
			case 6: return " quintrillion";
			case 5: return " quadrillion";
			case 4: return " trillion";
			case 3: return " billion";
			case 2: return " million";
			case 1: return " thousand";
			case 0: return "";
		}
	}
}

if (!function_exists('convertThreeDigit')) {
	function convertThreeDigit($dig1, $dig2, $dig3) {
		$output = "";
	
		if($dig1 == "0" && $dig2 == "0" && $dig3 == "0") return "";
	
		if($dig1 != "0") {
			$output .= convertDigit($dig1)." hundred";
			if($dig2 != "0" || $dig3 != "0") $output .= " and ";
		}
	
		if($dig2 != "0") $output .= convertTwoDigit($dig2, $dig3);
		else if($dig3 != "0") $output .= convertDigit($dig3);
	
		return $output;
	}
}

if (!function_exists('convertTwoDigit')) {
	function convertTwoDigit($dig1, $dig2) {
		if($dig2 == "0") {
			switch($dig1) {
				case "1": return "ten";
				case "2": return "twenty";
				case "3": return "thirty";
				case "4": return "forty";
				case "5": return "fifty";
				case "6": return "sixty";
				case "7": return "seventy";
				case "8": return "eighty";
				case "9": return "ninety";
			}
		}
		else if($dig1 == "1") {
			switch($dig2) {
				case "1": return "eleven";
				case "2": return "twelve";
				case "3": return "thirteen";
				case "4": return "fourteen";
				case "5": return "fifteen";
				case "6": return "sixteen";
				case "7": return "seventeen";
				case "8": return "eighteen";
				case "9": return "nineteen";
			}
		} else {
			$temp = convertDigit($dig2);
			switch($dig1) {
				case "2": return "twenty-$temp";
				case "3": return "thirty-$temp";
				case "4": return "forty-$temp";
				case "5": return "fifty-$temp";
				case "6": return "sixty-$temp";
				case "7": return "seventy-$temp";
				case "8": return "eighty-$temp";
				case "9": return "ninety-$temp";
			}
		}
	}
}

if (!function_exists('convertCents')) {
	function convertCents($dig1, $dig2) {	// need this because
							// convrtTwoDigit can't handle cent
							// portions under 10.
		if ($dig1== "0") {
			return convertDigit($dig2);
		} else {
			return convertTwoDigit($dig1, $dig2);
		}
	}
}

if (!function_exists('convertDigit')) {
	function convertDigit($digit) {
		switch($digit) {
			case "0": return "zero";
			case "1": return "one";
			case "2": return "two";
			case "3": return "three";
			case "4": return "four";
			case "5": return "five";
			case "6": return "six";
			case "7": return "seven";
			case "8": return "eight";
			case "9": return "nine";
		}
	}
}

if (strpos($num, '.')) $num .='.';

list($num, $dec) = explode(".", $num);

$output = "";

if($num{0} == "-") {
	$output = "negative ";
	$num = ltrim($num, "-");
}
else if($num{0} == "+") {
	$output = "positive ";
	$num = ltrim($num, "+");
}

if($num{0} == "0") {
	$output .= "zero";
} else {
	$num = str_pad($num, 36, "0", STR_PAD_LEFT);
	$group = rtrim(chunk_split($num, 3, " "), " ");
	$groups = explode(" ", $group);
	
	$groups2 = array();
	foreach($groups as $g) $groups2[] = convertThreeDigit($g{0}, $g{1}, $g{2});
	
	for($z = 0; $z < count($groups2); $z++) {
		if($groups2[$z] != "") {
			$output .= $groups2[$z].convertGroup(11 - $z).($z < 11 && !array_search('', array_slice($groups2, $z + 1, -1))
			&& $groups2[11] != '' && $groups[11]{0} == '0' ? " and " : ", ");
		}
	}
	
	$output = rtrim($output, ", ");
}


if ($currency == true) {
	if ($dec == 0) {
		$output .= ($num ==1) ? ' dollar' : ' dollars';
	} else {
		$output .= ($num ==1) ? ' dollar and ' : ' dollars and ';
		$output .= convertCents($dec{0}, $dec{1});
		$output .= ' cents';
	}
} else if($dec > 0) {
		$output .= " point";
		for($i = 0; $i < strlen($dec); $i++) $output .= " ".convertDigit($dec{$i});
		
	}

	
	return $output;
}

?>