<?php
/*
	Create or destroy a lockfile for the registration system. The lock is set in order to
	disable the system, e.g. for maintenance activities.
	If /manager/lockfile.lock is present, the public-facing reg system will quit with a message. If it's missing, system will operate normally.
	
	This file posts a form for creating and destroying the lockfile.
*/
?>
<html>
<head>
<title>Esprit Registration Lock Manager</title>
<style>
body {
	font-family:Helvetica, Arial, Swiss, sans-serif;
}
.locked {
	background-color: #FF0000;
	color:white;
}
.locked h1, .locked h2,.locked h3 {
	color: yellow;
}
.unlocked {
	background-color: #AAFFAA;
	color: black;
}
.unlocked h1, .unlocked h2, .unlocked h3 {
	color: black;
}
</style>
</head>
<?php
$lname = "{$_SERVER['DOCUMENT_ROOT']}/lockfile.lock";
$locked = file_exists($lname);
$class = $locked ? "locked" : "unlocked";
print "<body class=\"$class\">";
print "<h2>Online Registration Maintenance Lockout Switch</h2>";
if ($locked) {
	print '<h3>Locked out in maintenance mode!</h3>';
} else {
	print '<h3>Unlocked - in production mode!</h3>';
}
if (isset($_REQUEST['lock'])) {
	switch ($_REQUEST['lock']) {
	case 'lock': 
		if ($locked) {
			print 'ALREADY locked!<br />';
		} else {
			print 'Locking...<br/>';
			$handle = fopen($lname, 'w') or die("Cannot create lockfile: $lname");
		}
		break;
	
	case 'unlock':
		if (!$locked) {
			print 'ALREADY unlocked!<br />';
		} else {
			print 'Unlocking...<br />';
			$handle = @unlink($lname) or die("Cannot destroy lockfile: $lname");
		}
		break;

	default:
		die('Invalid lock command');
	}
}
if (file_exists($lname)) {
	print '<h3 style="color:red">Now locked out in maintenance mode!</h3>';
} else {
	print '<h3 style="color:green">Now unlocked - in production mode!</h3>';
}
print '<form method="POST" name="lockform" action="lock.php">
<input type="radio" name="lock" value="lock" onClick="this.form.submit()">Lock</input>
<input type="radio" name="lock" value="unlock" onClick="this.form.submit()">Unlock</input>
</form>';
?>
</body>
</html>
	