<?php
/*
	Sets up and displays the "Copy to Current" tab for the Mealtypes
	susbystem. Only appears if all_years is set to true.
	
	Stephanie Mitchell, 4 April, 2023
*/
/*
	See if logged in via Quadodo
*/

global $tpl;
define('QUADODO_IN_SYSTEM', true);
$dirname = dirname(__FILE__);
$basename = dirname($dirname);

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once "mysql_utilities.php";
require_once "header.php";
require_once ".config.php";
require_once "setup.php";
require_once "fieldlist.php";
require_once "template_options.php";
$tpl['authgroup'] = $qls->group_id_to_name($qls->user_info['group_id']);
$tpl['username'] = $qls->user_info['username'];
if ($tpl['username'] == '') {
	header('Location: ../qls/login.php');
	exit;
}

$primarykeyfieldvalue = $_REQUEST['pkfv'];
$primarykeyfieldname = $_REQUEST['pkfn'];
$all_years = $_REQUEST['all_years'] ?? '';
mysql_login('Normal');
$mydata = get_mysql_fields('Copy', $fields, $primarykeyfieldname, $primarykeyfieldvalue, 'regmealtypesall m', $all_years);

/*	Force a distinctive first name to identify the new record and tweak certain
	fields to current year, pre-registered and such. Also set remaining meals to allotted meals. */

$mydata['mt_long'] .= ' (NEW)';
$mydata['mt_year'] = $esprit_year;
unset($mydata['mt_created']);	//	MySQL inserts this automatically
unset($mydata['mt_updated']);	//	MySQL inserts this automatically

// insert the new record and get the new auto_increment id
$sql = "INSERT INTO regmealtypesall (`{$primarykeyfieldname}`) VALUES (NULL)";
$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on insert while copying mealtype to current year: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to insert new record while copying mealtype to current year - sorry!');

$newid = mysqli_insert_id($GLOBALS['dbConnect']);
$mydata[$primarykeyfieldname] = $newid;

/*
	Generate the query to update the new record with the previous values.
*/

$sql = "UPDATE regmealtypesall SET ";
foreach ($mydata as $key => $value) {
	if ($key != $primarykeyfieldname) {
		if (isset($fields[$key]['copyValue'])) {
			$sql .= '`'.$key.'` = "'.str_replace('"','\"',$fields[$key]['copyValue']).'", ';
		} else {
			$sql .= '`'.$key.'` = "'.str_replace('"','\"',$value).'", ';
		}
	}
} 

$sql = rtrim($sql, ', '); // lop off extra trailing comma
$sql .= " WHERE {$primarykeyfieldname}={$newid}";
$sql_escaped = $sql; // mysqli_real_escape_string($GLOBALS['dbConnect'], $sql);
$result = mysqli_query($GLOBALS['dbConnect'], $sql_escaped) or SM_Die('Database error on update while copying mealtype to current year: ' . mysqli_error($GLOBALS['dbConnect']) . ". Query=$sql_escaped", 'Unable to update information while copying mealtype to current year - sorry!');


Make_Log_Entry($GLOBALS['dbConnect'], "NEW MEALTYPE ADDED VIA COPY TO CURRENT: $sql_escaped");
mysql_logout();	//	Disconnect from database

$e = new Smarty_Esprit;
$e->addPluginsDir("{$_SERVER['DOCUMENT_ROOT']}/plugins/");
$e->registerPlugin("modifier","ss", "stripslashes");
$e->assign('mydata',$mydata);
// print_r($tpl);
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/templates/");
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/$dirname/templates/");
$e->display('mealtype_detail.tpl');

?>
