<?php
/*	Snippet for generating confirmation numbers. A confirmation number is an
	8-digit number like yymmrrrr, where yy is the last two digits of the Esprit
	year, mm is the month in which this registration came in (regardless of
	year) and rrrr is a 4-digit random number. The resulting number is looked up
	in the reg database to make sure it's unique. If not, another rrrr is generated.
    
    Stephanie Mitchell, 1 July, 2011
*/

function generate_confirmation() {
	global $esprit_year;

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";

	require_once ".regconnect.php"; // hostname, ID and password
	require_once "mysql_utilities.php";
	mysql_login('Read-only');
	$yy = substr($esprit_year, 2, 2);
	$mm = date('m');
	$dup = true;
	while ($dup) {	// repeat until $dup is false, i.e. we don't have a duplicate
		$rand = rand(0, 9999);
		$test = $rand + $mm * 10000 + $yy * 1000000;
//		print "$mm\n";
		$sqlcmd = "SELECT confirmation_no
		FROM regall
		WHERE confirmation_no = $test
			AND confirmation_no IS NOT NULL";
		$dup = (@mysqli_num_rows(@mysqli_query($GLOBALS['dbConnect'], $sqlcmd)) > 0);
	}
// 	print '<br /><br />' . __FUNCTION__ . ": generated $test</br />";
	return $test;
}

/*	Snippet for generating badge codes. A badge code is a 14-byte random string
	that is unique in the entire regall table. It's used in the URL in the QR
	code on the badges. A new code is generated if a badge is reprinted after it
	has been lost or stolen. Generating a new code thus invalidates the old one.
	The resulting number is looked up in the regall table to make sure it's
	unique. If not, another bbbbbbbbbbbbbb is generated.
    
    Stephanie Mitchell, 2 June, 2017
*/

function generate_badge_code() {
	global $esprit_year;
	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";

	require_once ".regconnect.php"; // hostname, ID and password
	require_once "mysql_utilities.php";
//	require_once "{$_SERVER['DOCUMENT_ROOT']}/../manager/random_compat/lib/random.php";
	mysql_login('Read-only');
	$dup = true;
	while ($dup) {	// repeat until $dup is false, i.e. we don't have a duplicate
		$rand = bin2hex(random_bytes(14));
//		print "$mm\n";
		$sqlcmd = "SELECT badge_code
		FROM regall
		WHERE badge_code = '$rand'
			AND badge_code IS NOT NULL";
		$dup = (@mysqli_num_rows(@mysqli_query($GLOBALS['dbConnect'], $sqlcmd)) > 0);
	}
// 	print '<br /><br />' . __FUNCTION__ . ": generated $test</br />";
	return $rand;
}

function generate_password($num) {
	return password_hash($num, PASSWORD_BCRYPT);
 }
?>