	/*
		Field parameters for fieldlist.php
		Stephanie Mitchell, 22 January 2023
		
	Each field in a fieldist.php file is an element in the $fields array. Each
	field is itself an array, with the following possible elements:
	
	<key>		the index in the fields array is the name of the database field; for
				example, $fields['firstname'] describes a field named 'firstname'.
	heading		human-readable name for the field, can be used in reports,
				navigation elements etc.
	long_heading	longer form of heading, usully more descriptive, for use in detail
					screens
	labelhelp	explanatory text displayable on detail screens, e.g. in a tooltip
	table		database table or alias name. If an alias is given in
				$db['tb'] then it must be used here, otherwise the table
				name is required.
	display		true if the field is to be selected from the database and
				is to appear in listings etc.
	select		true if the field is to just be selected from the database but 
				not appear in listings. If both display and select are false
				or omitted the field will not be selected.
	arrayedit	true if this field is to be editable in ArrayEdit mode. Note that this
				only controls editability; visibility in ArrayEdit mode is determined by
				the display parameter above.
	fieldgroup	a list of comma-separated names indicating which groups the
				field is to be selected for.
				"*" is a special name indicating all fieldgroups.
				"Master" is a special name indicating that the field is to
				appear in the master record listing. 
	format		optional; the display format for the item. Not all tabs and
				forms will respect this.
	truncate_display		optional; the maximum characters to display in the
							listing. Items longer than this are trimmed and
							"[more...]" is appended.
	helpfile	the path to a file that will display help information about
				this field.
	filter		usually blank, but can contain a default filtering value. If
				given, only records with matching values in this field will be
				displayed by default.
	widget		the name of a widget used to display the field in ArrayEdit (spreadsheet)
				mode. Available widgets are:
					'menu'
					'checkbox'
					'checkboxyn'
					'datetimepicker'
					'ckeditor'
					'textarea'
					'phonemask'
	allowedvalues	used to populate menus, checkbox fields and radio button
					groups with allowed values for this field.
	allowedlabels	used in conjunction with allowedvalues to provide the
					visible labels for the various values. If allowedvalues is
					given but allowedlabels is omitted then the visible labels
					are the same as the allowed values.
	search_more	By default, all fields are listed in the Search Fields column.
				If search_more is true, this field will only appear when the
				"More" down-arrow in the Search Fields column is clicked.
	can_read	if present, lists the user groups who can read this field. If
				absent, all users can read this field. Note that this only
				indicates whether a field should be displayed for reading; it
				doesn't enforce the read-only condition.
	can_edit	if present, lists the user groups who can edit this field. If
				absent, all users can edit this field. Note that this only
				indicates whether a field should be displayed as editable; it
				doesn't enforce the editable condition.
	copyValue	the default value to insert when a record is copied. Processing
				of this field is up to the copy_to_current.php or similar
				function that handles the actual copy.
	css			an optional CSS fragment that can be applied to the listing (e.g. to
				change font size, colour etc.).
	
