<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /manager/help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

/* MySQL table names */

$db['tb'] = 'regemailcontrol_history r';
$db['tbnoalias'] = 'regemailcontrol_history';

global $opts;
$opts['join_clause'] = '';

/* Field definitions start here */

$fields['action'] = array(
		'heading' => "Database Action",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'filter' => "");
$fields['revision'] = array(
		'heading' => "Revision",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'filter' => "");
$fields['dt_datetime'] = array(
		'heading' => "Change Time",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'format' => '%d%b%Y %T',
		'filter' => "");
$fields['letter_id'] = array(
		'heading' => "Letter ID",
		'table' => 'r',
		'display' => false,
		'fieldgroup' => '*',
		'primarykey' => true,
		'filter' => "");
$fields['letter_group'] = array(
		'heading' => "Group",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'arrayedit' => true,
		'filter' => "");
$fields['letter_sequence'] = array(
		'heading' => "Letter Sequence",
		'table' => 'r',
		'display' => false,		//	temp
		'arrayedit' => false,	//	temp
		'fieldgroup' => 'Master, *',
		'filter' => "");
$fields['letter_rule'] = array(
		'heading' => "Rule table",
		'table' => 'r',
		'display' => true,		//	temp
		'arrayedit' => true,	//	temp
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => "");
$fields['letter_name'] = array(
		'heading' => "Letter Name",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => 'Master, *',
		'filter' => "");
$fields['letter_from'] = array(
		'heading' => "From addr",
		'table' => 'r',
		'display' => true,		//	temp
		'arrayedit' => true,	//	temp
		'fieldgroup' => '*, Master',
		'search_more' => true,
		'filter' => "");
$fields['letter_to'] = array(
		'heading' => "To addr",
		'table' => 'r',
		'display' => true,		//	temp
		'arrayedit' => true,	//	temp
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => "");
$fields['letter_cc'] = array(
		'heading' => "CC addr",
		'table' => 'r',
		'display' => true,		//	temp
		'arrayedit' => true,	//	temp
		'fieldgroup' => '*, Master',
		'search_more' => true,
		'filter' => "");
$fields['letter_bcc'] = array(
		'heading' => "BCC addr",
		'table' => 'r',
		'display' => true,		//	temp
		'arrayedit' => true,	//	temp
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => "");
$fields['letter_subject'] = array(
		'heading' => "Subject",
		'table' => 'r',
		'display' => true,		//	temp
		'arrayedit' => true,	//	temp
		'fieldgroup' => '*, Master',
		'filter' => "");
$fields['letter_html_file'] = array(
		'heading' => "HTML template filename",
		'table' => 'r',
		'display' => false,		//	temp
		'arrayedit' => false,	//	temp
		'fieldgroup' => '*',
		'filter' => "");
$fields['letter_comments'] = array(
		'heading' => "Comments",
		'table' => 'r',
		'display' => false,
		'fieldgroup' => '*',
		'filter' => "");
$fields['letter_html'] = array(
		'heading' => "HTML template inline",
		'table' => 'r',
		'fieldgroup' => '*',
		'display' => false,		//	temp
		'arrayedit' => false,	//	temp
		'widget' => 'textarea',	//	temp
		'search_more' => true,
		'filter' => "");
$fields['letter_attachments'] = array(
		'heading' => "Attachments control",
		'table' => 'r',
		'fieldgroup' => '*',
		'search_more' => true,
		'display' => true,
		'arrayedit' => true,
		'filter' => "");

/* End of Field definitions. */

/* Field group definitions */

$tpl['fieldgroups'] = array(
/*	'Blank' => array('label' => '>',
		'url' => 'blank.php'), */
/*	No tabs except All Fields for History.
	'Master' => array('label'=>'Master',
		'url' =>''),
	'Detail' => array('label' => 'Details',
		'url' => 'emailcontroltaburl.php',
		'authgroup' => array('Admin')),
	'Add New' => array('label' => ' + ',
		'url' => 'emailcontrol_addurl.php',
		'authgroup' => array('Admin')),
	'Delete This' => array('label' => ' - ',
		'url' => 'emailcontrol_deleteurl.php',
		'authgroup' => array('Admin')),
*/
	'All' => array('label' => 'All Fields',
		'url' => 'allfieldsurl.php?dirname=emailcontrolhistory',
		'authgroup' => array('Admin')),
);

?>