<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

/* MySQL table names */

$db['tb'] = 'changelog c';
$db['tbnoalias'] = 'changelog';

global $opts;
$opts['join_clause'] = '';

/* Field definitions start here */

$fields['change_date'] = [
		'heading' => "Timestamp",
		'table' => 'c',
		'display' => true,
		'width' => '30%',
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'fieldgroup' => 'Master, Details',
//		'helpfile' => 'help/timestamphelp.php',
		'filter' => ""];
$fields['change_system'] = [
		'heading' => "System",
		'table' => 'c',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['change_description'] = [
		'heading' => "Description",
		'table' => 'c',
		'display' => true,
		'width' => '65%',
//		'copyValue' => 'Enter change description here...',
		'arrayedit' => true,
		'widget' => 'ckeditor',
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['id'] = [
'heading' => 'Entry number',
		'primarykey' => true,
		'table' => 'c',
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];

/* End of Field definitions. */

/* Field group definitions */

$tpl['fieldgroups'] = [
/*	'Blank' => ['label' => '>',
		'url' => 'blank.php'], */
	'Master' => ['label'=>'Master',
		'url' =>''
		],
	'Details' => ['label' => 'Details',
		'url' => 'taburl.php?template=change_detail.tpl',
		'height' => '600',
// 		'width' => 'auto',
		'authgroup' => ['Admin']
		],
	'AddNew' => ['label' => 'Copy',
		'url' => 'add.php',
		'height' => '600',
		'authgroup' => ['Admin'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
	],
	'DeleteThis' => ['label' => 'Delete',
		'url' => 'delete.php',
		'authgroup' => ['Admin'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
		],
	'Logs' => ['label' => 'Log Entries',
		'url' => "../log-list.php?tbname={$db['tbnoalias']}",
		'width' => 1500,
		'height' => 800,
		'authgroup' => ['Admin']]
];

?>