<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /manager/help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

/* MySQL table names */

$db['tb'] = 'regall_history r';
$db['tbnoalias'] = 'regall_history';

global $opts;
$opts['join_clause'] = '';

/* Field definitions start here */

$fields['action'] = [
		'heading' => "Database Action",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['entrynum'] = [
'heading' => 'Entry number',
		'primarykey' => true,
		'table' => 'r',
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['revision'] = [
		'heading' => "Revision",
		'primarykey' => true,
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['dt_datetime'] = [
		'heading' => "Change Time",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'format' => '%d%b%Y %T',
		'filter' => ""];
$fields['timestamp'] = [
		'heading' => "Time Stamp",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'format' => '%d%b%Y %T',
		'helpfile' => 'help/timestamphelp.php',
		'filter' => ""];
$fields['firstnamepref'] = [
		'heading' => "Preferred First Name",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['lastnamepref'] = [
		'heading' => "Preferred Last Name",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['confirmation_no'] = [
		'heading' => "Registration No.",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['firstname'] = [
		'heading' => "Legal First Name",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['lastname'] = [
		'heading' => "Legal Last Name",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['relto_firstnamepref'] = [
		'heading' => "Attending with (first)",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => ' *',
		'filter' => ""];
$fields['relto_lastnamepref'] = [
		'heading' => "Attending with (last)",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => ' *',
		'filter' => ""];
$fields['relto_email'] = [
		'heading' => "Attending with (email)",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Master,',
		'filter' => ""];
$fields['email'] = [
		'heading' => "Email",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['may_contact'] = [
		'heading' => "May Contact",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'allowedvalues' => ['Yes', 'No'],
		'allowedlabels' => ['Yes', 'No'],
		'filter' => ""];
$fields['address'] = [
		'heading' => "Address",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['city'] = [
		'heading' => "City",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['state'] = [
		'heading' => "State/Prov",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['zip'] = [
		'heading' => "Zip/Postal",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['country'] = [
		'heading' => "Country",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['phone'] = [
		'heading' => "Phone",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['room'] = [
		'heading' => "Room",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'fieldgroup' => '*',
		'arrayedit' => true,
		'filter' => ""];
$fields['besttimetocall'] = [
		'heading' => "Time to Call",
		'table' => 'r',
		'search_more' => true,
		'select' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['nametoaskfor'] = [
		'heading' => "Ask for",
		'table' => 'r',
		'search_more' => true,
		'select' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['firstesprit'] = [
		'heading' => "First Esprit",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['howheard'] = [
		'heading' => "How Heard",
		'table' => 'r',
		'fieldgroup' => '*',
		'select' => true,
		'search_more' => true,
		'filter' => ""];
$fields['fee'] = [
		'heading' => "Fee",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['scholapplication'] = [
		'heading' => "Applying for Scholarship",
		'table' => 'r',
		'select' => true,
		'arrayedit' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['notes'] = [
		'heading' => "Notes",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['esprit_year'] = [
		'heading' => "Esprit Year",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['bio'] = [
		'heading' => "Biography Notes",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['ratepkg'] = [
		'heading' => "Pkg",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['attendeesign'] = [
		'heading' => "Signed",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['reg_status'] = [
		'heading' => "Registration Status",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'allowedvalues' => ['Pre-registered', 'Paid', 'Checked In', 'Participant Cancelled', 'Esprit Cancelled', 'Blocked', 'Checked Out'],
		'helpfile' => 'help/regstatushelp.php',
		'search_more' => true,
		'arrayedit' => true,
		'widget' => 'menu',
		'filter' => ""];
$fields['checkindate'] = [
		'heading' => "Checkin Date",
		'fieldgroup' => '*',
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'filter' => ""];
$fields['daysun1'] = [
		'heading' => "Sunday (start)",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['daymon'] = [
		'heading' => "Monday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['daytue'] = [
		'heading' => "Tuesday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['daywed'] = [
		'heading' => "Wednesday",
		'select' => true,
		'table' => 'r',
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['daythu'] = [
		'heading' => "Thursday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['dayfri'] = [
		'heading' => "Friday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['daysat'] = [
		'heading' => "Saturday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['daysun2'] = [
		'heading' => "Sunday (end)",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['bigsis'] = [
		'heading' => "IS Big Sis",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'arrayedit' => 'true',
		'widget' => 'radio',
		'allowedvalues' => ["Yes", "No"],
		'allowedlabels' => ["Yes", "No"],
		'filter' => ""];
$fields['littlesis'] = [
		'heading' => "NEEDS Big Sis",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'arrayedit' => 'true',
		'widget' => 'radio',
		'allowedvalues' => ["Yes", "No"],
		'allowedlabels' => ["Yes", "No"],
		'filter' => ""];
$fields['bslsage'] = [
		'heading' => "Age Bracket",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'allowedvalues' => ['-', '18-29', '30-39', '40-49', '50-59','60+'],
		'allowedlabels' => ['-', '18-29', '30-39', '40-49', '50-59','60+'],
		'arrayedit' => true,
		'widget' => 'menu',
		'filter' => ""];
$fields['meal1'] = [
		'heading' => "Meal 1",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['meal2'] = [
		'heading' => "Meal 2",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['meal3'] = [
		'heading' => "Meal 3",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['meal4'] = [
		'heading' => "Meal4",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['meal5'] = [
		'heading' => "Meal 5",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['meal6'] = [
		'heading' => "Meal 6",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['meal1checked'] = [
		'heading' => "Meal 1 Checkin Count",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['meal2checked'] = [
		'heading' => "Meal 2 Checkin Count",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['meal3checked'] = [
		'heading' => "Meal 3 Checkin Count",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['meal4checked'] = [
		'heading' => "Meal4 Checkin Count",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['meal5checked'] = [
		'heading' => "Meal 5 Checkin Count",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['meal6checked'] = [
		'heading' => "Meal 6 Checkin Count",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['form_type'] = [
		'heading' => "Form Type",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'widget' => 'menu',
		'fieldgroup' => '*',
		'allowedvalues' => ['Single', 'SO', 'Add-Family', 'Committee_Full', 'Committee_Partial', 'Resource_Presenter', 'Resource_Vendor', 'Observer', 'Guest', 'Assistant', 'Internal'],
		'helpfile' => 'help/formtypehelp.php',
		'filter' => ""];
$fields['print_badge'] = [
		'heading' => "Print Badge",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'arrayedit' => true,
		'allowedvalues' => ['Yes', 'No'],
		'allowedlabels' => ['Yes', 'No'],
		'search_more' => true,
		'filter' => ""];
$fields['photousage'] = [
		'heading' => "Badge Photo Usage",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'arrayedit' => true,
		'allowedvalues' => ['Public', 'Private'],
		'search_more' => true,
		'filter' => ""];
$fields['is_presenter'] = [
		'heading' => "Is a Presenter",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'arrayedit' => true,
		'allowedvalues' => [1, 0],
		'allowedlabels' => ['Yes', 'No'],
		'search_more' => true,
		'filter' => ""];
$fields['is_vendor'] = [
		'heading' => "Is a Vendor",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'arrayedit' => true,
		'allowedvalues' => [1, 0],
		'allowedlabels' => ['Yes', 'No'],
		'search_more' => true,
		'filter' => ""];
$fields['badge_icon'] = [
		'heading' => "Badge Icon",
		'table' => 'r',
		'select' => true,
		'arrayedit' => true,
		'fieldgroup' => '*',
		'allowedvalues' => ['', 'no_photos.png', 'photographer.png', 'firehat.png', 'caduceus.png', 'star.png'],
		'allowedlabels' => ['None', 'No Photos', 'Photographer', 'Firefighter', 'Medical Caduceus', 'Star'],
		'search_more' => true,
		'filter' => ""];
$fields['badge_code'] = [
		'heading' => "Badge Code",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'filter' => ""];
/*	Experimental custom column. Presence of callback parameter
	indicates it's not selected from the database and can't be sorted */
$fields['has_photo'] = [
		'heading' => 'Has Photo',
//		'display' => true,
		'callback' => 'return file_exists($tpl["badgephotourl"] . $row["confirmation_no"].".jpg") ? "Y" : "";',
		'fieldgroup' => '*',
		'select' => true];
// $fields['has_qr'] = [
// 		'heading' => 'Has QR',
// //		'display' => true,
// 		'callback' => 'return file_exists($tpl["qrurl"] . $row["confirmation_no"].".png") ? "Y" : "";',
// 		'fieldgroup' => '*',
// 		'select' => true];

/* End of Field definitions end here. */

/* Field group definitions */

$tpl['fieldgroups'] = [
	'Master' => ['label'=>'Master',
		'url' =>''],
/*	No tabs except All Fields for history.
	'Basic' => ['label' => 'Basic Info',
		'icon' => '/images/icon-home.png',
		'url' => 'basicallurl.php?access=read-only',
		'authgroup' => ['Registrar', 'Desk', 'Admin', 'BSLS', 'Vendor',
			'Presenter', 'Sig. Others', 'Scholarships']],
	'BasicRO' => ['label' => 'Basic Info',
		'icon' => '/images/icon-home.png',
		'url' => 'basicallurl.php?access=read_only',
		'authgroup' => ['Hotel']],
	'Registration' => ['label' => 'Registration',
		'icon' => '/images/icon-checkin.png',
		'url' =>'registrationallurl.php?access=read-only',
		'authgroup' => ['Registrar', 'Desk', 'Admin', 'BSLS', 'Vendor',
			'Presenter', 'Sig. Others']],
	'Meals' => ['label' => 'Meals',
		'icon' => '/images/icon-meal.png',
		'url' => 'mealsallurl.php?access=read-only',
		'authgroup' => ['Registrar', 'Admin']],
	'BSLS' => ['label' => 'Big/Little Sisters',
		'icon' => '/images/icon-bigsis.png',
		'url' => 'bslsallurl.php?access=read-only',
		'authgroup' => ['Registrar', 'Admin']],
	'Account' => ['label' => 'Account',
		'icon' => '/images/icon-transactions.png',
		'url' => 'accountsallurl.php?access=read-only',
		'authgroup' => ['Registrar', 'Admin']],
	'Badges' => ['label' => 'Badges',
		'icon' => '/images/icon-badge.png',
		'url' => 'badgeallurl.php?access=read-only',
		'authgroup' => ['Registrar', 'Admin']],
	'Utilities' => ['label' => 'Utilities', 
		'url' => 'utilitiesallurl.php?access=read-only',
		'authgroup' => ['Admin']],
	'Letters' => ['label' => 'Letters',
		'url' => 'letterstaburl.php?access=read-only',
		'authgroup' => ['Admin']],
*/
	'All' => ['label' => 'All Fields',
		'url' => '../allfieldsurl.php?dirname=attendeeshistory',
		'authgroup' => ['Admin']]
/*	No tabs except All Fields for history.
	'Copy' => ['label' => 'Copy to Current Year',
		'url' => 'attendeesall_addurl.php?group=Copy',
		'authgroup' => ['Registrar', 'Admin'))
*/
];

?>