<?php
/*	This file regenerates the password hash for a registration given its entry number.
	It's intended to be called from the Utilities tab of the Participants screen.
	
	Certain user-accessible features (such as restricted content, videos, etc.) in the
	system require the user to validate using their email address and confirmation number.
	This uses the .htaccess mechanism provided by Apache, which expects a username and
	password. The username is the email address they used to register and the password is
	their confirmation number.
	
	Users who registered before this went into effect might have no hash on file. This
	function creates it for them.
	
	Repeated use of this will generate different hashes which match the provided
	confirmation number, so no harm is done.
	
	Parameter is ?confno=x, where x is the entry number of the reg record.
	
	Stephanie Mitchell, 19 January, 2021
*/
/*
	See if logged in via Quadodo
*/
global $tpl;
define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once "header.php";
$tpl['authgroup'] = $qls->group_id_to_name($qls->user_info['group_id']);
$tpl['username'] = $qls->user_info['username'];
if ($tpl['username'] == '') {
header('Location: /qls/login.php');
exit;
}

$primarykeyfieldvalue = $_REQUEST['pkfv'];
$primarykeyfieldname = $_REQUEST['pkfn'];
$group = $_REQUEST['group'];

require_once ".config.php";
require_once "fieldlist.php";
require_once "template_options.php";
require_once "mysql_utilities.php";
mysql_login('Normal');

mysql_login();
print '<link href="css/styles.css" rel="stylesheet" type="text/css" media="all">';

$conf = $_REQUEST['confno'];

if ($conf == '') {
	SM_Die('Missing confno (confirmation number) when attempting to regenerate password hash.', 'No registration specified for password reset.');
	}

$hash = password_hash($conf, PASSWORD_BCRYPT);
$sql = "UPDATE reg SET password='$hash' WHERE confirmation_no=$conf";

// print 'Final SQL query: '.$sql;

$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error while regenerating password hash: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Updating password failed - sorry!');

// Add log file entry

$sql_escaped =  mysqli_real_escape_string($GLOBALS['dbConnect'], $sql);
Make_Log_Entry($GLOBALS['dbConnect'], "REGISTRATION PASSWORD RESET: $sql_escaped");
mysql_logout();	//	Disconnect from database

print '<span class="warning">Password RESET</span>';
print "<p>$msg<br/><br /><a href=\"index.php\">Refresh</a>";

?>