<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');
global $opts, $all_years;

/* MySQL table names */

if ($all_years) {
	$db['tb'] = 'regall r';
	$db['tbnoalias'] = 'regall';
} else {
	$db['tb'] = 'reg r';
	$db['tbnoalias'] = 'reg';
}
$opts['join_clause'] = '';
/* Field definitions start here */
// print "\$all_years: $all_years";
if ($all_years) {
	$fields['esprit_year'] = [
			'heading' => "Esprit Year",
			'table' => 'r',
			'select' => true,
			'display' => true,
			'fieldgroup' => '*, Master',
//	 		'copyValue' => $esprit_year,	//	Uncomment to test copyValue
			'width' => '8%',
			'search_more' => false,
			'filter' => ""];
} else {
	$fields['esprit_year'] = [
			'heading' => "Esprit Year",
			'table' => 'r',
			'select' => true,
			'display' => true,
			'fieldgroup' => '*',
			'search_more' => false,
			'filter' => ""];
}
// print "\$all_years=$all_years, \$db[tb]={$db['tb']}";
$fields['timestamp'] = [
		'heading' => "Time Stamp",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*,Master',
		'css' => 'font-size:75%',
		'date_format' => '%d%b%Y<br />%T',
		'helpfile' => '../help/timestamphelp.php',
		'search_more' => false,
		'filter' => ""];
$fields['updatetime'] = [
		'heading' => "Updated On",
		'table' => 'r',
		'display' => false,
		'fieldgroup' => '*',
		'date_format' => '%d%b%Y<br />%T',
		'helpfile' => '../help/timestamphelp.php',
		'filter' => ""];
$fields['firstnamepref'] = [
		'heading' => "Pref. First Name",
		'long_heading' => "Preferred First Name",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'miniview' => true,
		'width' => "12%",
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['lastnamepref'] = [
		'heading' => "Pref. Surname",
		'long_heading' => "Preferred Surname",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'miniview' => true,
		'width' => "8%",
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pronouns'] = [
		'heading' => "Pref. Pronouns",
		'long_heading' => "Preferred Pronouns",
		'table' => 'r',
		'display' => true,
		'width' => "15%",
		'widget' => 'menu',
		/*
			For some reason, this can't be set from the $GLOBALS['pronouns']
			defined in .config.php, so it must be set here explicitly to match.
		*/
		'allowedvalues' => ['-', 'She, Her', 'He, Him', 'They, Them', 'Ze, Zir'],
		'arrayedit' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['confirmation_no'] = [
		'heading' => "Confirmation",
		'long_heading' => "Confirmation No.",
		'table' => 'r',
		'display' => true,
		'width' => "8%",
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['password'] = [
		'heading' => "Password",
		'table' => 'r',
// 		'display' => true,
		'width' => "8%",
		'fieldgroup' => '*',
		'filter' => ""];
$fields['firstname'] = [
		'heading' => "Legal First Name",
		'long_heading' => "Legal First Name",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['lastname'] = [
		'heading' => "Legal Surname",
		'long_heading' => "Legal Surname",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['relto_firstnamepref'] = [
		'heading' => "Att.with (first)",
		'long_heading' => "Attending with (first)",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => ' *',
		'filter' => ""];
$fields['relto_lastnamepref'] = [
		'heading' => "Att. with (last)",
		'long_heading' => "Attending with (last)",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => ' *',
		'filter' => ""];
$fields['relto_email'] = [
		'heading' => "Att. with (email)",
		'long_heading' => "Attending with (email)",
		'table' => 'r',
		'select' => true,
		'width' => "15%",
		'fieldgroup' => 'Registration, Basic, Account, BSLS, Volunteers, Letters',
		'filter' => ""];
$fields['email'] = [
		'heading' => "Email",
		'long_heading' => "Email address",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Master, Registration, Basic, BSLS, Utilities, Letters,EmailLogs',
		'filter' => ""];
$fields['may_contact'] = [
		'heading' => "May Contact",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'widget' => 'menu',
		'fieldgroup' => 'Registration, Basic, Letters',
		'allowedvalues' => ['Yes', 'No'],
		'allowedlabels' => ['Yes', 'No'],
		'filter' => ""];
$fields['address'] = [
		'heading' => "Address",
		'long_heading' => "Street Address",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'helpfile' => '../help/addresshelp.php',
		'fieldgroup' => 'Registration, Basic, Utilities, BasicRO, Letters',
		'filter' => ""];
$fields['city'] = [
		'heading' => "City",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Registration, Basic, Badges, Account, BSLS, Volunteers, Utilities, BasicRO, Letters, Vaxcerts',
		'filter' => ""];
$fields['state'] = [
		'heading' => "State/Prov",
		'long_heading' => "State/Province",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => 'Registration, Basic, Badges, Account, BSLS, Volunteers, Utilities, BasicRO, Letters, Vaxcerts',
		'filter' => ""];
$fields['zip'] = [
		'heading' => "Zip/Postal",
		'long_heading' => "Zipcode/Postal Code",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'fieldgroup' => 'Registration, Basic, Badges, Account, BSLS, Utilities, BasicRO, Letters, Vaxcerts',
		'filter' => ""];
$fields['country'] = [
		'heading' => "Country",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'fieldgroup' => 'Registration, Basic, Badges, Account, BSLS, Volunteers, Utilities, BasicRO, Letters, Vaxcerts',
		'filter' => ""];
$fields['safe_address'] = [
		'heading' => "SAFE Address",
		'long_heading' => "SAFE Street Address",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'helpfile' => '../help/addresssafehelp.php',
		'fieldgroup' => 'Registration, Basic, Utilities, Letters',
		'filter' => ""];
$fields['safe_city'] = [
		'heading' => "SAFE City",
		'table' => 'r',
		'fieldgroup' => 'Registration, Basic, Badges, Account, BSLS, Utilities, Letters',
		'filter' => ""];
$fields['safe_state'] = [
		'heading' => "SAFE State/Prov",
		'long_heading' => "SAFE State/Province",
		'table' => 'r',
		'arrayedit' => true,
		'fieldgroup' => 'Registration, Basic, Badges, Account, BSLS, Utilities, Letters',
		'filter' => ""];
$fields['safe_zip'] = [
		'heading' => "SAFE Zip/Postal",
		'long_heading' => "SAFE Zipcode/Postal Code",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'fieldgroup' => 'Registration, Basic, Badges, Account, BSLS, Utilities, Letters',
		'filter' => ""];
$fields['safe_country'] = [
		'heading' => "SAFE Country",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'fieldgroup' => 'Registration, Basic, Badges, Account, BSLS, Utilities, Letters',
		'filter' => ""];
$fields['phone'] = [
		'heading' => "Phone",
		'long_heading' => "Phone No.",
		'table' => 'r',
		'select' => true,
		'display' => true,
		'arrayedit' => true,
		'widget' => 'phonemask',
		'css' => 'font-size:80%; color: #888888',
		'search_more' => true,
		'fieldgroup' => 'Master,Registration, Basic, BSLS, Letters',
		'filter' => ""];
$fields['em_contact_name'] = [
		'heading' => "Em. Contact",
		'long_heading' => "Emergency Contact",
		'table' => 'r',
		'select' => true,
		'display' => true,
		'arrayedit' => true,
		'css' => 'font-size:80%; color: #888888',
		'search_more' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['em_contact_phone'] = [
		'heading' => "Em Phone",
		'long_heading' => "Emergency Contact Phone",
		'table' => 'r',
		'select' => true,
		'display' => true,
		'arrayedit' => true,
		'widget' => 'phonemask',
		'css' => 'font-size:80%; color: #888888',
		'search_more' => true,
		'fieldgroup' => 'Master, *',
		'filter' => ""];
$fields['textcontact'] = [
		'heading' => "Text",
		'long_heading' => "Text contact",
		'table' => 'r',
		'select' => true,
		'display' => true,
		'arrayedit' => true,
		'widget' => 'phonemask',
		'css' => 'font-size:80%; color: #888888',
		'search_more' => true,
		'fieldgroup' => 'Master,Registration, Basic, BSLS, Letters',
		'filter' => ""];
$fields['room'] = [
		'heading' => "Room",
		'long_heading' => "Hotel Room",
		'labelhelp' => 'Enter if known',
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'fieldgroup' => 'Admin, Registration, BasicRO, Letters',
		'arrayedit' => true,
		'filter' => ""];
$fields['besttimetocall'] = [
		'heading' => "Time to Call",
		'long_heading' => "Best Time to Call",
		'table' => 'r',
		'search_more' => true,
		'select' => true,
		'fieldgroup' => 'Registration, Basic, BSLS, Letters',
		'filter' => ""];
$fields['nametoaskfor'] = [
		'heading' => "Ask for",
		'table' => 'r',
		'search_more' => true,
		'select' => true,
		'fieldgroup' => 'Registration, Basic, BSLS, Letters',
		'filter' => ""];
$fields['firstesprit'] = [
		'heading' => "First Esprit",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Registration, Basic, Badges, BSLS, Letters',
		'search_more' => true,
		'filter' => ""];
/* 
$fields['howheard'] = [
		'heading' => "How Heard",
		'table' => 'r',
		'fieldgroup' => 'Registration, Basic',
		'select' => true,
		'search_more' => true,
		'filter' => ""];
 */
$fields['fee'] = [
		'heading' => "Fee",
		'long_heading' => "Registration Fee",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Registration, Letters',
		'search_more' => true,
		'filter' => ""];
$fields['scholapplication'] = [
		'heading' => "Applying for Scholarship",
		'table' => 'r',
		'select' => true,
		'arrayedit' => true,
		'fieldgroup' => 'Registration',
		'allowedlabels' => ['Yes', 'No'],
		'allowedvalues' => ['Yes', 'No'],
		'search_more' => true,
		'filter' => ""];
$fields['notes'] = [
		'heading' => "Notes",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['bio'] = [
		'heading' => "Bio Notes",
		'long_heading' => "Biography Notes",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'search_more' => true,
		'filter' => ""];
$fields['ratepkg'] = [
		'heading' => "Pkg",
		'long_heading' => "Package",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Registration, Meals, Letters',
		'search_more' => true,
		'filter' => ""];
$fields['attendeesign'] = [
		'heading' => "Signed",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['reg_status'] = [
		'heading' => "Reg. Status",
		'long_heading' => "Registration Status",
		'table' => 'r',
		'display' => true,
		'width' => "10%",
		'fieldgroup' => 'Master,Registration, Meals, Badges, Account, BSLS, BasicRO, Letters, Vaxcerts',
		'allowedvalues' => ['Pre-registered', 'Paid', 'Checked In', 'Participant Cancelled', 'Esprit Cancelled', 'Blocked', 'Checked Out'],
		'helpfile' => '../help/regstatushelp.php',
		'search_more' => true,
		'arrayedit' => true,
		'widget' => 'menu',
		'filter' => ""];
$fields['acct_status'] = [
		'heading' => "Acct. Status",
		'long_heading' => "Account Status",
		'table' => 'r',
		'display' => true,
		'miniview' => true,
		'width' => "10%",
		'fieldgroup' => 'Master,Registration, Meals, Badges, Account, BSLS, BasicRO, Letters',
		'allowedvalues' => ['Paid', 'Owing', 'Owed'],
// 		'helpfile' => '../help/regstatushelp.php',
		'search_more' => true,
		'arrayedit' => true,
		'widget' => 'menu',
		'filter' => ""];
$fields['checkindate'] = [
		'heading' => "Checkin Date",
		'fieldgroup' => 'Registration, Meals, Badges, BSLS, BasicRO, MealsRO, Letters',
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'filter' => ""];
$fields['daysun1'] = [
		'heading' => "Sunday (start)",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Registration, Meals, Badges, BSLS, BasicRO, MealsRO, Letters, Vaxcerts',
		'search_more' => true,
		'filter' => ""];
$fields['daymon'] = [
		'heading' => "Monday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Registration, Meals, Badges, BSLS, BasicRO, MealsRO, Letters, Vaxcerts',
		'search_more' => true,
		'filter' => ""];
$fields['daytue'] = [
		'heading' => "Tuesday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Registration, Meals, Badges, BSLS, BasicRO, MealsRO, Letters, Vaxcerts',
		'search_more' => true,
		'filter' => ""];
$fields['daywed'] = [
		'heading' => "Wednesday",
		'select' => true,
		'table' => 'r',
		'fieldgroup' => 'Registration, Meals, Badges, BSLS, BasicRO, MealsRO, Letters, Vaxcerts',
		'search_more' => true,
		'filter' => ""];
$fields['daythu'] = [
		'heading' => "Thursday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Registration, Meals, Badges, BSLS, BasicRO, MealsRO, Letters, Vaxcerts',
		'search_more' => true,
		'filter' => ""];
$fields['dayfri'] = [
		'heading' => "Friday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Registration, Meals, Badges, BSLS, BasicRO, MealsRO, Letters, Vaxcerts',
		'search_more' => true,
		'filter' => ""];
$fields['daysat'] = [
		'heading' => "Saturday",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Registration, Meals, Badges, BSLS, BasicRO, MealsRO, Letters, Vaxcerts',
		'search_more' => true,
		'filter' => ""];
$fields['daysun2'] = [
		'heading' => "Sunday (end)",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Registration, Meals, Badges, BSLS, BasicRO, MealsRO, Letters, Vaxcerts',
		'search_more' => true,
		'filter' => ""];
$fields['checkinvalid'] = [
		'heading' => "Checkin Valid",
		'long_heading' => 'Checkin Valid After',
		'table' => 'r',
		'select' => true,
		'copyValue' => $GLOBALS['esprit_start_mysql'],
		'fieldgroup' => 'Registration, Meals, Badges, BSLS, BasicRO, MealsRO, Letters, Vaxcerts',
		'widget' => 'datetimepicker'
		];
$fields['bigsis'] = [
		'heading' => "IS Big Sis",
		'long_heading' => "Volunteering as Big Sister",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Registration, Meals, Badges, BSLS, Letters',
		'arrayedit' => 'true',
		'widget' => 'menu',
		'allowedvalues' => ["Yes", "No"],
		'allowedlabels' => ["Yes", "No"],
		'filter' => ""];
$fields['littlesis'] = [
		'heading' => "NEEDS Big Sis",
		'long_heading' => "Requesting Big Sister",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Registration, Meals, Badges, BSLS, Letters',
		'arrayedit' => 'true',
		'widget' => 'menu',
		'allowedvalues' => ["Yes", "No"],
		'allowedlabels' => ["Yes", "No"],
		'filter' => ""];
$fields['bslsage'] = [
		'heading' => "Age Bracket",
		'long_heading' => "Age Bracket for Big/Little Sister",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Registration, BSLS, Letters',
		'allowedvalues' => ['-', '18-29', '30-39', '40-49', '50-59','60+'],
		'allowedlabels' => ['-', '18-29', '30-39', '40-49', '50-59','60+'],
		'arrayedit' => true,
		'widget' => 'menu',
		'filter' => ""];
$fields['sopgmattend'] = [
		'heading' => "Attend SO Pgm",
		'long_heading' => "Plan to attend SO Program",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Registration, Meals, Badges, BSLS, Letters',
		'arrayedit' => 'true',
		'widget' => 'menu',
		'allowedvalues' => ["Yes", "No"],
		'allowedlabels' => ["Yes", "No"],
		'filter' => ""];
$fields['mentorcouple'] = [
		'heading' => "IS Mentor Couple",
		'long_heading' => "Volunteering as Mentor Couple",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Registration, Meals, Badges, BSLS, Letters',
		'arrayedit' => 'true',
		'widget' => 'menu',
		'allowedvalues' => ["Yes", "No"],
		'allowedlabels' => ["Yes", "No"],
		'filter' => ""];
$fields['menteecouple'] = [
		'heading' => "WANTS Mentor Couple",
		'heading' => "Requesting Mentor Couple",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => 'Registration, Meals, Badges, BSLS, Letters',
		'arrayedit' => 'true',
		'widget' => 'menu',
		'allowedvalues' => ["Yes", "No"],
		'allowedlabels' => ["Yes", "No"],
		'filter' => ""];
// $fields['meal1'] = [
// 		'heading' => "Meal 1",
// 		'table' => 'r',
// 		'select' => true,
// 		'fieldgroup' => 'Registration, Meals, Badges, MealsRO, Letters',
// 		'search_more' => true,
// 		'filter' => ""];
$fields['meal2'] = [
		'heading' => "Meal 2",
		'table' => 'r',
		'select' => true,
		'copyValue' => 0,
		'fieldgroup' => 'Registration, Meals, Badges, MealsRO, Letters, Vaxcerts',
		'search_more' => true,
		'filter' => ""];
$fields['meal3'] = [
		'heading' => "Meal 3",
		'table' => 'r',
		'select' => true,
		'copyValue' => 0,
		'fieldgroup' => 'Registration, Meals, Badges, MealsRO, Letters, Vaxcerts',
		'search_more' => true,
		'filter' => ""];
$fields['meal4'] = [
		'heading' => "Meal4",
		'table' => 'r',
		'select' => true,
		'copyValue' => 0,
		'fieldgroup' => 'Registration, Meals, Badges, MealsRO, Letters, Vaxcerts',
		'search_more' => true,
		'filter' => ""];
$fields['meal5'] = [
		'heading' => "Meal 5",
		'table' => 'r',
		'select' => true,
		'copyValue' => 0,
		'fieldgroup' => 'Registration, Meals, Badges, MealsRO, Letters, Vaxcerts',
		'search_more' => true,
		'filter' => ""];
$fields['meal6'] = [
		'heading' => "Meal 6",
		'table' => 'r',
		'select' => true,
		'copyValue' => 0,
		'fieldgroup' => 'Registration, Meals, Badges, MealsRO, Letters, Vaxcerts',
		'search_more' => true,
		'filter' => ""];
// $fields['meal1checked'] = [
// 		'heading' => "Meal 1 Checkin Count",
// 		'table' => 'r',
// 		'select' => true,
// 		'fieldgroup' => 'Registration, Meals, Badges, MealsRO',
// 		'search_more' => true,
// 		'filter' => ""];
$fields['meal2checked'] = [
		'heading' => "Meal 2 Checkin Count",
		'table' => 'r',
		'select' => true,
		'copyValue' => 0,
		'fieldgroup' => 'Registration, Meals, Badges, MealsRO',
		'search_more' => true,
		'filter' => ""];
$fields['meal3checked'] = [
		'heading' => "Meal 3 Checkin Count",
		'table' => 'r',
		'select' => true,
		'copyValue' => 0,
		'fieldgroup' => 'Registration, Meals, Badges, MealsRO',
		'search_more' => true,
		'filter' => ""];
$fields['meal4checked'] = [
		'heading' => "Meal4 Checkin Count",
		'table' => 'r',
		'select' => true,
		'copyValue' => 0,
		'fieldgroup' => 'Registration, Meals, Badges, MealsRO',
		'search_more' => true,
		'filter' => ""];
$fields['meal5checked'] = [
		'heading' => "Meal 5 Checkin Count",
		'table' => 'r',
		'select' => true,
		'copyValue' => 0,
		'fieldgroup' => 'Registration, Meals, Badges, MealsRO',
		'search_more' => true,
		'filter' => ""];
$fields['meal6checked'] = [
		'heading' => "Meal 6 Checkin Count",
		'table' => 'r',
		'select' => true,
		'copyValue' => 0,
		'fieldgroup' => 'Registration, Meals, Badges, MealsRO',
		'search_more' => true,
		'filter' => ""];
$fields['mealnotes'] = [
		'heading' => "Meal Notes",
		'table' => 'r',
		'select' => true,
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];
$fields['form_type'] = [
		'heading' => "Form Type",
		'table' => 'r',
		'display' => true,
		'width' => "10%",
		'arrayedit' => true,
		'widget' => 'menu',
		'width' => "10%",
		'fieldgroup' => '*, Master',
		'allowedvalues' => ['Single', 'SO', 'Add-Family', 'Committee_Full', 'Committee_Partial', 'Resource_Presenter', 'Resource_Vendor', 'Observer', 'Guest', 'Assistant', 'Volunteer', 'Non-Participant', 'Internal'],
		'allowedlabels' => ['Single', 'SO', 'Add-Family', 'Committee_Full', 'Committee_Partial', 'Resource_Presenter', 'Resource_Vendor', 'Observer', 'Guest', 'Assistant', 'Volunteer', 'Non-Participant', 'Internal'],
		'helpfile' => '../help/formtypehelp.php',
		'filter' => ""];
$fields['print_badge'] = [
		'heading' => "Print Badge",
		'long_heading' => "Print this Badge",
		'table' => 'r',
		'select' => true,
		'width' => "10%",
		'fieldgroup' => 'Master, Badges',
		'display' => true,
		'widget' => 'checkboxyn',
		'copyValue' => 'No',
		'arrayedit' => true,
		'allowedvalues' => ['Yes', 'No'],
		'allowedlabels' => ['Yes', 'No'],
		'search_more' => true,
		'filter' => ""];
$fields['photousage'] = [
		'heading' => "Badge Photo Usage",
		'long_heading' => "Allowed Badge Photo Usage",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Badges',
		'arrayedit' => true,
		'allowedvalues' => ['Public', 'Private'],
		'allowedlabels' => ['Public', 'Private'],
		'search_more' => true,
		'filter' => ""];
$fields['is_presenter'] = [
		'heading' => "Is a Presenter",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'arrayedit' => true,
		'allowedvalues' => ['Yes', 'No'],
		'allowedlabels' => ['Yes', 'No'],
		'search_more' => true,
		'filter' => ""];
$fields['is_vendor'] = [
		'heading' => "Is a Vendor",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => '*',
		'arrayedit' => true,
		'allowedvalues' => ['Yes', 'No'],
		'allowedlabels' => ['Yes', 'No'],
		'search_more' => true,
		'filter' => ""];
$fields['badge_icon'] = [
		'heading' => "Badge Icon",
		'table' => 'r',
		'select' => true,
		'arrayedit' => true,
		'fieldgroup' => 'Badges',
		'allowedvalues' => ['', 'no_photos.png', 'photographer.png', 'firehat.png', 'caduceus.png', 'help.png', 'star.png'],
		'allowedlabels' => ['None', 'No Photos', 'Photographer', 'Firefighter', 'Medical Caduceus', 'Information', 'Star'],
		'search_more' => true,
		'filter' => ""];
		
/*	Field badge_code is in database but is not needed for display and for some reason
	screws up display in master table. It may be related to badge_code also being an
	index. 

$fields['badge_code'] = [
		'heading' => "Badge Code",
		'table' => 'r',
		'select' => true,
		'fieldgroup' => 'Badges',
		'search_more' => true,
		'filter' => ""];
/* -- */

$fields['yearbookphoto'] = [
		'heading' => "Badge Photo Source",
		'table' => 'r',
		'select' => true,
		'allowedvalues' => ['use yearbook photo', 'use uploaded photo', 'take photo on arrival'],
		'widget' => 'menu',
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];
/*	Experimental custom column. Presence of callback parameter
	indicates it's not selected from the database and can't be sorted.*/
$fields['has_photo'] = [
		'heading' => 'Has Photo',
	'display' => true,
		'width' => "15%",
		'callback' => 'return file_exists("{$GLOBALS[\'badgephotobasedir\']}{$this_row[\'esprit_year\']}/{$this_row[\'confirmation_no\']}.jpg") ? "Y" : "";',
		'fieldgroup' => 'Master, Badges',
		'select' => true];
$fields['reg_covid_flag'] = [
		'heading' => "COVID Cert",
		'long_heading' => "COVID Vaccination Certificate",
		'table' => 'r',
		'select' => true,
		'display' => false,
		'miniview' => true,
		'search_more' => true,
		'fieldgroup' => 'Admin, Registration, Badges, Basic, Letters, Vaxcerts',
		'widget' => 'menu',
		'allowedvalues' => ['NA', 'Invalid', 'Unverified', 'Verified', 'Exempt'],
		'allowedlabels' => ['', 'Invalid', 'Unverified', 'Verified', 'Exempt'],
		'copyValue' => 'Unverified',
		'arrayedit' => true,
		'filter' => ""];
// $fields['has_vaxcert'] = [
// 		'heading' => 'Has Vax',
// 		'display' => false,
// 		'width' => "15%",
// 		'callback' => 'return file_exists("{$GLOBALS[\'vaxcertbasedir\']}{$this_row[\'esprit_year\']}/{$this_row[\'confirmation_no\']}.jpg") ? "Y" : "";',
// 		'fieldgroup' => 'Master, Badges',
// 		'select' => true];
/*
$fields['has_qr'] = [
		'heading' => 'Has QR',
//		'display' => true,
		'callback' => 'return file_exists($_SERVER["DOCUMENT_ROOT"] . $tpl["qrurl"] . $row["confirmation_no"].".png") ? "Y" : "";',
		'fieldgroup' => 'Master, Badges',
		'select' => true];
*/
	
$fields['entrynum'] = [
'heading' => 'Entry number',
		'primarykey' => true,
		'table' => 'r',
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];
// print_r($fields);
/* End of Field definitions. */

/*	Field group definitions */

if (!$all_years) {	//	Current year

$tpl['fieldgroups'] = [
	'Master' => ['label'=>'Master',
		'url' =>''],
	'Account' => ['label' => 'Account',
		'icon' => '/images/icon-transactions.png',
		'url' => 'taburl.php?template=accounts_detail.tpl',
		'width' => 1800,
		'height' => '700',
		'authgroup' => ['Registrar', 'Desk', 'Admin', 'SigOthers']],
	'Registration' => ['label' => 'Registration',
		'icon' => '/images/icon-checkin.png',
		'url' => 'taburl.php?template=registration_detail.tpl',
		'authgroup' => ['Registrar', 'Desk', 'Admin', 'BSLS', 'Vendor',
			'Presenter', 'SigOthers', 'Scholarships']],
	'Badges' => ['label' => 'Badge',
		'icon' => '/images/icon-badge.png',
		'url' => 'taburl.php?template=badge_detail.tpl',
		'height' => 700,
		'width' => 900,
		'authgroup' => ['Registrar', 'Desk', 'Presenter', 'Admin']],
// 	'Vaxcerts' => ['label' => 'Vax Cert',
// 		'icon' => '/images/icon-badge.png',
// 		'url' => 'taburl.php?template=vaxcert_detail.tpl',
// 		'height' => 700,
// 		'width' => 1000,
// 		'authgroup' => ['Registrar', 'Desk', 'Presenter', 'Admin']],
	'Basic' => ['label' => 'Basic Info',
		'icon' => '/images/icon-home.png',
		'url' => 'taburl.php?template=basic_detail.tpl',
		'authgroup' => ['Registrar', 'Desk', 'Admin', 'BSLS', 'Vendor',
			'Presenter', 'SigOthers', 'Scholarships']],
	'BasicRO' => ['label' => 'Basic Info',
		'icon' => '/images/icon-home.png',
		'url' => 'taburl.php?template=basic_detail.tpl&access=read_only',
		'authgroup' => ['Hotel','Volunteer']],
	'Meals' => ['label' => 'Meals',
		'icon' => '/images/icon-meal.png',
		'url' => 'taburl.php?template=meals_detail.tpl',
		'height' => 700,
		'authgroup' => ['Registrar', 'Desk', 'Presenter', 'Admin']],
	'Volunteers' => ['label' => 'Volunteers',
		'icon' => '/images/icon-meal.png',
		'url' => 'taburl.php?template=volunteer_detail.tpl',
		'height' => 700,
		'width' => 1000,
		'authgroup' => ['Admin','Volunteer']],
	'MealsRO' => ['label' => 'Meals',
		'icon' => '/images/icon-meal.png',
		'url' => 'taburl.php?template=meals_detail.tpl&access=read_only',
		'authgroup' => ['Hotel']],
	'BSLS' => ['label' => 'Big/Little Sisters',
		'icon' => '/images/icon-bigsis.png',
		'url' => 'taburl.php?template=bsls_detail.tpl',
		'authgroup' => ['Registrar', 'Desk', 'Admin', 'BSLS']],
	'Lorem' => ['label' => 'Debug Info',
		'url' => '../lorem.php',
		'width' => 1500,
		'height' => 800,
		'authgroup' => ['Admin']],
	'Utilities' => ['label' => 'Utilities',
		'url' => 'taburl.php?template=utilities_detail.tpl',
		'authgroup' => ['Admin', 'Registrar']],
	'Logs' => ['label' => 'Log Entries',
		'url' => "../log-list.php?tbname={$db['tbnoalias']}",
		'width' => 1500,
		'height' => 800,
		'authgroup' => ['Admin']],
	'Letters' => ['label' => 'Letters',
		'url' =>'../letterssendmailtaburl.php?appname=attendees',
		'width' => 1000,
		'height' => 800,
		'authgroup' => ['Registrar', 'Admin','Vendor', 'Presenter']],
	'EmailLogs' => ['label' => 'Email Logs',
		'url' => 'taburl.php?template=emails.tpl',
		'width' => 1800,
		'height' => 800,
		'authgroup' => ['Admin']],
	'All' => ['label' => 'All Fields',
		'url' => '../allfieldsurl.php?dirname=attendees',
		'authgroup' => ['Admin']],
	'New' => ['label' => 'Create Blank',
		'url' => 'add_new.php',
		'authgroup' => ['Admin']],

];

} else {

	/*
		All-years field groups (all set to read-only)
	*/
	/* Field group definitions */

	$tpl['fieldgroups'] = [
		'Master' => ['label'=>'Master',
			'url' =>''],
		'Account' => ['label' => 'Account/RO',
			'icon' => '/images/icon-transactions.png',
			'url' => 'taburl.php?template=accounts_detail.tpl&access=read_only&all_years=true',
			'width' => 1800,
			'authgroup' => ['Registrar', 'Admin']],
		'Registration' => ['label' => 'Registration',
			'icon' => '/images/icon-checkin.png',
			'url' => 'taburl.php?template=registration_detail.tpl&access=read_only&all_years=true',
			'authgroup' => ['Registrar', 'Desk', 'Admin', 'BSLS', 'Vendor',
				'Presenter', 'SigOthers', 'Scholarships']],
		'Badges' => ['label' => 'Badge',
			'icon' => '/images/icon-badge.png',
			'url' => 'taburl.php?template=badge_detail.tpl&access=read_only&all_years=true',
			'height' => 700,
			'width' => 1000,
			'authgroup' => ['Registrar', 'Admin']],
		'Basic' => ['label' => 'Basic Info',
			'icon' => '/images/icon-home.png',
			'url' => 'taburl.php?template=basic_detail.tpl&access=read_only&all_years=true',
			'authgroup' => ['Registrar', 'Desk', 'Admin', 'BSLS', 'Vendor',
				'Presenter', 'SigOthers', 'Scholarships']],
		'Meals' => ['label' => 'Meals',
			'icon' => '/images/icon-meal.png',
			'url' => 'taburl.php?template=meals_detail.tpl&access=read_only&all_years=true',
			'authgroup' => ['Registrar', 'Desk', 'Presenter', 'Admin']],
		'Volunteers' => ['label' => 'Volunteers',
			'icon' => '/images/icon-meal.png',
			'url' => 'taburl.php?template=volunteer_detail.tpl&access=read_only&all_years=true',
			'height' => 700,
			'width' => 1000,
			'authgroup' => ['Admin','Volunteer']],
		'BSLS' => ['label' => 'Big/Little Sisters',
			'icon' => '/images/icon-bigsis.png',
			'url' => 'taburl.php?template=bsls_detail.tpl&access=read_only&all_years=true',
			'authgroup' => ['Registrar', 'Admin']],
	/*	No Utilities for all-years database.
		'Utilities' => ['label' => 'Utilities', 
			'url' => 'taburl.php?template=utilities_detail.tpl',
			'authgroup' => ['Admin']],
	*/
		'Logs' => ['label' => 'Log Entries',
			'url' => "../log-list.php?tbname={$db['tbnoalias']}",
			'width' => 1500,
			'height' => 800,
			'authgroup' => ['Admin']],
		'Letters' => ['label' => 'Letters',
			'url' =>'../letterssendmailtaburl.php?appname=attendeesall&access=read_only&all_years=true',
			'width' => 1000,
			'height' => 800,
			'authgroup' => ['Registrar', 'Admin','Vendor', 'Presenter']],
		'EmailLogs' => ['label' => 'Email Logs',
			'url' => 'taburl.php?template=emails.tpl&access=read_only&all_years=true',
			'width' => 1800,
			'height' => 800,
			'authgroup' => ['Admin']],
		'Copy' => ['label' => 'Copy to Current Year',
			'url' => 'copy_to_current.php?all_years=true',
			'authgroup' => ['Registrar', 'Admin', 'Presenter', 'Vendor']],
		'All' => ['label' => 'All Fields',
		'url' => '../allfieldsurl.php?dirname=attendees&all_years=true',
		'authgroup' => ['Admin']]

	];
}

?>
