<?php
/*
	Sets up and displays the "Copy to Current" tab for the Attendees
	susbystem. Only appears in the attendeesall screen (All Years Attendees).
	
	Stephanie Mitchell, 4 April, 2023
*/
/*
	See if logged in via Quadodo
*/

global $tpl;
define('QUADODO_IN_SYSTEM', true);
$dirname = dirname(__FILE__);
$basename = dirname($dirname);

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once "mysql_utilities.php";
require_once "header.php";
require_once ".config.php";
require_once "setup.php";
require_once "fieldlist.php";
require_once "template_options.php";
require_once "qrmake_attendee_fn.php";
require_once "generate_confirmation.php";
$tpl['authgroup'] = $qls->group_id_to_name($qls->user_info['group_id']);
$tpl['username'] = $qls->user_info['username'];
if ($tpl['username'] == '') {
	header('Location: ../qls/login.php');
	exit;
}

$primarykeyfieldvalue = $_REQUEST['pkfv'];
$primarykeyfieldname = $_REQUEST['pkfn'];
$group = $_REQUEST['group'];
$all_years = $_REQUEST['all_years'] ?? '';
$mydata = get_mysql_fields('Registration', $fields, $primarykeyfieldname, $primarykeyfieldvalue, 'regall r', '', $all_years);
/*	Capture old confirmation number and Esprit year for use in updates */
$oldconfirmation = $mydata['confirmation_no'];
$oldesprit_year = $mydata['esprit_year'];

/*	Force a distinctive first name to identify the new record and tweak certain
	fields to current year, pre-registered and such. */

$mydata['firstnamepref'] .= ' (NEW)';
$mydata['esprit_year'] = $esprit_year;
$mydata['confirmation_no'] = generate_confirmation();	// New number required
$mydata['badge_code'] = generate_badge_code();	// New code required
$mydata['reg_status'] = 'Pre-registered';
$mydata['checkinvalid'] = $GLOBALS['esprit_start_mysql'];

/*	Set unset meals to zero, others to allotted meals. */

foreach (['meal2', 'meal2checked', 'meal3', 'meal3checked', 'meal4', 'meal4checked', 'meal5', 'meal5checked', 'meal6', 'meal6checked'] as $thing) {
	if (is_null($mydata[$thing])) {
		$mydata[$thing] = 0;
	}
}

/*	Set unset day attendance to zero. */

foreach (['daysun1', 'daymon', 'daytue', 'daywed', 'daythu', 'dayfri', 'daysat', 'daysun2'] as $thing) {
	if (is_null($mydata[$thing])) {
		$mydata[$thing] = 0;
	}
}

$newconfirmation = $mydata['confirmation_no'];	//	Keep for updates
unset($mydata['timestamp']);	//	MySQL inserts this automatically
unset($mydata['updatetime']);	//	MySQL inserts this automatically
unset($mydata['checkindate']);	//	Null because new record can't have checked in yet
mysql_login('Normal');

// insert the new record and get the new auto_increment id
$sql = "INSERT INTO regall (`{$primarykeyfieldname}`) VALUES (NULL)";
$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on insert while copying attendee to current year: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to insert new record while copying attendee to current year - sorry!');

$newid = mysqli_insert_id($GLOBALS['dbConnect']);
$mydata[$primarykeyfieldname] = $newid;

/*
	Generate the query to update the new record with the previous values.
*/

$sql = "UPDATE regall SET ";
foreach ($mydata as $key => $value) {
	if ($key != $primarykeyfieldname) {
		if (isset($fields[$key]['copyValue'])) {
			$sql .= '`'.$key.'` = "'.str_replace('"','\"',$fields[$key]['copyValue']).'", ';
		} else {
			$sql .= '`'.$key.'` = "'.str_replace('"','\"',$value).'", ';
		}
	}
} 

qrmake_attendee($mydata['confirmation_no'], $mydata['badge_code']);

$sql = substr($sql, 0, strlen($sql)-2); // lop off extra trailing comma
$sql .= " WHERE {$primarykeyfieldname}={$newid}";
$sql_escaped = $sql; // mysqli_real_escape_string($GLOBALS['dbConnect'], $sql);
$result = mysqli_query($GLOBALS['dbConnect'], $sql_escaped) or SM_Die('Database error on update while copying attendee to current year: ' . mysqli_error($GLOBALS['dbConnect']) . ". Query=$sql_escaped", 'Unable to update information while copying attendee to current year - sorry!');

/*
	Now copy transactions, except for payments. Excursions and merch will have to
	be re-entered.
*/
$sqltrans = "INSERT INTO regpayment (TIMESTAMP, username, authgroup, transtype, reference, source,
		pnotes, confirmation, amount, receipt_no, receipt_printed, addon_key)
	SELECT now(), '{$tpl['username']}', '{$tpl['authgroup']}', transtype, $newconfirmation, IF(source LIKE '%(via copy)%',
		source, concat(source, ' (via balance forward)')),
		REPLACE(pnotes,$oldconfirmation,$newconfirmation), $newconfirmation,
		amount, receipt_no, receipt_printed, addon_key
	FROM regpayment
	WHERE confirmation=$oldconfirmation
		AND transtype='Registration'
		AND pnotes LIKE concat('%',$oldconfirmation,'%')";
$sqltrans_escaped = mysqli_real_escape_string($GLOBALS['dbConnect'], $sqltrans);

// print "Test transaction insert: $sqltrans<br />Escaped version: $sqltrans_escaped"; exit;
$result = mysqli_query($GLOBALS['dbConnect'], $sqltrans) or SM_Die('Database error while copying transactions for attendee while copying to current year: ' . mysqli_error($GLOBALS['dbConnect']) . ". Query=$sqltrans_escaped", 'Unable to copy transactions while copying attendee to current year - sorry!');

/*
	Now copy badge photo, if any,
*/
$oldbadgephoto = "{$GLOBALS['badgephotobasedir']}$oldesprit_year/{$oldconfirmation}.jpg";
$newbadgephoto = "{$GLOBALS['badgephotobasedir']}$esprit_year/{$newconfirmation}.jpg";
if (file_exists($oldbadgephoto)) {
	copy($oldbadgephoto, $newbadgephoto);
}

Make_Log_Entry($GLOBALS['dbConnect'], "NEW ATTENDEE ADDED VIA COPY TO CURRENT: $sql_escaped<br />TRANSACTIONS COPIED: $sqltrans_escaped");
mysql_logout();	//	Disconnect from database

$e = new Smarty_Esprit;
$e->addPluginsDir("{$_SERVER['DOCUMENT_ROOT']}/plugins/");
$e->registerPlugin("modifier","ss", "stripslashes");
$e->assign('mydata',$mydata);
// print_r($tpl);
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/templates/");
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/$dirname/templates/");
$e->display('basic_detail.tpl');

?>
