<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /manager/help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

/* MySQL table names */

$db['tb'] = 'regaddonshistory r';
$db['tbnoalias'] = 'regaddonshistory';
global $opts;
$opts['join_clause'] = '';

/* Field definitions start here */

$fields['action'] = array(
		'heading' => "Database Action",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'filter' => "");
$fields['revision'] = array(
		'heading' => "Revision",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'filter' => "");
$fields['dt_datetime'] = array(
		'heading' => "Change Time",
		'table' => 'r',
		'display' => true,
		'fieldgroup' => '*, Master',
		'format' => '%d%b%Y %T',
		'filter' => "");
$fields['addon_id'] = array(
		'heading' => "Item ID",
		'table' => 'r',
		'display' => true,
		'width' => "5%",
		'fieldgroup' => 'Master,*',
		'primarykey' => true,
		'filter' => "");
$fields['addon_type'] = array(
		'heading' => "Item Type",
		'table' => 'r',
		'display' => true,
		'width' => "8%",
		'fieldgroup' => '*, Master',
		'arrayedit' => true,
		'filter' => "");
$fields['addon_name'] = array(
		'heading' => "Item Name",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'fieldgroup' => '*, Master',
		'arrayedit' => true,
		'filter' => "");
$fields['addon_desc'] = array(
		'heading' => "Description",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'widget' => 'ckeditor',
		'fieldgroup' => '*',
		'filter' => "");
$fields['addon_desc_link'] = array(
		'heading' => "Item Link",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => '*',
		'filter' => "");
$fields['addon_price'] = array(
		'heading' => "Unit Price",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => 'Master,*',
		'filter' => "");
$fields['addon_stocklimit'] = array(
		'heading' => "Stock Limit",
		'table' => 'r',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => 'Master,*',
		'filter' => "");
$fields['addon_show'] = array(
		'heading' => "Show On Forms",
		'table' => 'r',
		'display' => true,
		'width' => '20%',
		'arrayedit' => true,
		'fieldgroup' => 'Master,*',
		'filter' => "");
$fields['addon_postprocess'] = array(
		'heading' => "Postprocess function",
		'table' => 'r',
		'display' => true,
		'arrayedit' => true,
		'fieldgroup' => 'Master,*',
		'filter' => "");

/* End of Field definitions. */

/* Field group definitions */

$tpl['fieldgroups'] = array(
/*	'Blank' => array('label' => '>',
		'url' => 'blank.php'), */
/*	No tabs except All Fields for History.
	'Master' => array('label'=>'Master',
		'url' =>''),
	'Detail' => array('label' => 'Details',
		'url' => 'taburl.php?template=addons_detail.tpl',
		'authgroup' => array('Admin')),
	'AddNew' => array('label' => 'Copy',
		'url' => 'add.php',
		'authgroup' => array('Admin'),
		'scroll' => 'No'	//	Prevent scrolling to this screen
	),
	'DeleteThis' => array('label' => 'Delete',
		'url' => 'delete.php',
		'authgroup' => array('Admin'),
		'scroll' => 'No'	//	Prevent scrolling to this screen
	),
*/
	'All' => array('label' => 'All Fields',
		'url' => '../allfieldsurl.php?dirname=addonshistory',
		'authgroup' => array('Admin')
		)
);

?>