<?php
/*
	Esprit Registration System
	by Stephanie Mitchell
	Significant Others Attendee Registration Form
	8 May, 2015.
*/

define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
if (TESTING) {	// TESTING constant is set in config.php
	$today_text = (isset($_REQUEST['date']) ? $_REQUEST['date'] : 'now');
	$test_msg = 'TEST';
} else {
 	$today_text = 'now';
 	$test_msg = '';
}

$password = $_REQUEST['password'] ?? false;
$primary_email = $_REQUEST['email'] ?? '';
$primary_conf = $_REQUEST['conf'] ?? '';
$form_type = "SO";	//	MUST match one of the rate groups in config.php
						//	(Single, SO etc.)
require_once "classes.php";	//	Pull in everything
?>
<html>
<?php
	require_once "head.php";
?>
<!-- Enable SO fields -->
<script type="text/javascript">
jQuery(document).ready(function(){	//	Enable SO-specific fields which were
									//	disabled by head.php above
	alwaysshow('.so-specific', 'SO');
})</script>
<body>
<?php
if ($check['preregistration_closed']) {
	print closed($form_type, $date_text['registration_closed']);
	exit;
}
if ($check['registration_not_yet_open']) {
	print notyetopen($form_type, $date_text['registration_open']);
	exit;
}
print masthead('Significant Others');
?>
<div class="section">
	<div class="headerbar">Instructions</div>
	<ol>
		<li>This form is only for pre-registering the Significant Other or Partner of an attendee who has already pre-registered. To select a different form, please <a href="../index.php">return to Registration Start</a>.</li>
		<li>Each person attending Esprit MUST BE REGISTERED.</li>
		<li> <span class="reqd reqdhilite">Fields highlighted like this</span> are required.</li>
		<li><span class="i">Note that pre-registering does not obligate you to pay or attend nor are you guaranteed a space at Esprit or any hotel.</span></li>
		<li>Click Submit at the bottom. Your official Registration Letter will arrive via email shortly.</li>
		<?php
		if ($today < $date['payment_deadline']) {
			print "<li>Our mailing address is:<br />
				<br /> $esprit_address<br />
				<br />
				</li>";
		}?>
		<li> We urge you to refer to these Help buttons<?php print helpbutton('helpbuttonhelp.php');?> for lots of useful information and guidance.</li>
	</ol>
	<p class="tiny">All information is kept strictly confidential.</p>
</div>
<form action="../process.php" method="post" enctype="multipart/form-data" name="form1" id="formID">

<?php
// print form_switches(array('SO-specific'));	//	Not needed in this form
print esprit_names(array('SO-specific'));
print attendwith($form_type, $primary_email, $primary_conf, $_REQUEST['date']);
require_once "bill_contact.php";

/*
	Create the rate tables for each selected type.
*/
$rates = new ratetable;
print $rates->preamble($form_type);
print '<table width="100%">
	<tr>';
print '<td>' . $rates->table('reg', $form_type, 'You (the SO)') . '</td>';
print '</tr></table>';
print $rates->postamble();

/*
	Add-ons
*/
print other_purchases($form_type);

/*
	Create the volunteer signup section.
*/
$volunteer = new volunteer;
print $volunteer->preamble($form_type);
print "<a onclick=\"$('.vo').toggle()\" > Click here</a> to see the opportunities we have for you!</p>";
print '<div class="vo">';
print '<table width="100%">
	<tr>';
print '<td>' . $volunteer->table('reg', $form_type, 'You') . '</td>';
print '</tr></table>';
print $volunteer->postamble();
print '</div>';

/*
	Gather the badge photo(s).
*/
$badge = new badgephoto;
print $badge->preamble($form_type);	//	Preamble
print '<table width="100%">
	<tr>';
print '<td>' . $badge->table('reg', $form_type, 'You (the SO)') . '</td>';
print '</tr></table>';
print $badge->postamble();	//	Postamble

/*
	Gather the vax certificates.
*/
$vaxcert = new vaxcertificate;
print $vaxcert->preamble($form_type);	//	Preamble
print '<table width="100%">
	<tr>';
print '<td>' . $vaxcert->table('reg', $form_type, 'You (the SO)') . '</td>';
print '</tr></table>';
print $vaxcert->postamble();	//	Postamble

/*
	The fine print section
*/

require_once "fine_print.php";

?>
<div><!-- Hidden fields required by this form, plus form submit button -->	
	<input type="hidden" name="noupload[source_form_type]" testdata="no" id="source_form_type" value="SO" />
	<input type="hidden" name="password" id="password" value="<?php print $password;?>" />

	<input type="submit" id="postbut" name="Submit Pre-Registration" value="Submit Pre-Registration" />
</div>
</form>
</body>
</html>
