<?php
/*
	Check checklist, make sure it's not blacklisted and not restricted to a
	specific form type.
*/

/* Get value to check */
$validateValue=trim($_REQUEST['fieldValue']);
$validateId=$_REQUEST['fieldId'];
$validateValueUC=strtoupper($validateValue);

/*	Form type is appended to $validateId. Extract it. */
$f_type = ((strpos($validateId, '[') == 0) ? '' :
	substr($validateId, 0, strpos($validateId, '[')));
$restricted_forms = array('Committee_Full', 'Committee_Partial');

/* Compile result array */
$arrayToJs = array();
$arrayToJs[0] = $validateId;
$arrayToJs[1] = true;
	
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'blacklist.php';
require_once 'mysql_utilities.php';

mysql_login('Read-only');

/*	Following SELECT handles wildcard "*" in checklist by replacing them with MySQL's "%" wildcard */
$sqlcmd = "SELECT email, category
FROM regcontrol
WHERE \"$validateValueUC\" LIKE (REPLACE(UPPER(TRIM(email)), '*', '%'))";

$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(mysqli_error($GLOBALS['dbConnect']) . ": didn't work");

$categories = '';
while ($row = mysqli_fetch_assoc($result)) {	//	Did we get a result?
	$categories[] = $row['category'];	//	Gather all categories (could belong
										//	to more than one)
}
if ($categories == '') {	//	Any result at all?
	//	No (no result at all.) Are we in a restricted form?
	if (in_array($f_type, $restricted_forms)) {
		//	Yes - return failure
		$arrayToJs[1] = false;	//	We are and shouldn't be
		$arrayToJs[2] = "This form is restricted.";
	} else {
		//	No - return success
		$arrayToJs[1] = true;	//	We are and should be
		$arrayToJs[2] = "";
	}
} else {
	//	Wwe have at result. Are we blacklisted?
	if (in_array('Blacklist', $categories)) {
		//	Yes - return failure
		$arrayToJs[1] = false;			//	Return fail
		$arrayToJs[2] = 'Registration DECLINED. Please contact registrar@espritconf.com for assistance.';
	} else {
		//	No - Are we in a restricted form?
		if (in_array($f_type, $restricted_forms)) {
			//	Yes - Can we use it? (does form type match at least one of
			//	our entries?)
			if (in_array($f_type, $categories)) {
				//	Yes - return success
				$arrayToJs[1] = true;
				$arrayToJs[2] = "";
			} else {
				//	No - return failure
				$arrayToJs[1] = false;
				$arrayToJs[2] = "This form is restricted.";
			}
		} else {
			//	No - not restricted, but does it match at least one of our
			//	form types?
			if (in_array($f_type, $categories)) {
				//	Yes - return success
				$arrayToJs[1] = true;
				$arrayToJs[2] = "";
			} else {
				//	No - return failure
				$arrayToJs[1] = false;
				$arrayToJs[2] = "You're using the wrong form. Please use one of " . implode(', ', $categories) . ".";
			}
		}
	}
}

echo json_encode($arrayToJs);		// RETURN ARRAY
?>