<?php

/**
 * Jcrop image cropping plugin for jQuery, adapted for Esprit Registration.
 * Example cropping script
 * @copyright 2008-2009 Kelly Hallman
 * More info: http://deepliquid.com/content/Jcrop_Implementation_Theory.html
 */

	/*
		See if logged in via Quadodo
	*/

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";

	define('QUADODO_IN_SYSTEM', true);
	require_once "header.php";
	$tpl['authgroup'] = $qls->group_id_to_name($qls->user_info['group_id']);
	$tpl['username'] = $qls->user_info['username'];
	if ($tpl['username'] == '') {
		header('Location: /qls/login.php');
		exit;
	}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {	// Action when crop form submitted

	$src_x = round($_REQUEST['x']);	//	Top left 39
	$src_y = round($_REQUEST['y']);	//	Top left 12
	$src_h = round($_REQUEST['h']);	//	Height 39
	$src_w = round($_REQUEST['w']);	//	Width 12
	
	switch ($_REQUEST['format']) {
	case 'badge':					// Specific dimensions for badges
		$targ_w = 162 * 2.083;		// 2.083 converts 72dpi pixels to 150dpi print
		$targ_h = 210 * 2.083;		// These images are 2x size for better quality
		$jpeg_quality = 90;
		break;
	case 'ppbgimg':					// Specific dimensions for slide backgrounds
		$targ_w = 1920;				// Full HD size
		$targ_h = 1080;
		$jpeg_quality = 90;
		break;
	case 'ticketimg':				// Specific dimensions for ticket images
		$targ_w = 150;				// 1" x 1.4" at 150dpi
		$targ_h = 210;
		$jpeg_quality = 90;
		break;
	case 'ticketbgimg':				// Specific dimensions for ticket backgrounds
		$targ_w = 900;				// 6" x 2" ticket background at 150dpi
		$targ_h = 300;
		$jpeg_quality = 90;
		break;
	case 'vaxcert':					// Specific dimensions for vax certs
		$targ_w = 300;				// Screen image size, hard-coded in
									//	attendees/templates/vaxcert_detail.php
		$ratio = $src_h / $src_w;	//	Aspect ratio
		$targ_h = $targ_w * $ratio;	//	Fixed width, variable height
		$jpeg_quality = 90;
		break;
	default:						// Other formats as is
		$targ_w = $src_w;
		$targ_h = $src_h;
		$jpeg_quality = 90;
	}

	$conf_no = $_REQUEST['conf_no'];
	$dr_src = $_SERVER['DOCUMENT_ROOT'] . $_REQUEST['src'];
	$imgformat = strtolower(strrchr($dr_src, '.'));		//	File extension
	switch ($imgformat) {
	case '.jpg':
		$img_r = imagecreatefromjpeg($dr_src);
		break;
	case '.png':
		$img_r = imagecreatefrompng($dr_src);
		break;
	case '.gif':
		$img_r = imagecreatefromgif($dr_src);
		break;
	default:
		die("Invalid image format $imgformat in $dr_src");
	}
	
	$dst_r = imagecreatetruecolor($targ_w, $targ_h);

	imagecopyresampled($dst_r, $img_r, 0, 0, $src_x, $src_y, round($targ_w), round($targ_h), round($_REQUEST['w']), round($_REQUEST['h']));

	switch ($imgformat) {
	case '.jpg':
		imagejpeg($dst_r, $dr_src, $jpeg_quality);
		break;
	case '.png':
		imagepng($dst_r, $dr_src);
		break;
	case '.gif':
		imagegif($dst_r, $dr_src);
		break;
	default:
		die("Invalid output image format $imgformat in $dr_src");
	}
	exit;
}

// If not a POST request, display page below:
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<script type="text/javascript" src="/lib/js/jquery.js"></script>
<script src="/lib/js/jcrop/js/jquery.Jcrop.js"></script>
<link rel="stylesheet" href="/css/jquery.Jcrop.min.css" type="text/css" />
<link rel="stylesheet" href="/css/styles.css" type="text/css" />

</head>
<body style="background-color: #404040; color: #FFFFFF">
<h1>Crop Image</h1>
<p><b>Drag within the image to crop to the desired size.</b></p>
<p style="color:red; font-weight:bold"> NOTE! Cropping this image replaces the original
one! There is NO UNDO; you cannot return to the previous uncropped version.
Please be careful.</p>
<!-- This is the image we're attaching Jcrop to -->
<?php
	$src = $_REQUEST['src'];
	$conf_no = $_REQUEST['conf_no'];
	$fmt = $_REQUEST['format'];
	if (!in_array($fmt, ['badge', 'ppbgimg', 'ppimg', 'ticketbgimg', 'ticketimg', 'vaxcert'])) {
		print "Invalid image format '$fmt' passed for cropping";
		exit;
	}
	$r = time();
	//	Display the image
	print "<img src=\"$src?r=$r\" id=\"$fmt\" valign=\"top\" />";
?>
<!-- This is the form that our event handler fills -->
<br />
<form accept-charset="utf-8" action="imagecrop.php" method="POST" onsubmit="return checkCoords();">
	<input id="x" type="hidden" name="x" />
	<input id="y" type="hidden" name="y" />
	<input id="w" type="hidden" name="w" />
	<input id="h" type="hidden" name="h" />
	<input id="format" type="hidden" name="format" value="<?php print $fmt;?>">
	<input id="src" type="hidden" name="src" value="<?php print $src; ?>">
	<input id="conf_no" type="hidden" name="conf_no" value="<?php print $conf_no; ?>">
	<br />
	<input type="submit" value="Crop Image" />
</form>
<script language="Javascript">

$( document ).ready(function() {
	$(function(){

		$('#badge').Jcrop({
			aspectRatio: 81/105,	// Fixed for badge photos
			onSelect: updateCoords
		});
		
		$('#ppimg').Jcrop({			// arbitrary aspect ratio
			onSelect: updateCoords
		});

		$('#ppbgimg').Jcrop({
			aspectRatio: 1920/1080,	// Fixed for slide backgrounds
									// (9" x 7")
			onSelect: updateCoords
		});
		$('#ticketimg').Jcrop({			//	arbitrary aspect ratio
			onSelect: updateCoords		//	for ticket images
		});

		$('#ticketbgimg').Jcrop({
			aspectRatio: 900/300,	// Fixed for ticket backgrounds
									// (6" x 2")
			onSelect: updateCoords
		});
		$('#vaxcert').Jcrop({		//	Arbitrary aspect ratio for Vax certificates,
									//	as they can be any shape
			onSelect: updateCoords
		});

	});
});

	function updateCoords(c)
	{
		$('#x').val(c.x);
		$('#y').val(c.y);
		$('#w').val(c.w);
		$('#h').val(c.h);
	};

	function checkCoords()
	{
		if (parseInt($('#w').val())) {
			return true;
		}
		alert('Please select a crop region then press submit.');
		return false;
	};
</script>
</body>
</html>
