<?php
/*
	This validator checks the supplied confirmation number and email address
	pair to make sure it has one of the specified role flags (currently
	presenter or vendor). The flag to be checked is in the "flag" parameter of
	the URL: flag=Presenter or flag=Vendor. The corresponding email is in the
	extraDataDynamic parameter, in this case, "Verify_email".
	
	It also checks against the blacklist. it returns success only if the email
	is not blacklisted and is registered as one of the provided types.
*/

//	ini_set('display_startup_errors',1);
//	ini_set('display_errors',1);
//	error_reporting(-1);		//	All errors

/* Get value to check */
$validateValue = trim($_REQUEST['fieldValue'] ?? 'undefined fieldValue');
$validateValueUC = strtoupper($validateValue);
$validateId = $_REQUEST['fieldId'] ?? 'undefined fieldId';
$flag_to_check = $_REQUEST['flag'] ?? '';
$email_to_check = $_REQUEST['noupload__Verify_email'] ?? '';
if (strtoupper($flag_to_check) == "PRESENTER") {
	$flagname = "is_presenter";
} elseif (strtoupper($flag_to_check) == "VENDOR") {
	$flagname = "is_vendor";
}

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'blacklist.php';
require_once 'mysql_utilities.php';

mysql_login('Read-only');

/*	Check to see if on blacklist */
if (blacklist($email_to_check)) {	/*	Blacklisted? */
	echo json_encode(array($validateId, false,'Registration DECLINED. Please contact registrar@espritgala.org for assistance.'));

} else {		//	Not blacklisted, do further checks.
	//	Does this email/confirmation number have the specified flag turned on?
	$sqlcmd = "SELECT email, confirmation_no, $flagname FROM reg
		WHERE email = \"$email_to_check\"
		AND (UPPER(TRIM($flagname)) = 'YES'
			OR $flagname = 1)
		AND confirmation_no = \"$validateValue\"";


	$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(mysqli_error($GLOBALS['dbConnect']) . ": didn't work");

	$not_found = (@mysqli_num_rows($result) == 0);	//	if no matching record is
												//	found, flag is not on
	if ($not_found) {
		echo json_encode(array($validateId, false,"This must be the email and confirmation number of an already registered {$flag_to_check}. Sql='$sqlcmd'"));

	} else {	//	Made it through all the checks
		echo json_encode(array($validateId, true,''));
	}	
}
mysql_logout();	//	Disconnect from database

?>