(function($){
    $.fn.validationEngineLanguage = function(){
    };
    $.validationEngineLanguage = {
        newLang: function(){
            $.validationEngineLanguage.allRules = {
                "required": { // Add your regex rules here, you can take telephone as an example
                    "regex": "none",
                    "alertText": "* This field is required",
                    "alertTextCheckboxMultiple": "* Please select an option",
                    "alertTextCheckboxe": "* This checkbox is required",
                    "alertTextDateRange": "* Both date range fields are required"
                },
                "requiredInFunction": { 
                    "func": function(field, rules, i, options){
                        return (field.val() == "test") ? true : false;
                    },
                    "alertText": "* Field must equal test"
                },
                "postalzip": {
				//	Matches US or Canadian zip codes in the following formats:
				//		99999			US 5-digit zip
				//		99999-9999		US 5-4 digit zip
				//		A9A 9A9			Canadian postal (uppercase, restricted
				//						first letters and optional space
				//						between groups)
               	"regex": /^(^\d{5}(-\d{4})?$)|(^[ABCEGHJKLMNPRSTVXY]{1}\d{1}[A-Z]{1} *\d{1}[A-Z]{1}\d{1}$)/,
                    "alertText": "* Invalid US zip or Canadian postal code"
				},
/*
	Validators for email addresses entered on various forms
*/
				"Checked_in": {	//	Ajax call to see if person is checked in
								//	Not used for registration, but required for
								//	validating who can use the Filedrop page
								//	(only people who were actually at Esprit can
								//	submit materials through it)
					"url":			"../lib/validators/checkin.php",
// 					"extraData": "type=Assistant",
 					"alertText": "** You do not appear to have been at Esprit. **",
//					"alertTextOk": "Assistant!",
 					"alertTextLoad": "* Validating, please wait"
				},

				"Assistant": {	//	Ajax call to check who can have an assistant
					"url":			"../lib/validators/notcommitteelist.php",
 					"extraData": "type=Assistant",
					"extraDataDynamic": ['#Assistant__firstnamepref', '#Assistant__lastnamepref', '#Assistant__email'],	//	check all types
 					"alertText": "** Confirmation number and email do not correspond **",
//					"alertTextOk": "Assistant!",
 					"alertTextLoad": "* Validating, please wait"
				},

				"Committee_Any": {	//	Ajax call to check if person is on any
				//	committee list. NOTE that URL is one directory level OUT
				//	from the others, as this is called from a top-level page,
				//	unlike the others.
					"url":			"/lib/validators/committeelist.php",
					"alertText":	"Committee check",
 					"extraData": "type=Committee",
 					"alertTextLoad": "* Validating, please wait..."
				},

				"Committee_Full": {	//	Ajax call to check if person is on committee_Full list
					"url":			"../lib/validators/committeelist.php",
					"alertText":	"Committee_Full check",
 					"extraData": "type=Committee_Full",
					"extraDataDynamic": ['#Committee_Full__firstnamepref', '#Committee_Full__lastnamepref', '#Committee_Full__email'],	//	check all types
 					"alertTextLoad": "* Validating, please wait"
				},

				"Committee_Partial": {	//	Ajax call to check if person is on committee_Partial list
					"url":			"../lib/validators/committeelist.php",
					"alertText":	"Committee_Partial check",
 					"extraData": "type=Committee_Partial",
					"extraDataDynamic": ['#Committee_Partial__firstnamepref', '#Committee_Partial__lastnamepref', '#Committee_Partial__email'],	//	check all types
 					"alertTextLoad": "* Validating, please wait"
				},

				"Single": {	//	Ajax call to check if person is NOT on committee_Full list
					"url":			"../lib/validators/notcommitteelist.php",
					"alertText":	"Single check",
 					"extraData": "type=Single",
					"extraDataDynamic": ['#Single__firstnamepref', '#Single__lastnamepref', '#Single__email'],	//	check all types
 					"alertTextLoad": "* Validating, please wait"
				},

				"Single_Dup": {	//	Ajax call to check if Single person is a duplicate
					"url":			"../lib/validators/duplicatereg.php",
					"alertText":	"Single duplicate check",
 					"extraData": "type=Single",
					"extraDataDynamic": ['#Single__firstnamepref', '#Single__lastnamepref', '#Single__email'],	//	check all types
 					"alertTextLoad": "* Validating duplication, please wait"
				},

				"SO": {	//	Ajax call to check if person is NOT on committee_Full list
					"url":			"../lib/validators/notcommitteelist.php",
					"alertText":	"SO check",
 					"extraData": "type=SO",
					"extraDataDynamic": ['#SO__firstnamepref', '#SO__lastnamepref', '#SO__email'],	//	check all types
 					"alertTextLoad": "* Validating, please wait"
				},

				"Guest": {	//	Ajax call to check if person is NOT on committee_Full list
					"url":			"../lib/validators/notcommitteelist.php",
					"alertText":	"Guest check",
 					"extraData": "type=Guest",
					"extraDataDynamic": ['#Guest__firstnamepref', '#Guest__lastnamepref', '#Guest__email'],	//	check all types
 					"alertTextLoad": "* Validating, please wait"
				},

				"Volunteer": {	//	Ajax call to check if person is NOT on committee_Full list
					"url":			"../lib/validators/notcommitteelist.php",
					"alertText":	"Volunteer check",
 					"extraData": "type=Volunteer",
					"extraDataDynamic": ['#Volunteer__firstnamepref', '#Volunteer__lastnamepref', '#Volunteer__email'],	//	check all types
 					"alertTextLoad": "* Validating, please wait"
				},

				"Observer": {	//	Ajax call to check if person is NOT on committee_Full list
					"url":			"../lib/validators/notcommitteelist.php",
					"alertText":	"Observer check",
 					"extraData": "type=Observer",
					"extraDataDynamic": ['#Observer__firstnamepref', '#Observer__lastnamepref', '#Guest__email'],	//	check all types
 					"alertTextLoad": "* Validating, please wait"
				},

				"Resource_Presenter": {	//	Ajax call to check if person is NOT on committee_Full list
					"url":			"../lib/validators/notcommitteelist.php",
					"alertText":	"Resource_Presenter check",
 					"extraData": "type=Resource_Presenter",
					"extraDataDynamic": ['#Resource_Presenter__firstnamepref', '#Resource_Presenter__lastnamepref', '#Resource_Presenter__email'],	//	check all types
 					"alertTextLoad": "* Validating, please wait"
				},

				"Resource_Vendor": {	//	Ajax call to check if person is NOT on committee_Full list
					"url":			"../lib/validators/notcommitteelist.php",
					"alertText":	"Resource_Vendor check",
 					"extraData": "type=Resource_Vendor",
					"extraDataDynamic": ['#Resource_Vendor__firstnamepref', '#Resource_Vendor__lastnamepref', '#Resource_Vendor__email'],	//	check all types
 					"alertTextLoad": "* Validating, please wait"
				},

				"Add_Family": {	//	Ajax call to check if person is NOT on committee_Full list
					"url":			"../lib/validators/notcommitteelist.php",
					"alertText":	"Add_Family check",
 					"extraData": "type=Add_Family",
 					"extraDataDynamic": ['#Add_Family__firstnamepref', '#Add_Family__lastnamepref', '#Add_Family__email'],	//	check all types
					"alertTextLoad": "* Validating, please wait"
				},

				"add_SO": {	//	Ajax call to see if SO can be added to this person
					"url":			"../lib/validators/attendwith.php",
					"alertText":	"SO check",
 					"extraData": 'type=SO&list=("Single","Committee_Full","Committee_Partial","Resource_Presenter","Resource_Vendor")&limit=1',
  					"extraDataDynamic": ['#With__relto_email'], 
					"alertTextLoad": "* Validating, please wait"
				},

				"add_Add_Family": {	//	Ajax call to see if Additional Family can be added to this person. Note there is no limit on how many Add_Family records can be added.
					"url":			"../lib/validators/attendwith.php",
					"alertText":	"Add_Family check",
 					"extraData": 'type=Add_Family&list=("Single","Committee_Full","Committee_Partial","Resource_Presenter","Resource_Vendor")',
  					"extraDataDynamic": ['#With__relto_email'], 
 					"alertTextLoad": "* Validating, please wait"
				},

				"add_Assistant": {	//	Ajax call to see if SO can be added to this person
					"url":			"../lib/validators/attendwith.php",
					"alertText":	"Assistant check",
 					"extraData": 'type=Assistant&list=("Committee_Full","Committee_Partial","Resource_Presenter","Resource_Vendor")&limit=1',
  					"extraDataDynamic": ['#With__relto_email'], 
					"alertTextLoad": "* Validating, please wait"
				},

				"add_Guest": {	//	Ajax call to see if Guest can be added to this person
					"url":			"../lib/validators/attendwith.php",
					"alertText":	"Guest check",
 					"extraData": 'type=Guest&list=("Committee_Full","Committee_Partial")',
  					"extraDataDynamic": ['#With__relto_email'], 
					"alertTextLoad": "* Validating, please wait"
				},

				"add_Observer": {	//	Ajax call to see if Observer can be added to this person
					"url":			"../lib/validators/attendwith.php",
					"alertText":	"Observer check",
 					"extraData": 'type=Observer&list=("Committee_Full","Committee_Partial")',
  					"extraDataDynamic": ['#With__relto_email'], 
					"alertTextLoad": "* Validating, please wait"
				},

				"add_Volunteer": {	//	Ajax call to see if Volunteer can be added to this person
					"url":			"../lib/validators/attendwith.php",
					"alertText":	"Volunteer check",
 					"extraData": 'type=Volunteer&list=("Committee_Full","Committee_Partial")',
  					"extraDataDynamic": ['#With__relto_email'], 
					"alertTextLoad": "* Validating, please wait"
				},

				"Committee": {	//	Ajax call to check if person is on committee
					"url": "../lib/validators/committeelist.php",
					"extraData": "type=Assistant",
					"extraDataDynamic": ['#With__relto_email'],
					"alertText": "** Confirmation number and email do not correspond **",
					"alertTextLoad": "* Validating, please wait"
				},

				"checklist": {	//	Ajax call to check checklist
					"url": "../lib/validators/checklist.php",
					"alertText": "** Registration declined **",
//					"alertTextOk": "All good!",
					"alertTextLoad": "* Validating, please wait"
				},
				"checkPresenterList": {	//	Ajax call to check presenter list
					"url": "../lib/validators/flagged.php",
					"extraData": 'flag=Presenter',
					"extraDataDynamic": ['#noupload__Verify_email'],
					"alertText": "** Registration declined **",
//					"alertTextOk": "All good!",
					"alertTextLoad": "* Validating, please wait"
				},
				"checkVendorList": {	//	Ajax call to check vendor list
					"url": "../lib/validators/flagged.php",
					"extraData": 'flag=Vendor',
					"extraDataDynamic": ['#noupload__Verify_email'],
					"alertText": "** Registration declined **",
//					"alertTextOk": "All good!",
					"alertTextLoad": "* Validating, please wait"
				},
				"Scholarship": {	//	Ajax call to check list of types who can
									//	apply for a scholarship
					"url": "../lib/validators/scholarship.php",
					"extraData": "type=Assistant",
					"extraDataDynamic": ['#With__relto_email'],
					"alertText": "** Registration declined **",
//					"alertTextOk": "All good!",
					"alertTextLoad": "* Validating, please wait"
				},
				"checkScholarshipConfNo": {	//	Ajax call to check list of
											//	types who can apply for
											//	a scholarship
					"url": "../lib/validators/confonlist.php?c=Single,Committee_Full,Committee_Partial",
					"alertText": "** Registration declined **",
//					"alertTextOk": "All good!",
					"alertTextLoad": "* Validating, please wait"
				},
				"checkMerchList": {	//	Ajax call to check list of those who can
									//	order merchandise
					"url": "../lib/validators/onlist.php?c=Single,SO,Add_Family,Assistant,Resource_Presenter,Resource_Vendor,Committee_Full,Committee_Partial,Observer,Volunteer,Guest",
					"alertText": "** Registration declined **",
//					"alertTextOk": "All good!",
					"alertTextLoad": "* Validating, please wait"
    },
				"checkCountry": {	//	Ajax call to check country entry
					"url": "../lib/validators/checkcountry.php",
					"alertText": "** Invalid country entry **",
//					"alertTextOk": "All good!",
					"alertTextLoad": "* Validating, please wait"
    },
				"attendwith": {	//	Ajax call to check attending with email
					"url": "../lib/validators/attendwith.php",
					"alertText": "** Registration declined **",
//					"alertTextOk": "All good!",
					"alertTextLoad": "* Validating, please wait"
    },
				"checkEmailAndConfMatch": {	//	Ajax call to check email and confirmation number correspond in PayPal request
					"url": "../lib/validators/matchconftoemail.php",
					"extraDataDynamic" : ['#PayPal__email'],
					"alertText": "** Email and confirmation number don't correspond **",
//					"alertTextOk": "All good!",
					"alertTextLoad": "* Validating, please wait"
    },
                "dateRange": {
                    "regex": "none",
                    "alertText": "* Invalid ",
                    "alertText2": "Date Range"
                },
                "dateTimeRange": {
                    "regex": "none",
                    "alertText": "* Invalid ",
                    "alertText2": "Date Time Range"
                },
                "minSize": {
                    "regex": "none",
                    "alertText": "* Minimum ",
                    "alertText2": " characters required"
                },
                "maxSize": {
                    "regex": "none",
                    "alertText": "* Maximum ",
                    "alertText2": " characters allowed"
                },
				"groupRequired": {
                    "regex": "none",
                    "alertText": "* You must fill one of the following fields",
                    "alertTextCheckboxMultiple": "* Please select an option",
                    "alertTextCheckboxe": "* This checkbox is required"
                },
                "min": {
                    "regex": "none",
                    "alertText": "* Minimum value is "
                },
                "max": {
                    "regex": "none",
                    "alertText": "* Maximum value is "
                },
                "past": {
                    "regex": "none",
                    "alertText": "* Date prior to "
                },
                "future": {
                    "regex": "none",
                    "alertText": "* Date past "
                },	
                "maxCheckbox": {
                    "regex": "none",
                    "alertText": "* Maximum ",
                    "alertText2": " options allowed"
                },
                "minCheckbox": {
                    "regex": "none",
                    "alertText": "* Please select ",
                    "alertText2": " options"
                },
                "equals": {
                    "regex": "none",
                    "alertText": "* Fields do not match"
                },
                "creditCard": {
                    "regex": "none",
                    "alertText": "* Invalid credit card number"
                },
                "phone": {
                    // credit: jquery.h5validate.js / orefalo
                    "regex": /^([\+][0-9]{1,3}[\ \.\-])?([\(]{1}[0-9]{2,6}[\)])?([0-9\ \.\-\/]{3,20})((x|ext|extension)[\ ]?[0-9]{1,4})?$/,
                    "alertText": "* Invalid phone number"
                },
                "email": {
                    // HTML5 compatible email regex ( http://www.whatwg.org/specs/web-apps/current-work/multipage/states-of-the-type-attribute.html#    e-mail-state-%28type=email%29 )
                    //	Modified 2 February 2014 by Stephanie Mitchell to strip
                    //	to word boundaries (i.e. remove leading/trailing spaces)
                    "regex": /\b(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))\b/,
                    "alertText": "* Invalid email address"
                },
                "integer": {
                    "regex": /^[\-\+]?\d+$/,
                    "alertText": "* Not a valid integer"
                },
                "number": {
                    // Number, including positive, negative, and floating decimal. credit: orefalo
                    "regex": /^[\-\+]?((([0-9]{1,3})([,][0-9]{3})*)|([0-9]+))?([\.]([0-9]+))?$/,
                    "alertText": "* Invalid floating decimal number"
                },
                "date": {                    
                    //	Check if date is valid by leap year
			"func": function (field) {
					var pattern = new RegExp(/^(\d{4})[\/\-\.](0?[1-9]|1[012])[\/\-\.](0?[1-9]|[12][0-9]|3[01])$/);
					var match = pattern.exec(field.val());
					if (match == null)
					   return false;
	
					var year = match[1];
					var month = match[2]*1;
					var day = match[3]*1;					
					var date = new Date(year, month - 1, day); // because months starts from 0.
	
					return (date.getFullYear() == year && date.getMonth() == (month - 1) && date.getDate() == day);
				},                		
			 "alertText": "* Invalid date, must be in YYYY-MM-DD format"
                },
                "ipv4": {
                    "regex": /^((([01]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))[.]){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))$/,
                    "alertText": "* Invalid IP address"
                },
                "url": {
                    "regex": /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i,
                    "alertText": "* Invalid URL"
                },
                "onlyNumberSp": {
                    "regex": /^[0-9\ ]+$/,
                    "alertText": "* Numbers only"
                },
                "onlyLetterSp": {
                    "regex": /^[a-zA-Z\ \']+$/,
                    "alertText": "* Letters only"
                },
                "onlyLetterNumber": {
                    "regex": /^[0-9a-zA-Z]+$/,
                    "alertText": "* No special characters allowed"
                },
                // --- CUSTOM RULES -- Those are specific to the demos, they can be removed or changed to your likings
                "ajaxUserCall": {
                    "url": "ajaxValidateFieldUser",
                    // you may want to pass extra data on the ajax call
                    "extraData": "name=eric",
                    "alertText": "* This user is already taken",
                    "alertTextLoad": "* Validating, please wait"
                },
				"ajaxUserCallPhp": {
                    "url": "phpajax/ajaxValidateFieldUser.php",
                    // you may want to pass extra data on the ajax call
                    "extraData": "name=eric",
                    // if you provide an "alertTextOk", it will show as a green prompt when the field validates
                    "alertTextOk": "* This username is available",
                    "alertText": "* This user is already taken",
                    "alertTextLoad": "* Validating, please wait"
                },
                "ajaxNameCall": {
                    // remote json service location
                    "url": "ajaxValidateFieldName",
                    // error
                    "alertText": "* This name is already taken",
                    // if you provide an "alertTextOk", it will show as a green prompt when the field validates
                    "alertTextOk": "* This name is available",
                    // speaks by itself
                    "alertTextLoad": "* Validating, please wait"
                },
				 "ajaxNameCallPhp": {
	                    // remote json service location
	                    "url": "phpajax/ajaxValidateFieldName.php",
	                    // error
	                    "alertText": "* This name is already taken",
	                    // speaks by itself
	                    "alertTextLoad": "* Validating, please wait"
	                },
                "validate2fields": {
                    "alertText": "* Please input HELLO"
                },
	            //tls warning:homegrown not fielded 
                "dateFormat":{
                    "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(?:(?:0?[1-9]|1[0-2])(\/|-)(?:0?[1-9]|1\d|2[0-8]))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(0?2(\/|-)29)(\/|-)(?:(?:0[48]00|[13579][26]00|[2468][048]00)|(?:\d\d)?(?:0[48]|[2468][048]|[13579][26]))$/,
                    "alertText": "* Invalid Date"
                },
                //tls warning:homegrown not fielded 
				"dateTimeFormat": {
	                "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1}$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^((1[012]|0?[1-9]){1}\/(0?[1-9]|[12][0-9]|3[01]){1}\/\d{2,4}\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1})$/,
                    "alertText": "* Invalid Date or Date Format",
                    "alertText2": "Expected Format: ",
                    "alertText3": "mm/dd/yyyy hh:mm:ss AM|PM or ", 
                    "alertText4": "yyyy-mm-dd hh:mm:ss AM|PM"
	            }
            };
            
        }
    };

    $.validationEngineLanguage.newLang();
    
})(jQuery);
