<?php
/*
	Esprit Registration System
	by Stephanie Mitchell
	Guest Registration Form
	8 May, 2015.
*/

define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
if (TESTING) {	// TESTING constant is set in config.php
	$today_text = (isset($_REQUEST['date']) ? $_REQUEST['date'] : 'now');
	$test_msg = 'TEST';
} else {
 	$today_text = 'now';
 	$test_msg = '';
}

$override = (isset($_REQUEST['password']) ? $_REQUEST['password'] : false);
$overridden = ($override == $committee_override);

$form_type = 'Guest';

require_once "classes.php";	//	Pull in everything
?>
<html>
<?php
	require_once "head.php";
?>
<!-- Enable Guest fields -->
<script type="text/javascript">
jQuery(document).ready(function(){	//	Enable Guest-specific fields which were
									//	disabled by head.php above
	alwaysshow('.Guest-specific', 'Guest');
})</script>
<body>
<?php

if (!$overridden) {		// allowed to use this form at all?
	print '<h2><img src="../images/logo.gif" alt="" width="500" height="108" border="0" /><br />
	<span class="i">This form is for internal use only and requires a password.</span>
	</h2>
	<p><a href="../index.php">[Return to Registration Start]</a></p>';
	exit;
}

if ($check['preregistration_closed']) {
	print closed($form_type, $date_text['registration_closed']);
	exit;
}
if ($check['committee_registration_not_yet_open']) {
	print notyetopen($form_type, $date_text['committee_registration_open']);
	exit;
}
print masthead($form_type);

?>
<div class="section">
	<div class="headerbar">Instructions</div>
	<ol>
		<li>This form is only for Committee use for pre-registering a Guest. To select a different form, please <a href="../index.php">return to Registration Start</a>.</li>
		<li>Each person attending Esprit MUST BE REGISTERED.</li>
		<li> <span class="reqd reqdhilite">Fields highlighted like this</span> are required.</li>
		<li><span class="i">Note that pre-registering does not obligate you to pay or attend nor are you guaranteed a space at Esprit or any hotel.</span></li>
		<li>Click Submit at the bottom. Your official Registration Letter will arrive via email shortly.</li>
		<?php
		if ($today < $date['payment_deadline']) {
			print "<li>Our mailing address is:<br />
				<br /> $esprit_address<br />
				<br />
				</li>";
		}?>
		<li> We urge you to refer to these Help buttons<?php print helpbutton('helpbuttonhelp.php');?> for lots of useful information and guidance.</li>
	</ol>
	<p class="tiny">All information is kept strictly confidential.</p>
</div>
<form action="../process.php" method="post" enctype="multipart/form-data" name="form1" id="formID">

<?php
print esprit_names(array('Guest-specific'));
print attendwith($form_type);
require_once "bill_contact.php";

/*
	Create the rate tables for each selected type.
*/
$rates = new ratetable;
print $rates->preamble($form_type);
print '<table width="100%">
	<tr>';
print '<td>' . $rates->table('reg', $form_type, 'You', true) . '</td>';
print '</tr></table>';
print $rates->postamble();

/*
	Add-ons
*/
print other_purchases($form_type);

/*
	Gather the badge photo(s).
*/
$badge = new badgephoto;
print $badge->preamble($form_type);	//	Preamble
print '<table width="100%">
	<tr>';
print '<td>' . $badge->table('reg', $form_type, 'You') . '</td>';
print '</tr></table>';
print $badge->postamble();	//	Postamble

/*
	Gather the vax certificates.
*/
$vaxcert = new vaxcertificate;
print $vaxcert->preamble($form_type);	//	Preamble
print '<table width="100%">
	<tr>';
print '<td>' . $vaxcert->table('reg', $form_type, 'You') . '</td>';
print '</tr></table>';
print $vaxcert->postamble();	//	Postamble

/*
	The fine print section
*/

require_once "fine_print.php";

?>
<div><!-- Hidden fields required by this form, plus form submit button -->	
	<input type="hidden" name="noupload[source_form_type]" testdata="no" id="source_form_type" value="<?php print $form_type;?>" />
	<input type="hidden" name="password" id="password" value="<?php print $override;?>" />

	<input type="submit" id="postbut" name="Submit Pre-Registration" value="Submit Pre-Registration" />
</div>
</form>
</body>
</html>
