<?php
/*
	Esprit Registration System
	by Stephanie Mitchell
	Donation Form
	27 April, 2023.
*/

define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
if (TESTING) {	// TESTING constant is set in config.php
	$today_text = (isset($_REQUEST['date']) ? $_REQUEST['date'] : 'now');
	$test_msg = 'TEST';
} else {
 	$today_text = 'now';
 	$test_msg = '';
}
$form_type = "Donor";	//	MUST match one of the rate groups in config.php
						//	(Single, SO etc.)
require_once "classes.php";	//	Pull in everything
?>
<html>
<?php
	require_once "head.php";
?>
<body>
<?php
print masthead('Donors', $fulltitle = 'Donation Form');
?>
<h3>Esprit changes lives and saves lives. You can help!</h3>
<div class="section">
	<div class="headerbar">Instructions</div>
	<ol>
		<li><b>THIS IS NOT A REGISTRATION FORM. It is for making a donation to Esprit if you don't plan to attend. It will NOT let you attend Esprit.</b></li>
		<li>If you want to attend Esprit, please <a href="/index.php">return to Registration Start</a> and select a different form.</li>
		<li> <span class="reqd reqdhilite">Fields highlighted like this</span> are required.</li>
		<?php
		print "<li>Our mailing address is:<br />
			<br /> $esprit_address<br />
			</li>";
		?>
	</ol>
	<p class="tiny">All information is kept strictly confidential.</p>
</div>
<form action="../process.php" method="post" enctype="multipart/form-data" name="form1" id="formID">

<?php
// print form_switches(['Donor']);
// print esprit_names(['Donor']);
 	print '<input type="hidden" value="' . date("Y-m-d") . '" name="noupload[appstart]" testdata="no">';	//	Added manually for timely completion check

	/*	Name info. */

	$class = '';
	$section = 'Donor';
	$alt = 'Your name';
	$prefix = 'Donor';

	$result = "<table width=\"100%\" class=\"section person $class\" cellpadding=\"2\">";
	$result .= "<tr><td class=\"headerbar\">$section</td></tr>";
	
	/*	Input fields for preferred name */
	
	$result .= "<tr><td width=\"25%\"><div class=\"reqd reqdhilite\">$alt*:" . helpbutton('prefnamehelp.php') . "</div></td>";
	$result .= "<td>
	<div class=\"reqdhilite\"><input class=\"validate[required]\" type=\"text\" placeholder=\"First name\" name=\"reg[{$prefix}][firstnamepref]\" id=\"{$prefix}__firstnamepref\" size=\"30\" />
	&nbsp;&nbsp;
	<input class=\"validate[required]\" type=\"text\" placeholder=\"Last name\" name=\"reg[{$prefix}][lastnamepref]\" id=\"{$prefix}__lastnamepref\" size=\"30\" /></div></td></tr>";
	print $result;

	require "bill_contact_short.php";

/*	Enter default meal fields to keep database happy */

	$mfields = "<div class=\"invisible\">Meal debug fields";
	$mfields .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$prefix}__meal2\" name=\"reg[{$prefix}][meal2]\" value=\"0\" />";
	$mfields .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$prefix}__meal3\" name=\"reg[{$prefix}][meal3]\" value=\"0\" />";
	$mfields .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$prefix}__meal4\" name=\"reg[{$prefix}][meal4]\" value=\"0\" />";
	$mfields .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$prefix}__meal5\" name=\"reg[{$prefix}][meal5]\" value=\"0\" />";
	$mfields .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$prefix}__meal6\" name=\"reg[{$prefix}][meal6]\" value=\"0\" />";
	$mfields .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$prefix}__meal2checked\" name=\"reg[{$prefix}][meal2checked]\" value=\"0\" />";
	$mfields .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$prefix}__meal3checked\" name=\"reg[{$prefix}][meal3checked]\" value=\"0\" />";
	$mfields .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$prefix}__meal4checked\" name=\"reg[{$prefix}][meal4checked]\" value=\"0\" />";
	$mfields .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$prefix}__meal5checked\" name=\"reg[{$prefix}][meal5checked]\" value=\"0\" />";
	$mfields .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$prefix}__meal6checked\" name=\"reg[{$prefix}][meal6checked]\" value=\"0\" />";
	$mfields .= "</div>";
	print $mfields;
/*
	die(__FILE__ .':'. __LINE__ . ": END OF RESULT");
	Add-ons (i.e. donation and amount)
*/
	print other_purchases($form_type);
	
?>
<div><!-- Hidden fields required by this form, plus form submit button -->	
	<input type="hidden" name="noupload[source_form_type]" testdata="no" id="source_form_type" value="Donor" />
	<input type="hidden" name="password" id="password" value="<?php print $password;?>" />

	<input type="submit" id="postbut" name="Submit Donation" value="Submit Donation" />
</div>
</form>
</body>
</html>
