<?php
/*
	Esprit Registration System
	by Stephanie Mitchell
	Esprit Committee Registration Form.
	8 May, 2015.
	Updated to include SO and Add. Family registrations on the same form.
*/

define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
if (TESTING) {	// TESTING constant is set in config.php
	$today_text = (isset($_REQUEST['date']) ? $_REQUEST['date'] : 'now');
	$test_msg = 'TEST';
} else {
 	$today_text = 'now';
 	$test_msg = '';
}

$override = (isset($_REQUEST['password']) ? $_REQUEST['password'] : false);
$overridden = ($override == $committee_override) || (strpos($_SERVER['HTTP_REFERER'], 'password='.$committee_override) >0);

$form_type = (isset($_REQUEST['form_type']) ? $_REQUEST['form_type'] : 'Unspecified');

if ($form_type == 'Auto') {	//	Auto selection?

	/*	Connect to database and retrieve info from parameters. */

	$search_email = $_REQUEST['commemailselect'];

	require_once "mysql_utilities.php";
	mysql_login('Read-only');

	$sqlcmd = "SELECT category AS form_type FROM regcontrol WHERE email = \"$search_email\"";
	
		$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(mysqli_error($GLOBALS['dbConnect']) .  'Query=' .$sqlcmd);

	$row = mysqli_fetch_assoc($result);	//	get the record. If there's more than
										//	one, the result is undefined, but 
										//	should not happen in real life.

	$form_type = $row['form_type'];
} else {
	if (($form_type != 'Committee_Full') and ($form_type != 'Committee_Partial')) {
		die("Internal error: Invalid or unspecified Committee Form type");
	}
	$not_form_type = $form_type == 'Committee_Full' ? 'Committee_Partial' : 'Committee_Full';
}

global $esprit_address, $esprit_address_text, $hist_book;
require_once "classes.php";	//	Pull in everything
?>
<html>
<?php
	require_once "head.php";
?>
<body>
<?php

if (!$overridden) {		// allowed to use this form at all?
?>
<h2><img src="/espritcommon/logo.gif" alt="" width="500" height="108" border="0" /><br />
	<span class="i">This form is for internal use only and requires a password.</span></h2>
<p><a href="../index.php">[Return to Registration Start]</a></p>
<p><a href="http://www.espritgala.org">[Return to Esprit Main Site]</a></p>
<br/>
</span></p>
<?php
exit;
}
if ($check['preregistration_closed']) {
	print closed($form_type, $date_text['registration_closed']);
	exit;
}
if (!$check['committee_preregistration_open']) {
	print notyetopen($form_type, $date_text['committee_registration_open']);
	exit;
}
print masthead($form_type);

?>
<div class="section">
	<div class="headerbar">Instructions</div>
	<ol>
		<li>This form is only for pre-registering Esprit Committee Members receiving the <span class="bold"><?php print $form_type;?> Discount</span> Rate.  To select a different form, you can <a href="../index.php">return to Registration Start</a>.</li>
		<li>Each person attending Esprit MUST BE REGISTERED. You can use this form to register yourself and optionally your SO and an additional family member.</li>
		<li> <span class="reqd reqdhilite">Fields highlighted like this</span> are required.</li>
		<li><span class="i">Note that pre-registering does not obligate you to pay or attend nor are you guaranteed a space at Esprit or any hotel.</span></li>
		<li>Click Submit at the bottom. Your official Registration Letter will arrive via email shortly.</li>
		<?php
		if ($today < $date['payment_deadline']) {
			print "<li>Our mailing address is:<br />
				<br /> $esprit_address<br />
				<br />
				</li>";
		}?>
		<li> We urge you to refer to these Help buttons<?php print helpbutton('helpbuttonhelp.php');?> for lots of useful information and guidance.</li>
	</ol>
	<p class="tiny">All information is kept strictly confidential.</p>
</div>
<form action="../process.php" method="post" enctype="multipart/form-data" name="form1" id="formID">

<?php
print form_switches(array($form_type, 'SO', 'Add_Family'));
print esprit_names(array($form_type, 'SO', 'Add_Family'));
require_once "bill_contact.php";

/*
	Create the rate tables for each selected type.
*/
$rates = new ratetable;
print $rates->preamble($form_type);
print '<table width="100%">
	<tr>';
print '<td>' . $rates->table('reg', $form_type, 'You') . '</td>';
print '<td class="so">' . $rates->table('reg', 'SO', 'Your SO') . '</td>';
print '<td class="af">' . $rates->table('reg', 'Add_Family', 'Your Additional Family') . '</td>';
print '</tr></table>';

/*
	Create the scholarship application section.
*/

print '<table width="100%">';
	print scholapp($check['scholarships_open'], $form_type);
print '</table>';
print $rates->postamble();

/*
	Add-ons
*/
print other_purchases($form_type);


print other_roles($form_type);

/*
	Create the volunteer signup section.
*/
$volunteer = new volunteer;
print $volunteer->preamble($form_type);
print "<a onclick=\"$('.vo').toggle()\" > Click here</a> to see the opportunities we have for you!</p>";
print '<div class="vo">';
print '<table width="100%">
	<tr>';
print '<td>' . $volunteer->table('reg', $form_type, 'You') . '</td>';
print '<td class="so">' . $volunteer->table('reg', 'SO', 'Your SO') . '</td>';
print '<td class="af">' . $volunteer->table('reg', 'Add_Family', 'Your Additional Family') . '</td>';
print '</tr></table>';
print $volunteer->postamble();
print '</div>';

/*
	Gather the badge photo(s).
*/
$badge = new badgephoto;
print $badge->preamble($form_type);	//	Preamble
print '<table width="100%">
	<tr>';
print '<td>' . $badge->table('reg', $form_type, 'You') . '</td>';
print '<td class="so">' . $badge->table('reg', 'SO', 'Your SO') . '</td>';
print '<td class="af">' . $badge->table('reg', 'Add_Family', 'Your Additional Family') . '</td>';
print '</tr></table>';
print $badge->postamble();	//	Postamble

/*
	Gather the vax certificates.
*/
$vaxcert = new vaxcertificate;
print $vaxcert->preamble($form_type);	//	Preamble
print '<table width="100%">
	<tr>';
print '<td>' . $vaxcert->table('reg', $form_type, 'You') . '</td>';
print '<td class="so">' . $vaxcert->table('reg', 'SO', 'Your SO') . '</td>';
print '<td class="af">' . $vaxcert->table('reg', 'Add_Family', 'Your Additional Family') . '</td>';
print '</tr></table>';
print $vaxcert->postamble();	//	Postamble

/*
	The fine print section
*/

require_once "fine_print.php";

?>
<div><!-- Hidden fields required by this form, plus form submit button -->	
	<input type="hidden" name="noupload[source_form_type]" testdata="no" id="source_form_type" value="<?php print $form_type;?>" />
	<input type="hidden" name="password" id="password" value="<?php print $password;?>" />

	<input type="submit" id="postbut" name="Submit Pre-Registration" value="Submit Pre-Registration" />
</div>
</form>
</body>
</html>
