<?php
/*
	This file contains overrides to the dates in .config.php. This allows local or
	one-time changes to be made to the dates without upsetting the carefully designed
	computed dates in that file. For example, the precon date could be adjusted away from
	the calculated date to allow for unforeseen circumstances, or registration for certain
	groups could be extended or shortened.
	
	Note that only dates can be overridden in this file.
	
	Copy this file, edit it and rename it to end in the current Esprit year.
*/

/*	All entries must be of the form
	$date['parameter'] = new DateTime("<date specification>";
	For convenience, define each parameter on its own line.
	Uncomment the examples below and run Maintenance > Review Config File Dates to see the
	effect.
*/

// $date['April_Fools'] = new DateTime("April 1 $esprit_year");
// $date['palindrome'] = new DateTime('2020-02-02');
// $date['tier2'] = new DateTime("$registration_opens + 35 days");

/*
	Refund dates. Overridden in 2020 because of COVID-19 concerns.
*/
	//	Deadline for full refund, usually the second Friday of March
	$date['refund_full_deadline'] = new DateTime("April 2, $esprit_year 23:59");

	//	Full refund not available after this date, usually the day after the
	//	second Friday fof March (not necessarily the second Saturday!) This
	//	means only 50% refund available after this date.
	$date['refund_full_closed'] = new DateTime("April 2, $esprit_year +1 day");

	//	Deadline for 50% refund, usually the second Friday of April
	$date['refund_50_deadline'] = new DateTime("$esprit_start -2 days");

	//	50% refund not available after this date, usually the day after the
	//	second Friday fof March (not necessarily the second Saturday!). This
	//	means NO refunds after this date.
	$date['refund_50_closed'] = new DateTime("$esprit_start");		//	day after above

/*
	Tier pricing. Overridden in 2020 because of COVID-19 concerns and PayPal suspension.
	This change effectively freezes the tier3 rate (March) until the beginning of Esprit.
*/
	$date['tier4'] = new DateTime("$esprit_start");
	$date['tier5'] = new DateTime("$esprit_start + 1 day");




?>