<?php
/*
	Esprit Chart System, by Stephanie Mitchell
	23 January, 2013
	
	This file creates the Registrations by Province Chart for the current year overview.
*/
// Database access
define('QUADODO_IN_SYSTEM', true);

require_once "{$_SERVER['DOCUMENT_ROOT']}/mgrlib/.auth/.regconnect.php"; // hostname, ID and password
require_once "{$_SERVER['DOCUMENT_ROOT']}/mgrlib/.auth/.config.php";
require_once "{$_SERVER['DOCUMENT_ROOT']}/mgrlib/mysql_utilities.php";
$chart_year = $GLOBALS['esprit_year'];
mysql_login('Read-only');

$sql = 'SELECT count(*) AS c, upper(state) AS p,
	CASE upper(state)
		WHEN "AB" THEN "01"
		WHEN "BC" THEN "02"
		WHEN "MB" THEN "03"
		WHEN "NB" THEN "04"
		WHEN "NL" THEN "05"
		WHEN "NS" THEN "07"
		WHEN "NU" THEN "14"
		WHEN "NT" THEN "13"
		WHEN "PE" THEN "09"
		WHEN "ON" THEN "08"
		WHEN "PQ" THEN "10"
		WHEN "QC" THEN "10"
		WHEN "SK" THEN "11"
		WHEN "YT" THEN "12"
		ELSE "00"
	END AS pcode
	FROM regall
	WHERE reg_status NOT LIKE "%Cancelled%"
		AND reg_status != "DELETED"
		AND country="Canada"
		AND esprit_year='.$chart_year.'
		AND form_type NOT IN ("Internal", "Ticket")
	GROUP BY state';

	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);

$count_shown = 0;
$count_total = 0;
// Get all the rows
while ($row = mysqli_fetch_array($result)) {
	$data[] = $row;
	$count_shown++;
}
mysql_logout();	//	Disconnect from database


$chart ="<chart
	caption=\"Canada Esprit $chart_year Registrations by Province\"
	theme=\"esprit\">
    <annotations width=\"500\" height=\"300\" autoscale=\"1\">
        <annotationgroup id=\"user-images\">
            <annotation id=\"country-name\" type=\"text\" fillcolor=\"#000000\" fontsize=\"20\" text=\"Canada\" bold=\"1\"
            x=\"\$canvasEndX - 200\" y=\"\$canvasStartY + 150\" />
        </annotationgroup>
    </annotations>
    <colorrange minvalue=\"0\" startlabel=\"Low\" endlabel=\"High\" code=\"#FFFFFF\" gradient=\"1\">
    	<color maxvalue=\"30\" code=\"#fbb4b9\" gradient=\"1\" />
    	<color maxvalue=\"60\" code=\"#fbb4b9\" gradient=\"1\" />
        <color maxvalue=\"100\" code=\"#f768a1\" gradient=\"1\" />
        <color maxvalue=\"200\" code=\"#ae017e\" gradient=\"1\" />
    </colorrange>
";
for ($n = 0 ; $n < $count_shown ; $n++) {
	$chart .= "<set id=\"{$data[$n]['p']}\" value=\"{$data[$n]['c']}\" />\n";
}

$chart .="</chart>";
print $chart;
?>