<?php
/*
	Esprit Chart System, by Stephanie Mitchell
	10 August, 2020
	
	An application for generating charts from data gathered during Esprit online
	registrations.
	
	This version creates a map of Canada showing registrations by province for
	the current year.
	
	This application uses FusionCharts, a Javascript charting package.
	
*/

require_once "{$_SERVER['DOCUMENT_ROOT']}/mgrlib/.auth/.regconnect.php"; // hostname, ID and password
$db = get_regconnect('Read-only');
define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/mgrlib/.auth/.config.php";
$db['tb'] = 'regall';

$chart_year = isset($_REQUEST['chart_year']) ? $_REQUEST['chart_year'] : (isset($_SESSION['chart_year']) ? $_SESSION['chart_year'] : $esprit_year);
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<?php print "<title>Esprit $chart_year Online Registration Charts $test_msg</title>";?>
<link href="../../lib/css/styles.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="/mgrlib/js/jquery.js"></script>
<script type="text/javascript" src="/mgrlib/js/jquery-ui.js"></script>
<script language="javascript" src="/mgrlib/js/fusioncharts.js"></script>
<script language="javascript" src="/mgrlib/js/fusioncharts.maps.js"></script>
<script language="javascript" src="/mgrlib/js/fusioncharts-jquery-plugin.js"></script>
<script type="text/javascript" src="/mgrlib/js/themes/fusioncharts.theme.esprit.js"></script>



<?php 
print <<<STUFF
<script type="text/javascript">
jQuery(document).ready(function(){
    $("#canada").insertFusionCharts({
		type: "maps/canada",
		theme: "esprit",
		width: "800",
		height: "550",
		dataFormat: "XMLURL",
		dataSource: "regs_by_where_can.php?chart_year=$chart_year"
    });
});
</script>
STUFF;
?>
</head>
<body>
<?php
require_once "{$_SERVER['DOCUMENT_ROOT']}/mgrlib/mysql_utilities.php";

mysql_login('Read-only');
$sql = "SELECT DISTINCT esprit_year FROM regall ORDER BY esprit_year DESC;";
$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
mysql_logout();	//	Disconnect from database

?>
<div style="width:900px" id="canada"></div>   
</body>
</html>
