<?php
/*	Calendar utility functions */

/*	Get the dates and the count of venues for each day so we can scale the
	iframes vertically properly. iframes are not elastic so we have to size them
	explicitly beforehand.
*/
function calendar_info($esprit_year, $range_override = false) {
	/*
		Create array of dates between $date['esprit_start'] and $date['esprit_end']
	*/

	require_once "{$_SERVER['DOCUMENT_ROOT']}/mgrlib/.auth/.regconnect.php";
	require_once "{$_SERVER['DOCUMENT_ROOT']}/mgrlib/mysql_utilities.php";

	mysql_login('Read-only');

	if ($range_override) {
		$date_param = 'AND s.esprit_year=' .$GLOBALS['esprit_year'];
		$override_type = '';	//	Show all events, including private
	} else {
		$s = $GLOBALS['date']['esprit_start']->format('Y-m-d');
		$e = $GLOBALS['date']['esprit_end']->format('Y-m-d');
		$date_param = "AND DATE(s.resourcedate) BETWEEN '$s' AND '$e'";
		$override_type = 'AND s.resourceformat != "Private"';	//	Hide private events
	}
	$online_esprit = (ONLINE_ESPRIT == true ? 'WHERE v.venue_type="Online"' : 'WHERE v.venue_type!="Online"');

	$sql_info = "SELECT DATE(s.resourcedate) d_num,
		count(DISTINCT s.resourceroom) venue_count
			FROM regpresenterall s
		INNER JOIN regall r
		ON r.confirmation_no=s.confirmation_no
			$date_param
			AND r.is_presenter='Yes'
			AND s.resourcestatus IN ('Approved', 'Scheduled', 'Cancelled')
		LEFT JOIN regvenues v
		ON s.resourceroom=v.venue_long
			$override_type
		GROUP BY DATE(s.resourcedate)";
		$result = mysqli_query($GLOBALS['dbConnect'], $sql_info) or die('Database error on venue query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql_info);

	while ($mydata = mysqli_fetch_assoc($result)) {
		extract($mydata);
		if ($d_num != '0000-00-00') {
			$data[] = $mydata;
		}
	}
	mysql_logout();	//	Disconnect from database

	return $data;
}
/*
	Print "switchboard" buttons
*/
function switchboard() {
	$result = <<<SWITCHBOARD
	<div style="margin: 1em">
		<div class="switchbutton"><a href="/calendar/index.php" title="Grid View"><img src="/images/calendar.png"><br />Timetable</a></div>
		
		<div class="switchbutton"><a href="/calendar/daybytime.php" title="Events by Time"><img src="/images/time.png"><br />By Time</a></div>
	
		<div class="switchbutton"><a href="/calendar/daybyvenue.php" title="Events by Venue"><img src="/images/venue.png"><br />By Venue</a></div>
	
		<div class="switchbutton"><a href="/calendar/index.php?format=p" title="Printable" target="_parent"><img src="/images/printer.png"><br />Printable</a></div>
	
<!--
		<div class="switchbutton shade"><a href="/calendar/reportbytime.php" title="Details" target="_parent"><img src="/images/printer.png"><br />Details</a></div>
-->
	
		<div class="switchbutton"><a href="/calendar/ical-how-to-c.php" title="Sync Device" target="_parent"><img src="/images/sync.png"><br />Sync&nbsp;Device</a></div>
	
		<!--<div class="switchbutton"><a href="/calendar/index.php?o=h" title="Alt Grid"><img src="/images/calendar.png"><br />Alt Grid</a></div>-->
		&nbsp;
		<div class="switchbutton"><a href="/bios/index.php" title="Presenters and Vendors"><img src="/images/people.png"><br />Presenters</a></div>
	
		<div class="switchbutton"><a href="/maps/index.php" title="Maps"><img src="/images/maps.png"><br />Maps</a></div>
	
		<div class="switchbutton"><a href="/calendar/daysearch.php" title="Search"><img src="/images/search.png"><br />Search</a></div>
	
		<div class="switchbutton"><a href="https://www.espritgala.org"><img src="/images/logo.png"><br />Main Site</a></div>
	</div>
SWITCHBOARD;
	return $result;
}
/*
	Print calendar legend. Assumes stylesheet is already loaded
*/
function legend() {
	$result = <<<LEGENDSTUFF
	<p><span class="bold">Event types (background colour):</span>
	<span class="cal-legend class" title="Class, workshop, etc.">Class</span>
	<span class="cal-legend event" title="Non-class event, excursion or other activity">Event or Function</span>
	<span class="cal-legend externalevent"title="Non-Esprit event. Not included in registration, nor sponsored by Esprit. Scheduled time may change if unforeseen circumstances arise.">Non-Esprit Event</span>
	<span class="cal-legend service"title="Regular Esprit service">Service</span>
	</p>
	<p><span class="bold">Event status (border colour):
	<span class="cal-legend scheduled"title="Content or scheduled time will only change if unforeseen circumstances arise.">Confirmed</span>
	<span class="cal-legend approved"title="Content and time may change at any time, or the event may be cancelled.">Tentative</span>
	<span class="cal-legend cancelled"title="Information only. The event or presentation will NOT take place.">Cancelled</span>
</p>
	<span class="cal-legend bold" title="Toggle Setup/Tear-down"><a href="#" onclick="$('.setup, .teardown').toggle()"><img src="../images/setup.png" height="30"></a>Show/hide setup times
	<img src="../images/walking.png" height="25"> Walking Directions
	<img src="../images/driving.png" height="25"> Driving Directions</span>
LEGENDSTUFF;
	return $result;
}
/*
	Format an event from details passed in array
*/
function format_event($mydata) {
	$result = "<h3>{$mydata['bus_name']}</h3>";
	if (file_exists("bf/{$mydata['confirmation_no']}.jpg")
			and ($mydata['photousage'] == 'Public')
			and (strpos($mydata['bus_desc'], '<img ') == 0)) {
		$result .= "<div class=\"photo\"><img src=\"bf/{$mydata['confirmation_no']}.jpg\" width=\"160px\" /><br /></div>";
	}
	if (!(trim($mydata['fname']) == 'Esprit Master')) {
		if (trim($mydata['resourceformat']) == 'Event') {	
			$result .= "<p><b>Organizer: {$mydata['fname']} {$mydata['lname']}</b></p>";
		} else {
			$result .= "<p><b>Presenter: {$mydata['fname']} {$mydata['lname']}</b></p>";
		}
	}
	$result .= "<p><b>{$mydata['resourceroom']}, on {$mydata['resourceday']} at {$mydata['resourcetime']}</b></p>";
	$desc = str_replace('"/pix/', "\"{$GLOBALS['pixdir_absolute']}", $mydata['bus_desc']);
	$bio = str_replace('"/pix/', "\"{$GLOBALS['pixdir_absolute']}", $mydata['resourcebio']);
	$result .= "<p>$desc</p>";
	if ($bio != '') {
		$result .= "<h4>Presenter Info</h4>$bio";
	}
	return $result;
}
/*
	Format event data by event. Print venue name or time depending on $order
	parameter.
*/
function format_event_accordion($event_data, $order='time') {
	$result = "<div class=\"accordion\">";
//	$result .= "In format_event_accordion<br />";
	if ($order == 'time') {
		$result .= "<h4>{$event_data['resourcetime']}";
	} else {
		$result .= "<h4>{$event_data['resourceroom']} ";
		/*
		$result .= "
		<a href=\"#\" onclick=\"return hs.htmlExpand(this, {contentId:'$date_req$venuecount', width: '300px', height: '300px'})\">$thisvenuevalue<img src=\"../images/sm_view.png\"></a>";
		if ($venueinfo[$thisvenuevalue]['maplink'] == 'Yes') {
			$mapurl = urlencode($venueinfo[$thisvenuevalue]['address']);
			$result .= "
			<a href=\"https://www.google.com/maps/embed/v1/directions?key=AIzaSyCDASUOoIuWC-NwR3P3GMnBtK5mapFraAE&origin=Red+Lion+Hotel,+Port+Angeles,+WA&destination=$mapurl\" onclick=\"return hs.htmlExpand(this, {objectType: 'iframe', width: '800', height: '800'})\"><img src=\"../images/venue.png\" width=\"16\"></a>";
		}
		$result .= "
		<div class=\"highslide-html-content\" id=\"$date_req$venuecount\" style=\"width: 200px\">";
		$result .= "
		{$venueinfo[$thisvenuevalue]['address']}";
 		$result .= "
 		</div>";

*/
	}
	$result .= ": {$event_data['bus_name']}</h4>
		<div class=\"content\">";
	$result .= "{$event_data['fname']} {$event_data['lname']}<br />";
	$result .= format_event($event_data);
	$result .= "</div>
		</div>";
	return $result;
}
/*
	Format event data in the form of a timeline grid. All data is supplied in a
	single array.
*/
function format_day_grid($date_req, $hscale = 0.8, $vscale = 28, $width = 130) {
		/*
		Sets up and displays the event data in a Calendar given the date.
		This version displays classes as a grid and other events and activities
		as a list below it.
		$date_req is yyyy-mm-dd for desired date.
		$hscale	scales clock minutes to points
		$vscale is height of each venue's line
	*/
	global $date, $date_text;
	require_once "{$_SERVER['DOCUMENT_ROOT']}/mgrlib/.auth/.regconnect.php";
	require_once "{$_SERVER['DOCUMENT_ROOT']}/mgrlib/mysql_utilities.php";

	mysql_login('Read-only');	//	Just in case

	$sql_venue = "SELECT DISTINCT s.resourceroom venue,v.venue_addr address, v.venue_directions directions,v.venue_maplink maplink
		FROM regpresenter s
	INNER JOIN reg r ON r.confirmation_no=s.confirmation_no
	INNER JOIN regvenues v ON v.venue_long=s.resourceroom
	WHERE r.is_presenter='Yes'
		AND DATE(s.resourcedate) = '$date_req'
		AND s.resourcestatus IN ('Approved', 'Scheduled', 'Cancelled')
	ORDER BY CASE
		WHEN s.resourceroom LIKE 'Hollywood%' THEN 1
		WHEN s.resourceroom LIKE '%Lobby%' THEN 2
		WHEN s.resourceroom LIKE 'Rm%' THEN 3
		WHEN s.resourceroom LIKE 'Elk%' THEN 4
		WHEN s.resourceroom LIKE 'Off%' THEN 5
		ELSE 0
		END,s.resourceroom;";

	$sql_event = "SELECT r.firstnamepref fname, r.lastnamepref lname,
		s.bus_name bus_name, DATE_FORMAT(s.resourcedate,'%l:%i%p') resourcetime,
		s.resourcedate resourcedate, 
		TIME(s.resourcedate) resourcestarttime,
		DATE_FORMAT(TIMESTAMPADD(MINUTE, s.resourceduration, s.resourcedate), '%l:%i%p') resourceend,
		DATE_FORMAT(TIMESTAMPADD(MINUTE, -s.resourcesetuptime, s.resourcedate), '%l:%i%p') resourcesetupstart,
		DATE_FORMAT(TIMESTAMPADD(MINUTE, s.resourceteardowntime, s.resourcedate), '%l:%i%p') resourceteardownend,
		s.resourceduration resourceduration, s.resourceroom resourceroom,
		s.bus_desc bus_desc, s.id sessionid, s.confirmation_no confirmation_no,
		s.resourcestatus resourcestatus, s.resourceformat resourceformat,
		v.venue_abbr
	FROM regpresenter s
	INNER JOIN reg r ON r.confirmation_no=s.confirmation_no
	INNER JOIN regvenues v ON v.venue_long=s.resourceroom
		WHERE r.is_presenter='Yes'
		AND DATE(s.resourcedate) = '$date_req'
		AND s.resourcestatus IN ('Approved', 'Scheduled', 'Cancelled')
	ORDER BY s.resourcedate, resourceend DESC, s.resourceroom";

// 	print "Final \$sql_venue query: $sql_venue<br />";
// 	print "Final \$sql_event query: $sql_event<br />";

	$result_venue = mysqli_query($GLOBALS['dbConnect'], $sql_venue) or die('Database error on venue query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql_venue);
	$result_event = mysqli_query($GLOBALS['dbConnect'], $sql_event) or die('Database error on event query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql_event);

	/*	Gather venues used */
	$venuevalues = [];
	$venueinfo = [];
	$venuevalues[] = "<div style=\"text-align: right\">Time</div><div >Venue</div>";
	while($mydata = mysqli_fetch_assoc($result_venue)) {
		$venuevalues[] = $mydata['venue'];
		$venueinfo[$mydata['venue']] = $mydata;
	}
// 	print_r($venueinfo);
	$venuecount = count($venuevalues);
	// print_r($venuevalues);

	/* Display loop */

	$prevdata = '';
	$mydata = '';
	$found_row = false;

	/*	Gather all the data and split into events ve. classes. */
	$earliest = 23;	/*	Find earliest starts and latest ends */
	$latest = 0;
	while($mydata = mysqli_fetch_assoc($result_event)) {
		$myclass[] = $mydata;
		$s = substr($mydata['resourcestarttime'], 0, 2);
		$e = $s + ($mydata['resourceduration'] / 60);
		$earliest = min($earliest, $s);
		$latest = min(max($latest, $e), 24);
// 		print "Event: {$mydata['resourcename']}; start: {$mydata['resourcestarttime']}; end: {$mydata['resourceend']}; earliest: $earliest; latest: $latest<br />";
	}
	mysql_logout();	//	Disconnect from database

	/*
		day-wrapper is a large, absolutely-positioned div within which we place
		individual absolutely-positioned class-divs for each class. Missing or
		unallocated class slots simply don't get a class-div and the absolute
		positioning ensures that space is left for them. As a side-effect,
		overlaps and double-books are also clearly visible.
	*/
	
	$venue_total_height = 1.4* $vscale * $venuecount;	//	20 gives some padding
	$result = "
	<div style=\"min-height:{$venue_total_height}px\">";
	$result .= "
	<div class=\"cal-day-wrapper\">'";

	/*	Set up scaling factors for size of timeslots, in points. */

	$hour_offset = -$earliest * 60;	/*	Starting time in hours * 60 */
	$end_hour = ($latest - $earliest + 1) * 60;	/*	Time bar length in hours * 60 */

	/*	Offset to 08:00 start time and leave 80 min. of room for headings */

	$ts_hoffset = $hour_offset + $width;

	/*	Draw venue names down the left side */

	$venuecount = 0;
	foreach ($venuevalues as $thisvenuevalue) {
		$ts_width = ($width * $hscale) . "pt";	/* Make labels 90 min. wide */
		$ts_top = ($vscale * (array_search($thisvenuevalue, $venuevalues))) . "pt";
		$result .= "
		<div class=\"cal-timeslot venuelabel\" style=\"left: 0pt; top: $ts_top; width: $ts_width;\">";
		if ($venuecount > 0) {	//	Don't generate directions for the heading!
			$result .= "
			$thisvenuevalue<a href=\"#\" onclick=\"return hs.htmlExpand(this, {contentId:'$date_req$venuecount', width: '300px', height: '300px'})\"><img src=\"../images/walking.png\" height=\"20\"></a>";
			if ($venueinfo[$thisvenuevalue]['maplink'] == 'Yes') {
				$mapurl = urlencode($venueinfo[$thisvenuevalue]['address']);
				$result .= "
				<a href=\"https://www.google.com/maps/embed/v1/directions?key=AIzaSyBYBKGNvkmMs8j11XxI4eV7HQN-OgnpFjs&origin=Red+Lion+Hotel,+Port+Angeles,+WA&destination=$mapurl\" onclick=\"return hs.htmlExpand(this, {objectType: 'iframe', width: '800', height: '800'})\"><img src=\"../images/driving.png\" width=\"20\"></a>";
			}
			$result .= "
			<div class=\"highslide-html-content\" id=\"$date_req$venuecount\" style=\"width: 200px\">";
			$result .= "
			{$venueinfo[$thisvenuevalue]['address']}";
 		$result .= "
 		</div>";
		} else {
			$result .= "$thisvenuevalue";
		}
		$venuecount++;			/*	Count venues */
		$result .= '
		</div>';	//	
	}
	/*	Draw the time bars across the page */

	$s = $width;	/*	Starting position to clear headings */
	$h = $venuecount * $vscale . "pt";	/*	Height of all venues used */
	$w = 30;		/*	Half-hour slots alternating grey and transparent */
	$w_print = $w * $hscale ."pt";	/*	Actual print width in points */
	$t = 0;
	$hour = -$hour_offset / 60;
	$ampm = 'a';
	while ($s <= ($end_hour)) {	/*	Time bar extent in minutes */
		/*	Draw grey bar with time */
		$s_print = $s * $hscale . "pt";
		$result .= "<div class=\"cal-timeslot timelabel0\" style=\"top: $t; left: $s_print; width: $w_print; height: $h; min-height: $h;\">";
		$result .= ($hour == 12 ? 'Noon' : ($hour > 12 ? ($hour - 12) . 'pm' : $hour . 'am'));
		$hour++;
		$result .= '</div>';
		$s = $s + $w;
	
		/*	Draw clear bar without time */
		$s_print = $s * $hscale . "pt";
		$result .= "<div class=\"cal-timeslot timelabel1\" style=\"top: $t; left: $s_print; width: $w_print; height: $h; min-height: $h;\">";
		$result .= "&nbsp;";
		$result .= '</div>';
		$s = $s + $w;
	}

	/*	Draw the classes etc. */

	foreach ($myclass as $thisclass) {
		$s = $thisclass['resourcestarttime'];
		$venuecode = array_search($thisclass['resourceroom'], $venuevalues);
		/*	Min since midnight */
		$s_mins = (substr($s, 0, 2) * 60) + substr($s, 3, 2);
		$ts_left = ($hscale * ($s_mins + $ts_hoffset)) . "pt";
		$ts_width = ($hscale * $thisclass['resourceduration']) . "pt";
		$ts_top = ($vscale * $venuecode) . "pt";
			$class = 'class="cal-timeslot';
		if ($thisclass['resourcestatus'] == "Approved") {
			$class = 'class="cal-timeslot ts_slot approved"';
		}
		if ($thisclass['resourcestatus'] == "Scheduled") {
			$class = 'class="cal-timeslot ts_slot scheduled"';
		}
		if ($thisclass['resourceformat'] == 'Event') {
			$class = 'class="cal-timeslot ts_slot event"';
		}
		if ($thisclass['resourceformat'] == 'Excursion') {
			$class = 'class="cal-timeslot ts_slot event"';
		}
		if ($thisclass['resourceformat'] == 'Ticketed') {
			$class = 'class="cal-timeslot ts_slot event"';
		}
		if ($thisclass['resourceformat'] == 'Service') {
			$class = 'class="cal-timeslot ts_slot service"';
		}
		if ($thisclass['resourcestatus'] == "Cancelled") {
			$class = 'class="cal-timeslot ts_slot cancelled"';
		}
		$r = time();
		$result .= "<a href=\"eventdetail.php?sessionid={$thisclass['sessionid']}&_=$r\" onclick=\"return hs.htmlExpand(this, { objectType: 'ajax', slideshowGroup: '$date_req'} )\">";
		$result .= "<div $class style=\"left: $ts_left; top: $ts_top; width: $ts_width;\">";
		$result .= "{$thisclass['bus_name']}";
		$result .= '</div>';
		$result .= '</a>';
		$found_row = true;
	}
	$result .= '</div>';	//	End of day-wrapper div
	$result .= '</div>';	//	End of properly sized div for this calendar
	if (!$found_row) {
		$result = '<h3>There are no scheduled events for today yet.</h3>';
	}
	return $result;
}
/*
	Format event data in the form of a timeline grid in venue-across format. All
	data is supplied in a single array.
*/
function format_day_grid_v($date_req, $tscale = 0.8, $vscale = 28, $twidth = 130, $units = 'em', $printable = true, $range_override = false) {
	/*
	Sets up and displays the event data in a Calendar given the date.
	This version displays classes as a grid with venues across the top and time
	slots down the side.
	$date_req	is yyyy-mm-dd for desired date.
	$tscale		(time scale) scales clock hours to $units (how many vertical
				$units represent an hour)
	$vscale		(venue scale) is width of each venue's slot in $units
	$twidth		width of time column in $units
	$units		is pt, em, px etc.
	$printable	whether the table is intended for printing (controls whether or
				not certain elements appear)
	*/
	global $date, $date_text;
	
	require_once "{$_SERVER['DOCUMENT_ROOT']}/mgrlib/.auth/.regconnect.php";
	require_once "{$_SERVER['DOCUMENT_ROOT']}/mgrlib/mysql_utilities.php";
	mysql_login('Read-only');	//	Just in case
	$override = $range_override ? '' : 'AND s.resourceformat != "Private"';
	$online_esprit = (ONLINE_ESPRIT == true ? 'AND v.venue_type = "Online"' : 'AND v.venue_type != "Online"');

	$sql_venue = "SELECT DISTINCT s.resourceroom venue, v.venue_addr address, v.venue_abbr abbr, v.venue_directions directions, v.venue_maplink maplink, v.venue_type venue_type
		FROM regpresenter s
	INNER JOIN reg r ON r.confirmation_no=s.confirmation_no
	INNER JOIN regvenues v ON v.venue_long=s.resourceroom
	WHERE r.is_presenter='Yes'
		AND DATE(s.resourcedate) = '$date_req'
		$override
		$online_esprit
		AND s.resourcestatus IN ('Approved', 'Scheduled', 'Cancelled')
	ORDER BY CASE
		WHEN venue LIKE 'Olympic%' THEN 'AAA'
		WHEN venue LIKE 'Juan%' THEN 'BBB'
		WHEN venue LIKE 'Peninsula%' THEN 'CCC'
		WHEN venue LIKE 'Rm%' THEN 'YYY'
		WHEN venue LIKE '%Lobby%' THEN 'ZZZ'
		ELSE venue
		END;";

	$sql_event = "SELECT r.firstnamepref fname, r.lastnamepref lname,
		s.bus_name bus_name, DATE_FORMAT(s.resourcedate,'%l:%i%p') resourcetime,
		s.resourcedate resourcedate, 
		TIME(s.resourcedate) resourcestarttime,
		s.resourceduration resourceduration,
		s.resourcesetuptime resourcesetuptime,
		s.resourceteardowntime resourceteardowntime,
		s.resourceroom resourceroom,
		s.bus_desc bus_desc, s.id sessionid, s.confirmation_no confirmation_no,
		s.resourcestatus resourcestatus, s.resourceformat resourceformat,
		v.venue_abbr venue_abbr, v.venue_type venue_type
	FROM regpresenter s
	INNER JOIN reg r ON r.confirmation_no=s.confirmation_no
	INNER JOIN regvenues v ON v.venue_long=s.resourceroom
		WHERE r.is_presenter='Yes'
		AND DATE(s.resourcedate) = '$date_req'
		$override
		$online_esprit
		AND s.resourcestatus IN ('Approved', 'Scheduled', 'Cancelled')
	ORDER BY s.resourcedate DESC, s.resourceroom";

// 	$result .= "Final \$sql_venue query: $sql_venue<br />";
// 	$result .= "Final \$sql_event query: $sql_event<br />";

	$result_venue = mysqli_query($GLOBALS['dbConnect'], $sql_venue) or die('Database error on venue query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql_venue);
	$result_event = mysqli_query($GLOBALS['dbConnect'], $sql_event) or die('Database error on event query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql_event);

	$tu = $units;		//	Time scale units
	$vu = $units;		//	Venue scale units

	/*	Gather venues used */
	$venuevalues = [];
	$column_headers = "Venue<img src=\"../images/right.png\">&nbsp;<br />Time<img src=\"../images/down.png\">&nbsp;";
	$venue_index = 0;	//	For calculating horizontal position of venue column
	while($mydata = mysqli_fetch_assoc($result_venue)) {
		$venuevalues[$mydata['venue']] = ['abbr' => $mydata['abbr'], 'maplink' => $mydata['maplink'], 'address' => $mydata['address'], 'venue_type' => $mydata['venue_type'], 'index' => $venue_index++];
	}
	$venuecount = count($venuevalues);
	if ($venuecount == 0) {
		$result = '<h2>There are no scheduled events for today yet.</h2>
		</div>';
		return $result;
	}

	/*	Gather all the data */
	
	$earliest = 23;	/*	Find earliest and latest starts */
	$latest = 0;
	while($mydata = mysqli_fetch_assoc($result_event)) {
		$myclass[] = $mydata;
		$s = substr($mydata['resourcestarttime'], 0, 2);
		$e = $s + ($mydata['resourceduration'] / 60);
		$earliest = min($earliest, $s);
		$latest = min(max($latest, $e), 24);
// 		print "Event: {$mydata['resourcename']}; start: {$mydata['resourcestarttime']}; end: {$mydata['resourceend']}; earliest: $earliest; latest: $latest<br />";
	}
	mysql_logout();	//	Disconnect from database

	
	/*	Compute the height of an enclosing div so accordion knows how much space
		to open up. Take into account 1 for the heading line, 0.5 for a bit of
		space above and below  and another 0.5 to allow for a trailing
		half-hour. */
	
	$div_height = $tscale * ($latest - $earliest + 2);
	
	/*	Start output with dummy div to get accordion positioning stuff out of the way */
	
	$result = "<div><!-- accordion silencer-->";
	
	/*	Draw column and venue headers */
	
	$result .= "<div style=\"position:relative; padding: 0; margin: 0; height: $div_height$tu\"><!--  ; font-size: 70%  Start of main grid div --><!-- Line ".__LINE__."-->
	";
	$result .= "
	<div class=\"v_venue_header\" style=\"text-align: right;top: 0; left:0; width:$twidth$vu; height: $tscale$tu; min-height:$tscale$tu;\">$column_headers</div><!-- Line ".__LINE__."-->
	";
	$venue_headers = '';
	$idcount = 0;

	foreach ($venuevalues as $this_venue_name => $this_venue) {
		$venue_header_hpos = $twidth + $this_venue['index'] * $vscale;
		$idcount++;
	
		/*
			This relies on a bit of Highslide "magic". The contentId in here
			points to a div containing the content to be displayed when the link
			is clicked. That div is hidden by Highslide until then. The actual
			div is set up below.
		*/
		$no_icons_style = $printable ? 'style = "display: none"' : '';
	
		$imgsrc = $this_venue['venue_type'] == "Online" ? '../images/online.png' : '../images/walking.png';	//	Select appropriate icon for online or walking
		$venue_headers .= "
		<div class=\"v_venue_header\" style=\"width:$vscale$vu; height: $tscale$tu; min-height:$tscale$tu; left: $venue_header_hpos$vu; top:0\">
		$this_venue_name <a href=\"#\" onclick=\"return hs.htmlExpand(this, {contentId:'CI$date_req$idcount', width: '300px', height: '300px'})\"><img class=\"noprint\" $no_icons_style src=\"$imgsrc\" height=\"20\"></a>";
	
		/*	"Magic" highslide div for content refered to above. */

		$venue_headers .= "<div class=\"highslide-html-content\" id=\"CI$date_req$idcount\" style=\"width: 200px\"><strong>$this_venue_name</strong><br />{$this_venue['address']}</div>";

		/*
			Add a Google Maps link with directions if so indicated in the venue
			database.
		*/
	
		if ($this_venue['maplink'] == 'Yes') {
			$mapurl = urlencode($this_venue['address']);
			$venue_headers .= "
			<a href=\"https://www.google.com/maps/embed/v1/directions?key=AIzaSyBYBKGNvkmMs8j11XxI4eV7HQN-OgnpFjs&origin=Red+Lion+Hotel,+Port+Angeles,+WA&destination=$mapurl\" onclick=\"return hs.htmlExpand(this, {objectType: 'iframe', width: '800', height: '800'})\"><img class=\"noprint\" $no_icons_style src=\"../images/driving.png\" height=\"20\"></a>";
		}

		$venue_headers .= '</div>';
	}
	$result .= $venue_headers; $result .= "<!-- Line ".__LINE__."-->
	";

	/* Display loop */

	$found_row = false;

	/*	Draw the time bars down the page */
	for ($t = intval($earliest); $t <= $latest; $t++) {
		$vpos = $tscale * ($t + 1 - $earliest);
		switch (true) {
		case ($t < 12):	//	morning
			$tstring = "{$t}:00am";
			break;
		case ($t == 12):		//	noon
			$tstring = "Noon";
			break;
		case ($t == 24):		//	midnight
			$tstring = 'Midnight';
			break;
		case ($t > 12):			//	afternoon
			$tstring = $t - 12 . ':00pm';
			break;
		}
		/*	Compute total venue width for cursor overlay */
		$venue_total_width = $venuecount * $vscale + $twidth;
		$tscale30 = $tscale * 0.5;
		$vpos_overlay_top = $vpos;
		$vpos30_overlay_top = $vpos_overlay_top + $tscale30;
		$result .= "<div class=\"v_time_header\" style=\"top: $vpos$vu;height: $tscale$tu; min-height:$tscale$tu; width:$twidth$vu\">$tstring&nbsp;</div><!-- Line ".__LINE__."-->";
		/*	Draw on-the-hour overlay */
		$result .= "<div class=\"v_time_header_overlay\" style=\"top: $vpos_overlay_top$vu;height: $tscale30$tu; min-height:$tscale30$tu; width:$venue_total_width$vu\">$tstring</div><!-- Cursor overlay Line ".__LINE__."-->";
		/*	Draw half-hour overlay */
		$result .= "<div class=\"v_time_header_overlay\" style=\"top: $vpos30_overlay_top$vu;height: $tscale30$tu; min-height:$tscale30$tu; width:$venue_total_width$vu\"></div><!-- Cursor overlay Line ".__LINE__."-->";
	}
/*	//	Fake a test item
	$test_start = $tscale * (1 + 9 - $earliest);	//	start at 9:00. +1 is to avoid headings
	$test_height = $tscale * 3;	//	3 hours long
	$test_width = $vscale;		//	1 venue wide
	$test_venue = $vscale * 1;	//	1st venue
	$test_start2 = $tscale * (1 + 13 - $earliest);	//	start at 1pm. +1 is to avoid headings
	$test_height2 = $tscale * 2;	//	2 hours long
	$test_venue2 = $vscale * 2;	//	1st venue
	$result .= "<div style=\"position: absolute; top: $test_start2$tu; height: $test_height2$tu; min-height: $test_height2$tu; left: $test_venue2$vu; width: $vscale$vu; background-color: magenta\">
	{$mydata['bus_name']}Test Item: at $test_start2$tu (1pm) for $test_height2$tu, venue $test_venue2$vu<br /><!-- Line ".__LINE__."-->
</div>";
*/
	/*	Draw the classes etc. */

	foreach ($myclass as $thisclass) {
		$s = $thisclass['resourcestarttime'];
		$venuecode = array_search($thisclass['resourceroom'], $venuevalues);
		/*	Convert hh:mm start time into vertical start position */
		$start = $tscale * (1 + substr($s, 0, 2) + (substr($s, 3, 2) / 60) - $earliest);
		$left = $twidth + $vscale * $venuevalues[$thisclass['resourceroom']]['index'];
	/*	-10  in the next two calculations accounts for 6px padding around text in CSS */
		$width = $vscale - 10;
		$height = $tscale * ($thisclass['resourceduration'] / 60) - 10;
		$class = 'cal-timeslot ts_slot ';
		$show = true;
		
	/*
		Assign colours based on event type and status.
		Event type (class, event, service etc.) changes background.
		Event status (scheduled, approved, cancelled etc.) changes border.
	*/
	
/*	Set event type (resourceformat) */
	switch ($thisclass['resourceformat']) {
	
	case 'Class':
	case 'Workshop':
		$class .= 'class ';
	case 'Event':
	case 'Excursion':
		$class .= 'event ';
		break;
	case 'Blocking':
		$class .= 'blocking ';
		break;
	case 'External Event':
		$class .= 'externalevent ';
		break;
	case 'Excursion':
		$class .= 'event ';
		break;
	case 'Ticketed':
		$class = 'event ';
		break;
	case 'Service':
		$class .= 'service ';
		break;
	case 'Private':
		$class .= 'private ';
	}
	
/*	Set event type (resourcestatus) */
	switch ($thisclass['resourcestatus']) {
	case 'Approved':
		$class .= 'approved ';
		break;
	case 'Scheduled':
		$class .= 'scheduled ';
		break;
	case 'Cancelled':
		$class .= 'cancelled ';
	}

/*	Original code */
// 		if ($thisclass['resourcestatus'] == "Approved") {
// 			$class = 'cal-timeslot ts_slot approved';
// 		}
// 		if ($thisclass['resourcestatus'] == "Scheduled") {
// 			$class = 'cal-timeslot ts_slot scheduled';
// 		}
// 		if ($thisclass['resourceformat'] == 'Event') {
// 			$class = 'cal-timeslot ts_slot event';
// 		}
// 		if ($thisclass['resourceformat'] == "Blocking") {
// 			$class = 'blocking cal-timeslot ts_slot';
// 		}
// 		if ($thisclass['resourceformat'] == 'External Event') {
// 			$class = 'cal-timeslot ts_slot externalevent';
// 		}
// 		if ($thisclass['resourceformat'] == 'Excursion') {
// 			$class = 'cal-timeslot ts_slot event';
// 		}
// 		if ($thisclass['resourceformat'] == 'Ticketed') {
// 			$class = 'cal-timeslot ts_slot event';
// 		}
// 		if ($thisclass['resourceformat'] == 'Service') {
// 			$class = 'cal-timeslot ts_slot service';
// 		}
// 		if ($thisclass['resourceformat'] == 'Private') {
// 			$class = 'cal-timeslot ts_slot private';
// 		}
// 		if ($thisclass['resourcestatus'] == "Cancelled") {
// 			$class = 'cal-timeslot ts_slot cancelled';
// 		}

		$r = time();
		$result .= $printable ? '' : "<a href=\"eventdetail.php?sessionid={$thisclass['sessionid']}&_=$r\" onclick=\"return hs.htmlExpand(this, { objectType: 'ajax', slideshowGroup: '$date_req'} )\">";
		$result .= "<div class=\"$class\" style=\"position: absolute; top: $start$tu; height: $height$tu; min-height: $height$tu; left: $left$vu; width: $width$vu\">
		{$thisclass['bus_name']}</div>";
		$result .= $printable ? '' : "</a><!-- Line ".__LINE__."-->";

		if ($thisclass['resourcesetuptime'] > 0) {
			//	Draw blocking event for setup time. Begin by calculating sizes
			/*	Convert hh:mm start time into vertical start position */
			$start = $tscale * ((1 + substr($s, 0, 2) + (substr($s, 3, 2) / 60) - $earliest) - ($thisclass['resourcesetuptime'] / 60));
			$height = $tscale * ($thisclass['resourcesetuptime'] / 60);
			$setupiconheight = min(50, $height / 2);
			$class = 'setup cal-timeslot ts_slot';
			$result .= "<div class=\"$class\" style=\"position: absolute; top: $start$tu; height: $height$tu; min-height: $height$tu; left: $left$vu; width: $width$vu; border-bottom: none\"><div class=\"setupicon\">
			<img src=\"../images/stepladder2.png\" height=\"$setupiconheight$tu\"></div></div>";
			$result .= $printable ? '' : "</a><!-- Line ".__LINE__."-->";
		}

		if ($thisclass['resourceteardowntime'] > 0) {
			//	Draw blocking event for teardown time
			$s = $thisclass['resourceend'];
			/*	Convert hh:mm start time into vertical start position */
			$start = $tscale * (1 + substr($s, 0, 2) + (substr($s, 3, 2) / 60) - $earliest);
			$height = $tscale * ($thisclass['resourceteardowntime'] / 60);
			$teardowniconheight = min(50, $height / 2);
			$class = 'teardown cal-timeslot ts_slot';
			
			$result .= "<div class=\"$class\" style=\"position: absolute; top: $start$tu; height: $height$tu; min-height: $height$tu; left: $left$vu; width: $width$vu; border-top: none\"><div class=\"teardownicon\">
			<img src=\"../images/stepladder2.png\" height=\"$teardowniconheight$tu\"></div></div>";
			$result .= $printable ? '' : "</a><!-- Line ".__LINE__."-->";
		}

		$found_row = true;
	}
	$result .= '</div><!-- End of main grid div -->';
	$result .= '</div><!-- End of dummy div to keep accordion quiet -->';
	return $result;
}


?>